/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.bin.Console;
import jalview.gui.JalviewDialog;
import jalview.gui.RestInputParamEditDialog;
import jalview.io.packed.DataProvider;
import jalview.jbgui.GRestServiceEditorPane;
import jalview.util.MessageManager;
import jalview.ws.rest.InputType;
import jalview.ws.rest.RestServiceDescription;
import jalview.ws.rest.clientdefs.ShmrRestClient;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RestServiceEditorPane
extends GRestServiceEditorPane {
    RestServiceDescription currentservice = null;
    RestServiceDescription oldservice = null;
    Vector<String> _iparam = new Vector();
    Vector<String> _rparam = new Vector();
    String finalService = null;

    public RestServiceEditorPane() {
        this.urldesc.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                RestServiceEditorPane.this.refreshCutnPaste(true);
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
        this.panels.addChangeListener(new ChangeListener(){
            Object lastComp;

            @Override
            public void stateChanged(ChangeEvent e) {
                if (this.lastComp != RestServiceEditorPane.this.paste) {
                    RestServiceEditorPane.this.updateServiceFromGui();
                    RestServiceEditorPane.this.refreshCutnPaste(false);
                } else {
                    RestServiceEditorPane.this.refreshCutnPaste(true);
                }
                this.lastComp = RestServiceEditorPane.this.panels.getSelectedComponent();
            }
        });
        this.currentservice = new RestServiceDescription("Analysis", "service description", "service name", "http://localhost/", "", null, false, false, '-');
        this.initGuiWith(this.currentservice);
        this.refreshCutnPaste(false);
        this.updateButtons();
    }

    public RestServiceEditorPane(RestServiceDescription toedit) {
        this();
        this.oldservice = toedit;
        this.currentservice = this.oldservice != null ? new RestServiceDescription(toedit) : new RestServiceDescription("Analysis", "service description", "service name", "http://localhost/", "", null, false, false, '-');
        this.initGuiWith(this.currentservice);
        this.refreshCutnPaste(false);
        this.updateButtons();
    }

    public void updateButtons() {
        this.cancelButton.setEnabled(true);
        this.okButton.setEnabled(this.currentservice != null && this.currentservice.isValid());
    }

    private void initGuiWith(RestServiceDescription currentservice) {
        this._iparam.clear();
        this._rparam.clear();
        this.action.removeAllItems();
        this.action.addItem("Alignment");
        this.action.addItem("Analysis");
        this.gapChar.removeAllItems();
        this.gapChar.addItem(".");
        this.gapChar.addItem(" ");
        this.gapChar.addItem("-");
        if (currentservice == null) {
            this.name.setText("");
            this.descr.setText("");
            this.url.setText("");
            this.urlsuff.setText("");
            this.action.setSelectedItem("Analysis");
            this.gapChar.setSelectedItem("-");
        } else {
            this.name.setText(currentservice.getName());
            this.descr.setText(currentservice.getDescription());
            this.url.setText(currentservice.getPostUrl());
            this.urlsuff.setText(currentservice.getUrlSuffix());
            for (Map.Entry<String, InputType> inparam : currentservice.getInputParams().entrySet()) {
                this._iparam.add(inparam.getKey() + " " + inparam.getValue().getURLtokenPrefix() + ":" + inparam.getValue().getURLEncodedParameter().toString());
            }
            for (DataProvider.JvDataType oparam : currentservice.getResultDataTypes()) {
                this._rparam.add(oparam.name());
            }
            this.iprms.setListData(this._iparam);
            this.rdata.setListData(this._rparam);
            this.action.setSelectedItem(currentservice.getAction());
            this.gapChar.setSelectedItem("" + currentservice.getGapCharacter());
        }
        this.revalidate();
    }

    private String getSelectedInputToken() {
        if (this.iprms.getSelectedIndex() > -1) {
            String toktoedit = (String)this.iprms.getSelectedValue();
            toktoedit = toktoedit.substring(0, toktoedit.indexOf(" "));
            return toktoedit;
        }
        return null;
    }

    @Override
    protected void iprmListSelection_doubleClicked() {
        String toktoedit = this.getSelectedInputToken();
        if (toktoedit != null) {
            InputType toedit = this.currentservice.getInputParams().get(toktoedit);
            String oldParam = toktoedit;
            RestInputParamEditDialog dialog = new RestInputParamEditDialog(this, this.currentservice, toedit);
            if (dialog.wasUpdated()) {
                this.currentservice.getInputParams().remove(oldParam);
                this.currentservice.getInputParams().put(dialog.current.token, dialog.current);
                this.initGuiWith(this.currentservice);
            }
        }
    }

    @Override
    protected void iprmsAdd_actionPerformed(ActionEvent e) {
        RestInputParamEditDialog dialog = new RestInputParamEditDialog(this, this.currentservice, "param" + (1 + this.currentservice.getInputParams().size()));
        if (dialog.wasUpdated()) {
            this.currentservice.getInputParams().put(dialog.current.token, dialog.current);
            this.initGuiWith(this.currentservice);
        }
    }

    @Override
    protected void iprmsRem_actionPerformed(ActionEvent e) {
        String toktoedit = this.getSelectedInputToken();
        if (toktoedit != null) {
            this.currentservice.getInputParams().remove(toktoedit);
            this.initGuiWith(this.currentservice);
        }
    }

    @Override
    protected void rdata_rightClicked(MouseEvent mouse) {
        final int rdatasel = this.rdata.getSelectedIndex();
        if (rdatasel > -1) {
            JPopupMenu popup = new JPopupMenu(MessageManager.getString("label.select_return_type"));
            for (final DataProvider.JvDataType type : DataProvider.JvDataType.values()) {
                popup.add(new JMenuItem(type.name())).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        RestServiceEditorPane.this.currentservice.getResultDataTypes().set(rdatasel, type);
                        RestServiceEditorPane.this.initGuiWith(RestServiceEditorPane.this.currentservice);
                        RestServiceEditorPane.this.rdata.setSelectedIndex(rdatasel);
                    }
                });
            }
            popup.show(this.rdata, mouse.getX(), mouse.getY());
        }
    }

    @Override
    protected void rdataAdd_actionPerformed(ActionEvent e) {
        int p = this.rdata.getSelectedIndex();
        if (p > -1) {
            this.currentservice.getResultDataTypes().add(p + 1, DataProvider.JvDataType.ANNOTATION);
        } else {
            this.currentservice.addResultDatatype(DataProvider.JvDataType.ANNOTATION);
        }
        this.initGuiWith(this.currentservice);
        this.rdata.setSelectedIndex(p == -1 ? this.currentservice.getResultDataTypes().size() - 1 : p + 1);
    }

    @Override
    protected void rdataNdown_actionPerformed(ActionEvent e) {
        int p = this.rdata.getSelectedIndex();
        if (p > -1 && p < this._rparam.size() - 1) {
            List<DataProvider.JvDataType> rtypes = this.currentservice.getResultDataTypes();
            DataProvider.JvDataType below = rtypes.get(p + 1);
            rtypes.set(p + 1, rtypes.get(p));
            rtypes.set(p, below);
            this.initGuiWith(this.currentservice);
            this.rdata.setSelectedIndex(p + 1);
        }
    }

    @Override
    protected void rdataNup_actionPerformed(ActionEvent e) {
        int p = this.rdata.getSelectedIndex();
        if (p > 0) {
            List<DataProvider.JvDataType> rtypes = this.currentservice.getResultDataTypes();
            DataProvider.JvDataType above = rtypes.get(p - 1);
            rtypes.set(p - 1, rtypes.get(p));
            rtypes.set(p, above);
            this.initGuiWith(this.currentservice);
            this.rdata.setSelectedIndex(p - 1);
        }
    }

    @Override
    protected void rdataRem_actionPerformed(ActionEvent e) {
        if (this.rdata.getSelectedIndex() > -1) {
            this.currentservice.getResultDataTypes().remove(this.rdata.getSelectedIndex());
            this.initGuiWith(this.currentservice);
        }
    }

    private boolean updateServiceFromGui() {
        HashMap<String, InputType> inputTypes = new HashMap<String, InputType>();
        StringBuffer warnings = new StringBuffer();
        for (String its : this._iparam) {
            Matcher mtch = Pattern.compile("(\\S+)\\s(\\S+):\\[(.+)]").matcher(its);
            if (!mtch.find() || RestServiceDescription.parseTypeString(mtch.group(2) + ":" + mtch.group(3), mtch.group(1), mtch.group(2), mtch.group(3), inputTypes, warnings)) continue;
            Console.errPrintln("IMPLEMENTATION PROBLEM: Cannot parse RestService input parameter string '" + its + "'\n" + warnings);
        }
        char gc = this.gapChar.getSelectedItem() == null ? (char)' ' : (char)((String)this.gapChar.getSelectedItem()).charAt(0);
        RestServiceDescription newService = new RestServiceDescription((String)this.action.getSelectedItem(), this.descr.getText().trim(), this.name.getText().trim(), this.url.getText().trim(), this.urlsuff.getText().trim(), inputTypes, this.hSeparable.isSelected(), this.vSeparable.isSelected(), gc);
        if (newService.isValid()) {
            for (String its : this._rparam) {
                try {
                    DataProvider.JvDataType dtype = DataProvider.JvDataType.valueOf(its);
                    newService.addResultDatatype(dtype);
                }
                catch (Throwable x) {
                    Console.errPrintln("IMPLEMENTATION PROBLEM: Cannot parse RestService output parameter string '" + its + "'\n" + warnings);
                }
            }
            this.currentservice = newService;
            return true;
        }
        Console.errPrintln("IMPLEMENTATION PROBLEM: Restservice generated from GUI is invalid\n" + warnings);
        return false;
    }

    protected void refreshCutnPaste(boolean reparse) {
        if (!reparse && this.currentservice.isValid()) {
            this.urldesc.setText(this.currentservice.toString());
            this.parseWarnings.setVisible(false);
        } else if (reparse) {
            String txt = this.urldesc.getText().trim();
            if (txt.length() > 0) {
                RestServiceDescription rsd = null;
                try {
                    rsd = new RestServiceDescription(txt);
                    if (rsd.isValid()) {
                        this.parseWarnings.setVisible(false);
                        this.parseRes.setText("");
                        this.currentservice = rsd;
                        this.initGuiWith(this.currentservice);
                    } else {
                        this.parseRes.setText(MessageManager.formatMessage("label.parsing_failed_syntax_errors_shown_below_param", new String[]{rsd.getInvalidMessage()}));
                        this.parseWarnings.setVisible(true);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    this.parseRes.setText(MessageManager.formatMessage("label.parsing_failed_unrecoverable_exception_thrown_param", new String[]{e.toString()}));
                    this.parseWarnings.setVisible(true);
                }
            }
            this.paste.revalidate();
        }
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            new Thread(new Runnable(){
                boolean visible = true;

                @Override
                public void run() {
                    boolean nulserv = true;
                    while (this.visible) {
                        final Thread runner = Thread.currentThread();
                        JFrame df = new JFrame();
                        df.getContentPane().setLayout(new BorderLayout());
                        nulserv = !nulserv;
                        df.getContentPane().add((Component)(nulserv ? new RestServiceEditorPane(ShmrRestClient.makeShmmrRestClient().getRestDescription()) : new RestServiceEditorPane()), "Center");
                        df.setBounds(100, 100, 600, 400);
                        df.addComponentListener(new ComponentListener(){

                            @Override
                            public void componentShown(ComponentEvent e) {
                            }

                            @Override
                            public void componentResized(ComponentEvent e) {
                            }

                            @Override
                            public void componentMoved(ComponentEvent e) {
                            }

                            @Override
                            public void componentHidden(ComponentEvent e) {
                                visible = false;
                                runner.interrupt();
                            }
                        });
                        df.setVisible(true);
                        while (this.visible) {
                            try {
                                Thread.sleep(10000L);
                            }
                            catch (Exception exception) {}
                        }
                        this.visible = true;
                    }
                }
            }).start();
        }
    }

    public void showDialog(String title) {
        if (this.oldservice != null) {
            this.finalService = this.oldservice.toString();
        }
        JalviewDialog jvd = new JalviewDialog(){

            @Override
            protected void raiseClosed() {
            }

            @Override
            protected void okPressed() {
                RestServiceEditorPane.this.updateServiceFromGui();
                RestServiceEditorPane.this.finalService = RestServiceEditorPane.this.currentservice.toString();
            }

            @Override
            protected void cancelPressed() {
            }
        };
        JPanel pane = new JPanel(new BorderLayout());
        JPanel okcancel = new JPanel(new FlowLayout());
        pane.add((Component)this, "Center");
        okcancel.add(jvd.ok);
        okcancel.add(jvd.cancel);
        pane.add((Component)okcancel, "South");
        jvd.initDialogFrame(pane, true, true, title, 600, 350);
        jvd.waitForInput();
    }

    public String getEditedRestService() {
        return this.finalService;
    }
}

