/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.bin.Console;
import jalview.gui.IProgressIndicator;
import jalview.gui.IProgressIndicatorHandler;
import jalview.util.MessageManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class ProgressBar
implements IProgressIndicator {
    Map<Long, JPanel> progressBars;
    Map<Long, String> progressBarMessages;
    Map<Long, IProgressIndicatorHandler> progressBarHandlers;
    private JPanel statusPanel;
    private JLabel statusBar;

    public ProgressBar(JPanel container, JLabel statusBar) {
        if (container == null) {
            throw new NullPointerException();
        }
        if (!GridLayout.class.isAssignableFrom(container.getLayout().getClass())) {
            throw new IllegalArgumentException("Container must have GridLayout");
        }
        this.statusPanel = container;
        this.statusBar = statusBar;
        this.progressBars = new Hashtable<Long, JPanel>();
        this.progressBarHandlers = new Hashtable<Long, IProgressIndicatorHandler>();
        this.progressBarMessages = new Hashtable<Long, String>();
    }

    @Override
    public boolean operationInProgress() {
        return this.progressBars != null && this.progressBars.size() > 0;
    }

    @Override
    public void setProgressBar(final String message, final long id) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ProgressBar.this.progressBars.containsKey(id)) {
                    ProgressBar.this.removeProgressBar(id);
                    if (message != null && ProgressBar.this.statusBar != null) {
                        ProgressBar.this.statusBar.setText(message);
                    }
                } else {
                    ProgressBar.this.addProgressBar(id, message);
                }
            }
        });
    }

    @Override
    public void addProgressBar(long id, String message) {
        if (this.progressBars.containsKey(id)) {
            return;
        }
        JPanel progressPanel = new JPanel(new BorderLayout(10, 5));
        this.progressBars.put(id, progressPanel);
        this.progressBarMessages.put(id, message == null ? "" : message);
        Runnable r = () -> {
            JProgressBar progressBar = new JProgressBar();
            progressBar.setIndeterminate(true);
            progressPanel.add((Component)new JLabel(message == null ? "" : message), "West");
            progressPanel.add((Component)progressBar, "Center");
            this.addRow(progressPanel);
            this.refreshLayout();
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    @Override
    public void removeProgressBar(long id) {
        JPanel progressPanel = this.progressBars.remove(id);
        this.progressBarMessages.remove(id);
        if (progressPanel == null) {
            return;
        }
        this.progressBarHandlers.remove(id);
        Runnable r = () -> {
            this.removeRow(progressPanel);
            this.refreshLayout();
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    protected void refreshLayout() {
        Component root = SwingUtilities.getRoot(this.statusPanel);
        if (root != null) {
            root.validate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeRow(JPanel progressPanel) {
        JPanel jPanel = this.statusPanel;
        synchronized (jPanel) {
            this.statusPanel.remove(progressPanel);
            GridLayout layout = (GridLayout)this.statusPanel.getLayout();
            layout.setRows(layout.getRows() - 1);
            this.statusPanel.remove(progressPanel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addRow(JPanel progressPanel) {
        JPanel jPanel = this.statusPanel;
        synchronized (jPanel) {
            GridLayout layout = (GridLayout)this.statusPanel.getLayout();
            layout.setRows(layout.getRows() + 1);
            this.statusPanel.add(progressPanel);
        }
    }

    @Override
    public void registerHandler(final long id, final IProgressIndicatorHandler handler) {
        final ProgressBar us = this;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                final JPanel progressPanel = ProgressBar.this.progressBars.get(id);
                if (progressPanel == null) {
                    Console.errPrintln("call setProgressBar before registering the progress bar's handler.");
                    return;
                }
                ProgressBar.this.progressBarHandlers.put(id, handler);
                JButton cancel = new JButton(MessageManager.getString("action.cancel"));
                cancel.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        handler.cancelActivity(id);
                        us.setProgressBar(MessageManager.formatMessage("label.cancelled_params", ((JLabel)progressPanel.getComponent(0)).getText()), id);
                    }
                });
                progressPanel.add((Component)cancel, "East");
                ProgressBar.this.updateCancelHandler(progressPanel, handler);
            }
        });
    }

    protected void updateCancelHandler(Container progressPanel, IProgressIndicatorHandler handler) {
        for (Component j : progressPanel.getComponents()) {
            if (!(j instanceof JButton)) continue;
            j.setEnabled(handler.canCancel());
        }
        this.refreshLayout();
    }

    @Override
    public JProgressBar getProgressBar(long id) {
        Container progBar = this.progressBars.get(id);
        if (progBar == null || progBar.getComponentCount() == 0) {
            return null;
        }
        for (Component component : progBar.getComponents()) {
            if (!component.getClass().equals(JProgressBar.class)) continue;
            return (JProgressBar)component;
        }
        return null;
    }

    @Override
    public String getMessage(long id) {
        return this.progressBarMessages.get(id);
    }

    @Override
    public void setProgressBarMessage(long id, String message) {
        Container progBar = this.progressBars.get(id);
        if (progBar == null || progBar.getComponentCount() == 0) {
            return;
        }
        for (Component component : progBar.getComponents()) {
            if (!component.getClass().equals(JLabel.class)) continue;
            ((JLabel)component).setText(message);
            IProgressIndicatorHandler handler = this.progressBarHandlers.get(id);
            if (handler != null) {
                this.updateCancelHandler(progBar, handler);
                continue;
            }
            this.refreshLayout();
        }
    }
}

