/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.bin.Console;
import jalview.gui.JalviewDialog;
import jalview.gui.JvSwingUtils;
import jalview.util.MessageManager;
import jalview.util.QuickSort;
import jalview.ws.SequenceFetcher;
import jalview.ws.seqfetcher.DbSourceProxy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class JDatabaseTree
extends JalviewDialog
implements KeyListener {
    boolean allowMultiSelections = false;
    public int action;
    JScrollPane svp;
    JTree dbviews;
    private SequenceFetcher sfetcher;
    private JLabel dbstatus;
    private JLabel dbstatex;
    private JPanel mainPanel = new JPanel(new BorderLayout());
    List<DbSourceProxy> oldselection;
    List<DbSourceProxy> selection = null;
    TreePath[] tsel = null;
    TreePath[] oldtsel = null;
    boolean handleSelections = true;
    List<ActionListener> lstners = new Vector<ActionListener>();

    JButton getDatabaseSelectorButton() {
        JButton viewdbs = new JButton(MessageManager.getString("action.select_ddbb"));
        viewdbs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JDatabaseTree.this.showDialog();
            }
        });
        return viewdbs;
    }

    public JDatabaseTree(SequenceFetcher sfetch) {
        int i;
        this.mainPanel.add(this);
        this.initDialogFrame(this.mainPanel, true, false, MessageManager.getString("label.select_database_retrieval_source"), 650, 490);
        DefaultMutableTreeNode tn = null;
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        Hashtable<String, DefaultMutableTreeNode> source = new Hashtable<String, DefaultMutableTreeNode>();
        this.sfetcher = sfetch;
        String[] dbs = sfetch.getSupportedDb();
        Hashtable<String, String> ht = new Hashtable<String, String>();
        for (i = 0; i < dbs.length; ++i) {
            tn = (DefaultMutableTreeNode)source.get(dbs[i]);
            List<DbSourceProxy> srcs = sfetch.getSourceProxy(dbs[i]);
            if (tn == null) {
                tn = new DefaultMutableTreeNode(dbs[i], true);
                source.put(dbs[i], tn);
            }
            for (DbSourceProxy dbp : srcs) {
                if (ht.get(dbp.getDbName()) == null) {
                    tn.add(new DefaultMutableTreeNode(dbp, false));
                    ht.put(dbp.getDbName(), dbp.getDbName());
                    continue;
                }
                Console.errPrintln("dupe ig for : " + dbs[i] + " \t" + dbp.getDbName() + " (" + dbp.getDbSource() + ")");
                source.remove(tn);
            }
        }
        for (i = 0; i < dbs.length; ++i) {
            tn = (DefaultMutableTreeNode)source.get(dbs[i]);
            if (tn == null) continue;
            if (tn.getChildCount() == 1) {
                DefaultMutableTreeNode ttn = (DefaultMutableTreeNode)tn.getChildAt(0);
                tn.setUserObject(ttn.getUserObject());
                tn.removeAllChildren();
                source.put(dbs[i], tn);
                tn.setAllowsChildren(false);
            }
            root.add(tn);
        }
        this.sortTreeNodes(root);
        this.dbviews = new JTree(new DefaultTreeModel(root, false));
        this.dbviews.setCellRenderer(new DbTreeRenderer(this));
        this.dbviews.getSelectionModel().setSelectionMode(1);
        this.svp = new JScrollPane(this.dbviews);
        this.svp.setMinimumSize(new Dimension(100, 200));
        this.svp.setPreferredSize(new Dimension(200, 400));
        this.svp.setMaximumSize(new Dimension(300, 600));
        JPanel panel = new JPanel(new BorderLayout());
        panel.setSize(new Dimension(350, 220));
        panel.add(this.svp);
        this.dbviews.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent arg0) {
                JDatabaseTree.this._setSelectionState();
            }
        });
        this.dbviews.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    JDatabaseTree.this.okPressed();
                    JDatabaseTree.this.closeDialog();
                }
            }
        });
        JPanel jc = new JPanel(new BorderLayout());
        JPanel j = new JPanel(new FlowLayout());
        jc.add((Component)this.svp, "Center");
        JPanel dbstat = new JPanel(new GridLayout(2, 1));
        this.dbstatus = new JLabel(" ");
        Font f = JvSwingUtils.getLabelFont(false, true);
        this.dbstatus.setFont(f);
        this.dbstatus.setSize(new Dimension(290, 50));
        this.dbstatex = new JLabel(" ");
        this.dbstatex.setFont(f);
        this.dbstatex.setSize(new Dimension(290, 50));
        dbstat.add(this.dbstatus);
        dbstat.add(this.dbstatex);
        jc.add((Component)dbstat, "South");
        jc.validate();
        this.add((Component)jc, "Center");
        this.ok.setEnabled(false);
        j.add(this.ok);
        j.add(this.cancel);
        this.add((Component)j, "South");
        this.dbviews.addKeyListener(this);
        this.validate();
    }

    private void sortTreeNodes(DefaultMutableTreeNode root) {
        int i;
        if (root.getChildCount() == 0) {
            return;
        }
        int count = root.getChildCount();
        String[] names = new String[count];
        Object[] nodes = new DefaultMutableTreeNode[count];
        for (i = 0; i < count; ++i) {
            TreeNode node = root.getChildAt(i);
            if (node instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)node;
                nodes[i] = child;
                if (child.getUserObject() instanceof DbSourceProxy) {
                    names[i] = ((DbSourceProxy)child.getUserObject()).getDbName().toLowerCase(Locale.ROOT);
                    continue;
                }
                names[i] = ((String)child.getUserObject()).toLowerCase(Locale.ROOT);
                this.sortTreeNodes(child);
                continue;
            }
            throw new Error(MessageManager.getString("error.implementation_error_cant_reorder_tree"));
        }
        QuickSort.sort(names, nodes);
        root.removeAllChildren();
        for (i = count - 1; i >= 0; --i) {
            root.add((MutableTreeNode)nodes[i]);
        }
    }

    @Override
    protected void raiseClosed() {
        for (ActionListener al : this.lstners) {
            al.actionPerformed(null);
        }
    }

    @Override
    protected void okPressed() {
        this._setSelectionState();
    }

    @Override
    protected void cancelPressed() {
        this.selection = this.oldselection;
        this.tsel = this.oldtsel;
        this._revertSelectionState();
        this.closeDialog();
    }

    void showDialog() {
        this.oldselection = this.selection;
        this.oldtsel = this.tsel;
        this.validate();
        this.waitForInput();
    }

    public boolean hasSelection() {
        return this.selection == null ? false : this.selection.size() != 0;
    }

    public List<DbSourceProxy> getSelectedSources() {
        return this.selection;
    }

    private void _setSelectionState() {
        if (!this.handleSelections) {
            return;
        }
        this.ok.setEnabled(false);
        if (this.dbviews.getSelectionCount() == 0) {
            this.selection = null;
        }
        this.tsel = this.dbviews.getSelectionPaths();
        boolean forcedFirstChild = false;
        ArrayList<DbSourceProxy> srcs = new ArrayList<DbSourceProxy>();
        if (this.tsel != null) {
            for (TreePath tp : this.tsel) {
                DefaultMutableTreeNode dmt = (DefaultMutableTreeNode)tp.getLastPathComponent();
                if (dmt.getUserObject() == null) continue;
                this.ok.setEnabled(true);
                if (dmt.getUserObject() instanceof DbSourceProxy) {
                    srcs.add((DbSourceProxy)dmt.getUserObject());
                    continue;
                }
                if (this.allowMultiSelections) {
                    srcs.addAll(this.sfetcher.getSourceProxy((String)dmt.getUserObject()));
                    continue;
                }
                srcs.add(this.sfetcher.getSourceProxy((String)dmt.getUserObject()).get(0));
                forcedFirstChild = true;
            }
        }
        this.updateDbStatus(srcs, forcedFirstChild);
        this.selection = srcs;
    }

    private void _revertSelectionState() {
        this.handleSelections = false;
        if (this.selection == null || this.selection.size() == 0) {
            this.dbviews.clearSelection();
        } else {
            this.dbviews.setSelectionPaths(this.tsel);
        }
        this.handleSelections = true;
    }

    private void updateDbStatus(List<DbSourceProxy> srcs, boolean forcedFirstChild) {
        int x = 0;
        String nm = "";
        String qr = "";
        for (DbSourceProxy dbs : srcs) {
            String tq = dbs.getTestQuery();
            nm = dbs.getDbName();
            if (tq == null || tq.trim().length() <= 0 || !dbs.isValidReference(tq)) continue;
            qr = tq;
            ++x;
        }
        this.dbstatex.setText(" ");
        if (this.allowMultiSelections) {
            String[] stringArray = new String[3];
            stringArray[0] = Integer.valueOf(srcs.size()).toString();
            String string = stringArray[1] = srcs.size() == 1 ? "" : "s";
            stringArray[2] = srcs.size() > 0 ? " with " + x + " test quer" + (x == 1 ? "y" : "ies") : ".";
            this.dbstatus.setText(MessageManager.formatMessage("label.selected_database_to_fetch_from", stringArray));
        } else if (nm.length() > 0) {
            this.dbstatus.setText(MessageManager.formatMessage("label.database_param", new String[]{nm}));
            if (qr.length() > 0) {
                this.dbstatex.setText(MessageManager.formatMessage("label.example_param", new String[]{qr}));
            }
        } else {
            this.dbstatus.setText(" ");
        }
        this.dbstatus.invalidate();
        this.dbstatex.invalidate();
    }

    public String getSelectedItem() {
        if (this.hasSelection()) {
            return this.getSelectedSources().get(0).getDbName();
        }
        return null;
    }

    public String getExampleQueries() {
        if (!this.hasSelection()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        HashSet<String> hs = new HashSet<String>();
        for (DbSourceProxy dbs : this.getSelectedSources()) {
            String tq = dbs.getTestQuery();
            if (!hs.add(tq)) continue;
            if (sb.length() > 0) {
                sb.append(";");
            }
            sb.append(tq);
        }
        return sb.toString();
    }

    public void addActionListener(ActionListener actionListener) {
        this.lstners.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.lstners.remove(actionListener);
    }

    @Override
    public void keyPressed(KeyEvent arg0) {
        if (!arg0.isConsumed() && arg0.getKeyCode() == 10) {
            this.action = arg0.getKeyCode();
            this.okPressed();
            this.closeDialog();
        }
        if (!arg0.isConsumed() && arg0.getKeyChar() == '\u001b') {
            this.action = arg0.getKeyCode();
            this.cancelPressed();
        }
    }

    @Override
    public void keyReleased(KeyEvent arg0) {
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }

    @Override
    public void setVisible(boolean arg0) {
        Console.outPrintln("setVisible: " + arg0);
        super.setVisible(arg0);
    }

    private class DbTreeRenderer
    extends DefaultTreeCellRenderer
    implements TreeCellRenderer {
        JDatabaseTree us;

        public DbTreeRenderer(JDatabaseTree me) {
            this.us = me;
            ToolTipManager.sharedInstance().registerComponent(JDatabaseTree.this.dbviews);
        }

        private Component returnLabel(String txt) {
            JLabel jl = new JLabel(txt);
            jl.setFont(JvSwingUtils.getLabelFont());
            return jl;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            String val = "";
            if (value != null && value instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode vl = (DefaultMutableTreeNode)value;
                if ((value = vl.getUserObject()) instanceof DbSourceProxy) {
                    val = ((DbSourceProxy)value).getDbName();
                    if (((DbSourceProxy)value).getDescription() != null) {
                        this.setToolTipText(((DbSourceProxy)value).getDescription());
                    }
                } else if (value instanceof String) {
                    val = (String)value;
                }
            }
            if (value == null) {
                val = "";
            }
            return super.getTreeCellRendererComponent(tree, val, selected, expanded, leaf, row, hasFocus);
        }
    }
}

