/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.datamodel.SequenceI;
import jalview.gui.AlignViewport;
import jalview.gui.AlignmentPanel;
import jalview.gui.AnnotationLabels;
import jalview.gui.AnnotationPanel;
import jalview.gui.PaintRefresher;
import jalview.gui.SeqCanvas;
import jalview.viewmodel.ViewportListenerI;
import jalview.viewmodel.ViewportRanges;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.util.List;
import javax.swing.JPanel;

public class IdCanvas
extends JPanel
implements ViewportListenerI {
    protected AlignViewport av;
    protected boolean showScores = true;
    protected int maxIdLength = -1;
    protected String maxIdStr = null;
    BufferedImage image;
    int imgHeight = 0;
    private boolean fastPaint = false;
    List<SequenceI> searchResults;
    AnnotationPanel ap;
    private Font idfont;
    private boolean allowFastPaint;
    private boolean manuallyAdjusted = false;

    public IdCanvas(AlignViewport av) {
        this.setLayout(new BorderLayout());
        this.av = av;
        PaintRefresher.Register(this, av.getSequenceSetId());
        av.getRanges().addPropertyChangeListener(this);
    }

    public void drawIdString(Graphics2D g, boolean hiddenRows, SequenceI s, int i, int starty, int ypos) {
        int xPos = 0;
        int panelWidth = this.getWidth();
        int charHeight = this.av.getCharHeight();
        if (this.searchResults != null && this.searchResults.contains(s)) {
            g.setColor(Color.black);
            g.fillRect(0, (i - starty) * charHeight + ypos, this.getWidth(), charHeight);
            g.setColor(Color.white);
        } else if (this.av.getSelectionGroup() != null && this.av.getSelectionGroup().getSequences(null).contains(s)) {
            g.setColor(Color.lightGray);
            g.fillRect(0, (i - starty) * charHeight + ypos, this.getWidth(), charHeight);
            g.setColor(Color.white);
        } else {
            g.setColor(this.av.getSequenceColour(s));
            g.fillRect(0, (i - starty) * charHeight + ypos, this.getWidth(), charHeight);
            g.setColor(Color.black);
        }
        if (this.av.isRightAlignIds()) {
            FontMetrics fm = g.getFontMetrics();
            xPos = panelWidth - fm.stringWidth(s.getDisplayId(this.av.getShowJVSuffix())) - 4;
        }
        g.drawString(s.getDisplayId(this.av.getShowJVSuffix()), xPos, (i - starty + 1) * charHeight + ypos - charHeight / 5);
        if (hiddenRows && this.av.getShowHiddenMarkers()) {
            this.drawMarker(g, this.av, i, starty, ypos);
        }
    }

    public void fastPaint(int vertical) {
        if (this.image == null || this.av.getWrapAlignment()) {
            this.repaint();
            return;
        }
        ViewportRanges ranges = this.av.getRanges();
        Graphics2D gg = this.image.createGraphics();
        gg.copyArea(0, 0, this.getWidth(), this.imgHeight, 0, -vertical * this.av.getCharHeight());
        int ss = ranges.getStartSeq();
        int es = ranges.getEndSeq();
        int transY = 0;
        if (vertical > 0) {
            ss = es - vertical;
            if (ss < ranges.getStartSeq()) {
                ss = ranges.getStartSeq();
            } else {
                transY = this.imgHeight - (vertical + 1) * this.av.getCharHeight();
            }
        } else if (vertical < 0 && (es = ss - vertical) > ranges.getEndSeq()) {
            es = ranges.getEndSeq();
        }
        gg.translate(0, transY);
        this.drawIds(gg, this.av, ss, es, this.searchResults, true, this.getWidth());
        gg.translate(0, -transY);
        gg.dispose();
        this.fastPaint = true;
        ((AlignmentPanel)this.av.getAlignPanel()).repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        if (((AlignmentPanel)this.av.getAlignPanel()).getHoldRepaint()) {
            return;
        }
        g.setColor(Color.white);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.allowFastPaint && this.fastPaint) {
            this.fastPaint = false;
            g.drawImage(this.image, 0, 0, this);
            return;
        }
        int oldHeight = this.imgHeight;
        this.imgHeight = this.getHeight();
        this.imgHeight -= this.imgHeight % this.av.getCharHeight();
        if (this.imgHeight < 1) {
            return;
        }
        if (oldHeight != this.imgHeight || this.image.getWidth(this) != this.getWidth()) {
            this.image = new BufferedImage(this.getWidth(), this.imgHeight, 1);
        }
        Graphics2D gg = this.image.createGraphics();
        gg.setColor(Color.white);
        gg.fillRect(0, 0, this.getWidth(), this.imgHeight);
        this.drawIds(gg, this.av, this.av.getRanges().getStartSeq(), this.av.getRanges().getEndSeq(), this.searchResults, true, this.getWidth());
        gg.dispose();
        g.drawImage(this.image, 0, 0, this);
    }

    void drawIds(Graphics2D g, AlignViewport alignViewport, int startSeq, int endSeq, List<SequenceI> selection, boolean forGUI, int panelWidth) {
        Font font = alignViewport.getFont();
        if (alignViewport.isSeqNameItalics()) {
            this.setIdfont(new Font(font.getName(), 2, font.getSize()));
        } else {
            this.setIdfont(font);
        }
        g.setFont(this.getIdfont());
        FontMetrics fm = g.getFontMetrics();
        if (alignViewport.antiAlias) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        Color currentColor = Color.white;
        Color currentTextColor = Color.black;
        boolean hasHiddenRows = alignViewport.hasHiddenRows();
        if (alignViewport.getWrapAlignment()) {
            this.drawIdsWrapped(g, alignViewport, startSeq, this.getHeight(), this.isManuallyAdjusted() ? panelWidth : -1, forGUI);
            return;
        }
        int xPos = 0;
        for (int i = startSeq; i <= endSeq; ++i) {
            SequenceI sequence = alignViewport.getAlignment().getSequenceAt(i);
            if (sequence == null) continue;
            if (hasHiddenRows || alignViewport.isDisplayReferenceSeq()) {
                g.setFont(this.getHiddenFont(sequence, alignViewport));
                fm = g.getFontMetrics();
            }
            if (selection != null && selection.contains(sequence)) {
                currentColor = Color.black;
                currentTextColor = Color.white;
            } else if (alignViewport.getSelectionGroup() != null && alignViewport.getSelectionGroup().getSequences(null).contains(sequence)) {
                currentColor = Color.lightGray;
                currentTextColor = Color.black;
            } else {
                currentColor = alignViewport.getSequenceColour(sequence);
                currentTextColor = Color.black;
            }
            g.setColor(currentColor);
            int charHeight = alignViewport.getCharHeight();
            g.fillRect(0, (i - startSeq) * charHeight, this.getWidth(), charHeight);
            g.setColor(currentTextColor);
            String string = sequence.getDisplayId(alignViewport.getShowJVSuffix());
            if (alignViewport.isRightAlignIds()) {
                xPos = panelWidth - fm.stringWidth(string) - 4;
            }
            g.drawString(string, xPos, (i - startSeq) * charHeight + charHeight - charHeight / 5);
            if (!hasHiddenRows || !this.av.getShowHiddenMarkers()) continue;
            this.drawMarker(g, alignViewport, i, startSeq, 0);
        }
    }

    void drawIdsWrapped(Graphics2D g, AlignViewport alignViewport, int startSeq, int pageHeight) {
        this.drawIdsWrapped(g, alignViewport, startSeq, pageHeight, -1, true);
    }

    public void drawIdsWrappedNoGUI(Graphics2D g, AlignViewport av2, int startSeq, int totalHeight) {
        this.drawIdsWrapped(g, av2, startSeq, totalHeight, -1, false);
    }

    public void drawIdsWrapped(Graphics2D g, AlignViewport alignViewport, int startSeq, int pageHeight, int idWidth, boolean forGUI) {
        int alignmentWidth = alignViewport.getAlignment().getWidth();
        int alheight = alignViewport.getAlignment().getHeight();
        SeqCanvas seqCanvas = ((AlignmentPanel)alignViewport.getAlignPanel()).getSeqPanel().seqCanvas;
        seqCanvas.calculateWrappedGeometry();
        int charHeight = alignViewport.getCharHeight();
        AnnotationLabels labels = null;
        if (alignViewport.isShowAnnotation()) {
            if (this.ap == null) {
                this.ap = new AnnotationPanel(alignViewport);
            }
            labels = new AnnotationLabels(alignViewport);
        }
        ViewportRanges ranges = alignViewport.getRanges();
        int rowSize = ranges.getViewportWidth();
        boolean hasHiddenRows = alignViewport.hasHiddenRows();
        int ypos = seqCanvas.wrappedSpaceAboveAlignment;
        for (int rowStartRes = ranges.getStartRes(); ypos <= pageHeight && rowStartRes < alignmentWidth; ypos += seqCanvas.wrappedRepeatHeightPx, rowStartRes += rowSize) {
            int getWidth;
            for (int i = startSeq; i < alheight; ++i) {
                SequenceI s = alignViewport.getAlignment().getSequenceAt(i);
                if (hasHiddenRows || alignViewport.isDisplayReferenceSeq()) {
                    g.setFont(this.getHiddenFont(s, alignViewport));
                } else {
                    g.setFont(this.getIdfont());
                }
                this.drawIdString(g, hasHiddenRows, s, i, 0, ypos);
            }
            if (labels == null || !alignViewport.isShowAnnotation()) continue;
            int thisIdWidth = getWidth = this.getWidth();
            g.translate(0, ypos + alheight * charHeight);
            if (!this.isManuallyAdjusted()) {
                int getAnnotationsIdWidth = labels.drawLabels(g, false, -1, false, forGUI, null, false);
                int n = thisIdWidth = idWidth < 0 ? getAnnotationsIdWidth : idWidth;
                if (thisIdWidth > getWidth) {
                    this.setPreferredSize(new Dimension(thisIdWidth, this.getHeight()));
                    this.repaint();
                    alignViewport.setIdWidth(thisIdWidth);
                }
            }
            labels.drawComponent(g, false, thisIdWidth, forGUI);
            g.translate(0, -ypos - alheight * charHeight);
        }
    }

    void drawMarker(Graphics2D g, AlignViewport alignViewport, int seqIndex, int starty, int yoffset) {
        int[] yPoints;
        SequenceI[] hseqs = alignViewport.getAlignment().getHiddenSequences().hiddenSequences;
        int hSize = hseqs.length;
        int hiddenIndex = seqIndex;
        int lastIndex = seqIndex - 1;
        int nextIndex = seqIndex + 1;
        for (int j = 0; j < hSize; ++j) {
            if (hseqs[j] == null) continue;
            if (j - 1 < hiddenIndex) {
                ++hiddenIndex;
            }
            if (j - 1 < lastIndex) {
                ++lastIndex;
            }
            if (j - 1 >= nextIndex) continue;
            ++nextIndex;
        }
        boolean below = hiddenIndex > lastIndex + 1;
        boolean above = nextIndex > hiddenIndex + 1;
        g.setColor(Color.blue);
        int charHeight = this.av.getCharHeight();
        int[] xPoints = new int[]{this.getWidth() - charHeight, this.getWidth() - charHeight, this.getWidth()};
        int yShift = seqIndex - starty;
        if (below) {
            yPoints = new int[]{yShift * charHeight + yoffset, yShift * charHeight + yoffset + charHeight / 4, yShift * charHeight + yoffset};
            g.fillPolygon(xPoints, yPoints, 3);
        }
        if (above) {
            yPoints = new int[]{++yShift * charHeight + yoffset, yShift * charHeight + yoffset - charHeight / 4, yShift * charHeight + yoffset};
            g.fillPolygon(xPoints, yPoints, 3);
        }
    }

    private Font getHiddenFont(SequenceI seq, AlignViewport alignViewport) {
        if (this.av.isReferenceSeq(seq) || this.av.isHiddenRepSequence(seq)) {
            return new Font(this.av.getFont().getName(), 1, this.av.getFont().getSize());
        }
        return this.getIdfont();
    }

    public void setHighlighted(List<SequenceI> list) {
        this.searchResults = list;
        this.repaint();
    }

    public Font getIdfont() {
        return this.idfont;
    }

    public void setIdfont(Font idfont) {
        this.idfont = idfont;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName;
        switch (propertyName = evt.getPropertyName()) {
            case "startseq": {
                this.fastPaint((Integer)evt.getNewValue() - (Integer)evt.getOldValue());
                break;
            }
            case "startres": {
                if (!this.av.getWrapAlignment()) break;
                this.fastPaint((Integer)evt.getNewValue() - (Integer)evt.getOldValue());
                break;
            }
            case "startresandseq": {
                this.fastPaint(((int[])evt.getNewValue())[1] - ((int[])evt.getOldValue())[1]);
                break;
            }
            case "move_viewport": {
                this.repaint();
                break;
            }
        }
    }

    public boolean isManuallyAdjusted() {
        return this.manuallyAdjusted;
    }

    public void setManuallyAdjusted(boolean b) {
        this.manuallyAdjusted = b;
    }

    public void setNoFastPaint() {
        this.allowFastPaint = false;
    }
}

