/*
 * Decompiled with CFR 0.152.
 */
package jalview.ext.ensembl;

import jalview.datamodel.AlignmentI;
import jalview.ext.ensembl.EnsemblRestClient;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.json.simple.parser.ParseException;

public class EnsemblInfo
extends EnsemblRestClient {
    private static Map<String, String> divisions;

    @Override
    public String getDbName() {
        return "ENSEMBL";
    }

    @Override
    public AlignmentI getSequenceRecords(String queries) throws Exception {
        return null;
    }

    @Override
    protected URL getUrl(List<String> ids) throws MalformedURLException {
        return null;
    }

    @Override
    protected boolean useGetRequest() {
        return true;
    }

    public String getDomain(String division) {
        if (divisions == null) {
            this.fetchDivisions();
        }
        return divisions.get(division.toUpperCase(Locale.ROOT));
    }

    void fetchDivisions() {
        divisions = new HashMap<String, String>();
        divisions.put("ENSEMBL".toUpperCase(Locale.ROOT), this.ensemblDomain);
        try {
            Iterator rvals = (Iterator)this.getJSON(this.getDivisionsUrl(this.ensemblGenomesDomain), null, -1, 2, null);
            if (rvals == null) {
                return;
            }
            while (rvals.hasNext()) {
                String division = rvals.next().toString();
                divisions.put(division.toUpperCase(Locale.ROOT), this.ensemblGenomesDomain);
            }
        }
        catch (IOException | NumberFormatException | ParseException exception) {
            // empty catch block
        }
    }

    URL getDivisionsUrl(String domain) throws MalformedURLException {
        return new URL(domain + "/info/divisions?content-type=application/json");
    }

    public Set<String> getDivisions() {
        if (divisions == null) {
            this.fetchDivisions();
        }
        return divisions.keySet();
    }
}

