/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel.features;

import intervalstore.api.IntervalI;
import jalview.bin.Console;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.features.FeatureStore;
import jalview.datamodel.features.SequenceFeaturesI;
import jalview.io.gff.SequenceOntologyFactory;
import jalview.io.gff.SequenceOntologyI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class SequenceFeatures
implements SequenceFeaturesI {
    private Map<String, FeatureStore> featureStore = new TreeMap<String, FeatureStore>();

    public SequenceFeatures() {
    }

    public SequenceFeatures(List<SequenceFeature> features) {
        this();
        if (features != null) {
            for (SequenceFeature feature : features) {
                this.add(feature);
            }
        }
    }

    @Override
    public boolean add(SequenceFeature sf) {
        String type = sf.getType();
        if (type == null) {
            Console.errPrintln("Feature type may not be null: " + sf.toString());
            return false;
        }
        if (this.featureStore.get(type) == null) {
            this.featureStore.put(type, new FeatureStore());
        }
        return this.featureStore.get(type).addFeature(sf);
    }

    @Override
    public List<SequenceFeature> findFeatures(int from, int to, String ... type) {
        ArrayList<SequenceFeature> result = new ArrayList<SequenceFeature>();
        for (FeatureStore featureSet : this.varargToTypes(type)) {
            result.addAll(featureSet.findOverlappingFeatures(from, to));
        }
        return result;
    }

    @Override
    public List<SequenceFeature> getAllFeatures(String ... type) {
        ArrayList<SequenceFeature> result = new ArrayList<SequenceFeature>();
        result.addAll(this.getPositionalFeatures(type));
        result.addAll(this.getNonPositionalFeatures(new String[0]));
        return result;
    }

    @Override
    public List<SequenceFeature> getFeaturesByOntology(String ... ontologyTerm) {
        if (ontologyTerm == null || ontologyTerm.length == 0) {
            return new ArrayList<SequenceFeature>();
        }
        Set<String> featureTypes = this.getFeatureTypes(ontologyTerm);
        if (featureTypes.isEmpty()) {
            return new ArrayList<SequenceFeature>();
        }
        return this.getAllFeatures(featureTypes.toArray(new String[featureTypes.size()]));
    }

    @Override
    public int getFeatureCount(boolean positional, String ... type) {
        int result = 0;
        for (FeatureStore featureSet : this.varargToTypes(type)) {
            result += featureSet.getFeatureCount(positional);
        }
        return result;
    }

    @Override
    public int getTotalFeatureLength(String ... type) {
        int result = 0;
        for (FeatureStore featureSet : this.varargToTypes(type)) {
            result += featureSet.getTotalFeatureLength();
        }
        return result;
    }

    @Override
    public List<SequenceFeature> getPositionalFeatures(String ... type) {
        ArrayList<SequenceFeature> result = new ArrayList<SequenceFeature>();
        for (FeatureStore featureSet : this.varargToTypes(type)) {
            result.addAll(featureSet.getPositionalFeatures());
        }
        return result;
    }

    protected Iterable<FeatureStore> varargToTypes(String ... type) {
        if (type == null || type.length == 0) {
            return this.featureStore.values();
        }
        ArrayList<FeatureStore> types = new ArrayList<FeatureStore>();
        for (String theType : type) {
            if (theType == null || !this.featureStore.containsKey(theType)) continue;
            types.add(this.featureStore.get(theType));
        }
        return types;
    }

    @Override
    public List<SequenceFeature> getContactFeatures(String ... type) {
        ArrayList<SequenceFeature> result = new ArrayList<SequenceFeature>();
        for (FeatureStore featureSet : this.varargToTypes(type)) {
            result.addAll(featureSet.getContactFeatures());
        }
        return result;
    }

    @Override
    public List<SequenceFeature> getNonPositionalFeatures(String ... type) {
        ArrayList<SequenceFeature> result = new ArrayList<SequenceFeature>();
        for (FeatureStore featureSet : this.varargToTypes(type)) {
            result.addAll(featureSet.getNonPositionalFeatures());
        }
        return result;
    }

    @Override
    public boolean delete(SequenceFeature sf) {
        for (FeatureStore featureSet : this.featureStore.values()) {
            if (!featureSet.delete(sf)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasFeatures() {
        for (FeatureStore featureSet : this.featureStore.values()) {
            if (featureSet.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<String> getFeatureGroups(boolean positionalFeatures, String ... type) {
        HashSet<String> groups = new HashSet<String>();
        for (FeatureStore featureSet : this.varargToTypes(type)) {
            groups.addAll(featureSet.getFeatureGroups(positionalFeatures));
        }
        return groups;
    }

    @Override
    public Set<String> getFeatureTypesForGroups(boolean positionalFeatures, String ... groups) {
        HashSet<String> result = new HashSet<String>();
        block0: for (Map.Entry<String, FeatureStore> featureType : this.featureStore.entrySet()) {
            Set<String> featureGroups = featureType.getValue().getFeatureGroups(positionalFeatures);
            for (String group : groups) {
                if (!featureGroups.contains(group)) continue;
                result.add(featureType.getKey());
                continue block0;
            }
        }
        return result;
    }

    @Override
    public Set<String> getFeatureTypes(String ... soTerm) {
        HashSet<String> types = new HashSet<String>();
        for (Map.Entry<String, FeatureStore> entry : this.featureStore.entrySet()) {
            String type = entry.getKey();
            if (entry.getValue().isEmpty() || !this.isOntologyTerm(type, soTerm)) continue;
            types.add(type);
        }
        return types;
    }

    protected boolean isOntologyTerm(String type, String ... soTerm) {
        if (soTerm == null || soTerm.length == 0) {
            return true;
        }
        SequenceOntologyI so = SequenceOntologyFactory.getSequenceOntology();
        for (String term : soTerm) {
            if (!type.equals(term) && !so.isA(type, term)) continue;
            return true;
        }
        return false;
    }

    @Override
    public float getMinimumScore(String type, boolean positional) {
        return this.featureStore.containsKey(type) ? this.featureStore.get(type).getMinimumScore(positional) : Float.NaN;
    }

    @Override
    public float getMaximumScore(String type, boolean positional) {
        return this.featureStore.containsKey(type) ? this.featureStore.get(type).getMaximumScore(positional) : Float.NaN;
    }

    public static void sortFeatures(List<? extends IntervalI> features, boolean forwardStrand) {
        Collections.sort(features, forwardStrand ? IntervalI.COMPARE_BEGIN_ASC_END_DESC : IntervalI.COMPARE_END_DESC);
    }

    @Override
    public List<SequenceFeature> getFeaturesForGroup(boolean positional, String group, String ... type) {
        ArrayList<SequenceFeature> result = new ArrayList<SequenceFeature>();
        for (FeatureStore featureSet : this.varargToTypes(type)) {
            if (!featureSet.getFeatureGroups(positional).contains(group)) continue;
            result.addAll(featureSet.getFeaturesForGroup(positional, group));
        }
        return result;
    }

    @Override
    public boolean shiftFeatures(int fromPosition, int shiftBy) {
        boolean modified = false;
        for (FeatureStore fs : this.featureStore.values()) {
            modified |= fs.shiftFeatures(fromPosition, shiftBy);
        }
        return modified;
    }

    @Override
    public void deleteAll() {
        this.featureStore.clear();
    }
}

