/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel;

import jalview.analysis.AAFrequency;
import jalview.analysis.AlignmentUtils;
import jalview.analysis.Conservation;
import jalview.bin.Console;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.AnnotatedCollectionI;
import jalview.datamodel.Annotation;
import jalview.datamodel.ContactListI;
import jalview.datamodel.ContactMapHolder;
import jalview.datamodel.ContactMatrixI;
import jalview.datamodel.HiddenMarkovModel;
import jalview.datamodel.ProfilesI;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceCollectionI;
import jalview.datamodel.SequenceI;
import jalview.renderer.ResidueShader;
import jalview.renderer.ResidueShaderI;
import jalview.schemes.ColourSchemeI;
import jalview.util.Comparison;
import jalview.util.MessageManager;
import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SequenceGroup
implements AnnotatedCollectionI {
    public static final String SEQ_GROUP_CHANGED = "Sequence group changed";
    protected PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    String groupName;
    String description;
    Conservation conserve;
    Conservation conservationData;
    ProfilesI consensusProfiles;
    ProfilesI hmmProfiles;
    boolean displayBoxes = true;
    boolean displayText = true;
    boolean colourText = false;
    boolean isDefined = false;
    boolean showNonconserved = false;
    private List<SequenceI> sequences;
    private SequenceI seqrep = null;
    int width = -1;
    public ResidueShaderI cs;
    private int startRes = 0;
    private int endRes = 0;
    public Color outlineColour = Color.black;
    public Color idColour = null;
    public int thresholdTextColour = 0;
    public Color textColour = Color.black;
    public Color textColour2 = Color.white;
    private boolean ignoreGapsInConsensus = true;
    private boolean showSequenceLogo = false;
    private boolean showSequenceSSLogo = false;
    private boolean normaliseSequenceLogo;
    private boolean hmmIgnoreBelowBackground = true;
    private boolean hmmUseInfoLetterHeight;
    private boolean hmmShowSequenceLogo;
    private boolean hmmNormaliseSequenceLogo;
    private boolean hmmShowHistogram;
    private boolean hidereps = false;
    private boolean hidecols;
    AlignmentAnnotation consensus = null;
    List<AlignmentAnnotation> ssConsensus = null;
    List<String> secondaryStructureSources = null;
    AlignmentAnnotation conservation = null;
    private AlignmentAnnotation hmmInformation;
    private boolean showConsensusHistogram;
    private boolean showSSConsensusHistogram;
    private AnnotatedCollectionI context;
    public Map<String, ProfilesI> hSSConsensusProfileMap;
    private List<AlignmentAnnotation> annotationsFromTree;
    private boolean treeBased = false;
    private int consPercGaps = 25;
    public ProfilesI consensusData = null;
    ContactMapHolder cmholder = new ContactMapHolder();

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public SequenceGroup() {
        this.groupName = "JGroup:" + this.hashCode();
        this.cs = new ResidueShader();
        this.sequences = new ArrayList<SequenceI>();
        this.annotationsFromTree = new ArrayList<AlignmentAnnotation>();
    }

    public SequenceGroup(List<SequenceI> sequences, String groupName, ColourSchemeI scheme, boolean displayBoxes, boolean displayText, boolean colourText, int start, int end) {
        this();
        this.sequences = sequences;
        this.groupName = groupName;
        this.displayBoxes = displayBoxes;
        this.displayText = displayText;
        this.colourText = colourText;
        this.cs = new ResidueShader(scheme);
        this.startRes = start;
        this.endRes = end;
        this.recalcConservation();
    }

    public SequenceGroup(SequenceGroup seqsel) {
        this();
        if (seqsel != null) {
            this.sequences = new ArrayList<SequenceI>();
            this.sequences.addAll(seqsel.sequences);
            if (seqsel.groupName != null) {
                this.groupName = new String(seqsel.groupName);
            }
            this.annotationsFromTree = seqsel.annotationsFromTree;
            this.displayBoxes = seqsel.displayBoxes;
            this.displayText = seqsel.displayText;
            this.colourText = seqsel.colourText;
            this.startRes = seqsel.startRes;
            this.endRes = seqsel.endRes;
            this.cs = new ResidueShader((ResidueShader)seqsel.cs);
            if (seqsel.description != null) {
                this.description = new String(seqsel.description);
            }
            this.hidecols = seqsel.hidecols;
            this.hidereps = seqsel.hidereps;
            this.showNonconserved = seqsel.showNonconserved;
            this.showSequenceLogo = seqsel.showSequenceLogo;
            this.showSequenceSSLogo = seqsel.showSequenceSSLogo;
            this.normaliseSequenceLogo = seqsel.normaliseSequenceLogo;
            this.showConsensusHistogram = seqsel.showConsensusHistogram;
            this.showSSConsensusHistogram = seqsel.showSSConsensusHistogram;
            this.hmmShowSequenceLogo = seqsel.hmmShowSequenceLogo;
            this.hmmNormaliseSequenceLogo = seqsel.hmmNormaliseSequenceLogo;
            this.hmmShowHistogram = seqsel.hmmShowHistogram;
            this.idColour = seqsel.idColour;
            this.outlineColour = seqsel.outlineColour;
            this.seqrep = seqsel.seqrep;
            this.textColour = seqsel.textColour;
            this.textColour2 = seqsel.textColour2;
            this.thresholdTextColour = seqsel.thresholdTextColour;
            this.width = seqsel.width;
            this.ignoreGapsInConsensus = seqsel.ignoreGapsInConsensus;
            this.hmmIgnoreBelowBackground = seqsel.hmmIgnoreBelowBackground;
            this.hmmUseInfoLetterHeight = seqsel.hmmUseInfoLetterHeight;
            if (seqsel.conserve != null) {
                this.recalcConservation();
            }
        }
    }

    public SequenceGroup(List<SequenceI> seqs) {
        this();
        this.sequences.addAll(seqs);
    }

    public boolean isShowSequenceLogo() {
        return this.showSequenceLogo;
    }

    public SequenceI[] getSelectionAsNewSequences(AlignmentI align) {
        int iSize = this.sequences.size();
        SequenceI[] seqs = new SequenceI[iSize];
        SequenceI[] inorder = this.getSequencesInOrder(align);
        int ipos = 0;
        for (int i = 0; i < inorder.length; ++i) {
            SequenceI seq = inorder[i];
            seqs[ipos] = seq.getSubSequence(this.startRes, this.endRes + 1);
            SequenceI seqipos = seqs[ipos];
            if (seqipos != null) {
                if (seq.getAnnotation() != null) {
                    AlignmentAnnotation[] alann = align.getAlignmentAnnotation();
                    for (int a = 0; a < seq.getAnnotation().length; ++a) {
                        AlignmentAnnotation tocopy = seq.getAnnotation()[a];
                        if (alann != null) {
                            boolean found = false;
                            int np = alann.length;
                            for (int pos = 0; pos < np; ++pos) {
                                if (alann[pos] != tocopy) continue;
                                found = true;
                                break;
                            }
                            if (!found) continue;
                        }
                        AlignmentAnnotation newannot = new AlignmentAnnotation(seq.getAnnotation()[a]);
                        newannot.restrict(this.startRes, this.endRes);
                        newannot.setSequenceRef(seqs[ipos]);
                        newannot.adjustForAlignment();
                        ContactMatrixI cm = seq.getContactMatrixFor(seq.getAnnotation()[a]);
                        if (cm != null) {
                            seqs[ipos].addContactListFor(newannot, cm);
                        }
                        seqipos.addAlignmentAnnotation(newannot);
                    }
                }
                ++ipos;
                continue;
            }
            --iSize;
        }
        if (iSize != inorder.length) {
            SequenceI[] nseqs = new SequenceI[iSize];
            System.arraycopy(seqs, 0, nseqs, 0, iSize);
            seqs = nseqs;
        }
        return seqs;
    }

    public int findEndRes(SequenceI seq) {
        int eres = 0;
        for (int j = 0; j < this.endRes + 1 && j < seq.getLength(); ++j) {
            char ch = seq.getCharAt(j);
            if (Comparison.isGap(ch)) continue;
            ++eres;
        }
        if (eres > 0) {
            eres += seq.getStart() - 1;
        }
        return eres;
    }

    @Override
    public List<SequenceI> getSequences() {
        return this.sequences;
    }

    @Override
    public List<SequenceI> getSequences(Map<SequenceI, SequenceCollectionI> hiddenReps) {
        if (hiddenReps == null) {
            return this.sequences;
        }
        ArrayList<SequenceI> allSequences = new ArrayList<SequenceI>();
        for (SequenceI seq : this.sequences) {
            allSequences.add(seq);
            if (!hiddenReps.containsKey(seq)) continue;
            SequenceCollectionI hsg = hiddenReps.get(seq);
            for (SequenceI seq2 : hsg.getSequences()) {
                if (seq2 == seq || allSequences.contains(seq2)) continue;
                allSequences.add(seq2);
            }
        }
        return allSequences;
    }

    public SequenceI[] getSequencesAsArray(Map<SequenceI, SequenceCollectionI> map) {
        List<SequenceI> tmp = this.getSequences(map);
        if (tmp == null) {
            return null;
        }
        return tmp.toArray(new SequenceI[tmp.size()]);
    }

    public List<String> getSecondaryStructureSources() {
        return this.secondaryStructureSources;
    }

    public void setSecondaryStructureSources(List<String> secondaryStructureSources) {
        this.secondaryStructureSources = secondaryStructureSources;
    }

    public boolean adjustForRemoveLeft(int col) {
        if (this.startRes >= col) {
            this.startRes -= col;
        }
        if (this.endRes >= col) {
            this.endRes -= col;
            if (this.startRes > this.endRes) {
                this.startRes = 0;
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean adjustForRemoveRight(int col) {
        if (this.startRes > col) {
            return false;
        }
        if (this.endRes >= col) {
            this.endRes = col;
        }
        return true;
    }

    public String getName() {
        return this.groupName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setName(String name) {
        this.groupName = name;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public Conservation getConservation() {
        return this.conserve;
    }

    public void setConservation(Conservation c) {
        this.conserve = c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSequence(SequenceI s, boolean recalc) {
        List<SequenceI> list = this.sequences;
        synchronized (list) {
            if (s != null && !this.sequences.contains(s)) {
                this.sequences.add(s);
                this.changeSupport.firePropertyChange(SEQ_GROUP_CHANGED, this.sequences.size() - 1, this.sequences.size());
            }
            if (recalc) {
                this.recalcConservation();
            }
        }
    }

    public int getConsPercGaps() {
        return this.consPercGaps;
    }

    public void setConsPercGaps(int consPercGaps) {
        this.consPercGaps = consPercGaps;
    }

    public boolean recalcConservation() {
        return this.recalcConservation(false);
    }

    public boolean recalcConservation(boolean defer) {
        if (this.cs == null && this.consensus == null && this.conservation == null && this.hmmInformation == null) {
            return false;
        }
        boolean upd = false;
        try {
            ProfilesI cnsns = AAFrequency.calculate(this.sequences, this.startRes, this.endRes + 1, this.showSequenceLogo);
            if (this.hmmInformation != null) {
                HiddenMarkovModel hmm = this.hmmInformation.sequenceRef.getHMM();
                ProfilesI info = AAFrequency.calculateHMMProfiles(hmm, this.endRes + 1 - this.startRes, this.startRes, this.endRes + 1, this.hmmIgnoreBelowBackground, this.hmmUseInfoLetterHeight);
                this._updateInformationRow(info);
                upd = true;
            }
            if (this.consensus != null) {
                this._updateConsensusRow(cnsns, this.sequences.size());
                upd = true;
            }
            if (this.cs != null) {
                this.cs.setConsensus(cnsns);
                upd = true;
            }
            this.hSSConsensusProfileMap = new HashMap<String, ProfilesI>();
            List<Object> ssSources = new ArrayList<String>();
            AnnotatedCollectionI aa = this.getContext();
            if (aa != null) {
                ssSources = AlignmentUtils.extractSSSourceInAlignmentAnnotation(aa.getAlignmentAnnotation());
            }
            if (ssSources != null) {
                ssSources.add("All");
                for (String string : ssSources) {
                    ProfilesI hSSConsensus = AAFrequency.calculateSS(this.sequences, this.startRes, this.endRes + 1, this.showSequenceLogo, string, this);
                    this.hSSConsensusProfileMap.put(string, hSSConsensus);
                }
            }
            if (this.ssConsensus != null) {
                this._updateSSConsensusRow(this.hSSConsensusProfileMap, this.sequences.size());
                upd = true;
            }
            if (this.cs != null) {
                this.cs.setSSConsensusProfileMap(this.hSSConsensusProfileMap);
                upd = true;
            }
            if (this.conservation != null || this.cs != null && this.cs.conservationApplied()) {
                Conservation c = new Conservation(this.groupName, this.sequences, this.startRes, this.endRes + 1);
                c.calculate();
                c.verdict(false, this.consPercGaps);
                if (this.conservation != null) {
                    this._updateConservationRow(c);
                }
                if (this.cs != null && this.cs.conservationApplied()) {
                    this.cs.setConservation(c);
                }
                upd = true;
            }
            if (this.cs != null && !defer) {
                this.cs.alignmentChanged(this.context != null ? this.context : this, null);
                return true;
            }
            return upd;
        }
        catch (OutOfMemoryError err) {
            Console.outPrintln("Out of memory loading groups: " + err);
            return upd;
        }
    }

    private void _updateConservationRow(Conservation c) {
        if (this.conservation == null) {
            this.getConservation();
        }
        this.conservation.label = "Conservation for " + this.getName();
        this.conservation.description = "Conservation for group " + this.getName() + " less than " + this.consPercGaps + "% gaps";
        int aWidth = this.conservation.annotations != null ? (this.endRes < this.conservation.annotations.length ? this.conservation.annotations.length : this.endRes + 1) : this.endRes + 1;
        this.conservation.annotations = null;
        this.conservation.annotations = new Annotation[aWidth];
        c.completeAnnotations(this.conservation, null, this.startRes, this.endRes + 1);
    }

    private void _updateConsensusRow(ProfilesI cnsns, long nseq) {
        if (this.consensus == null) {
            this.getConsensus();
        }
        this.consensus.label = "Consensus for " + this.getName();
        this.consensus.description = "Percent Identity";
        this.consensusData = cnsns;
        int aWidth = this.consensus.annotations != null ? (this.endRes < this.consensus.annotations.length ? this.consensus.annotations.length : this.endRes + 1) : this.endRes + 1;
        this.consensus.annotations = null;
        this.consensus.annotations = new Annotation[aWidth];
        AAFrequency.completeConsensus(this.consensus, cnsns, this.startRes, this.endRes + 1, this.ignoreGapsInConsensus, this.showSequenceLogo, nseq);
    }

    private void _updateSSConsensusRow(Map<String, ProfilesI> hSSConsensusProfileMap, long nseq) {
        ArrayList<String> ssSources = new ArrayList<String>(hSSConsensusProfileMap.keySet());
        this.secondaryStructureSources = new ArrayList<String>();
        Collections.sort(ssSources);
        if (this.ssConsensus == null) {
            this.getSSConsensus(ssSources);
        }
        for (AlignmentAnnotation aa : this.ssConsensus) {
            ProfilesI profile = null;
            String ssSource = null;
            for (String source : ssSources) {
                if (!aa.description.startsWith(source)) continue;
                profile = hSSConsensusProfileMap.get(source);
                ssSource = source;
            }
            if (profile == null) continue;
            aa.label = "Secondary Structure Consensus " + ssSource + " " + this.getName();
            aa.description = ssSource + " Secondary Structure Consensus for " + this.getName();
            int aWidth = aa.annotations != null ? (this.endRes < aa.annotations.length ? aa.annotations.length : this.endRes + 1) : this.endRes + 1;
            aa.annotations = new Annotation[aWidth];
            AAFrequency.completeSSConsensus(aa, profile, this.startRes, this.endRes + 1, this.ignoreGapsInConsensus, this.showSequenceLogo, nseq);
            if (aa.getNoOfSequencesIncluded() <= 0L || "All".equals(ssSource)) continue;
            this.secondaryStructureSources.add(ssSource);
        }
    }

    private void _updateInformationRow(ProfilesI cnsns) {
        if (this.hmmInformation == null) {
            this.createInformationAnnotation();
        }
        this.hmmInformation.description = MessageManager.getString("label.information_description");
        this.setHmmProfiles(cnsns);
        int aWidth = this.hmmInformation.annotations != null ? (this.endRes < this.hmmInformation.annotations.length ? this.hmmInformation.annotations.length : this.endRes + 1) : this.endRes + 1;
        this.hmmInformation.annotations = null;
        this.hmmInformation.annotations = new Annotation[aWidth];
        this.hmmInformation.setCalcId("HMM");
        AAFrequency.completeInformation(this.hmmInformation, cnsns, this.startRes, this.endRes + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOrRemove(SequenceI s, boolean recalc) {
        List<SequenceI> list = this.sequences;
        synchronized (list) {
            if (this.sequences.contains(s)) {
                this.deleteSequence(s, recalc);
            } else {
                this.addSequence(s, recalc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addOrRemoveAnnotation(AlignmentAnnotation alignmentAnnotation) {
        List<AlignmentAnnotation> list = this.annotationsFromTree;
        synchronized (list) {
            if (this.annotationsFromTree.contains(alignmentAnnotation)) {
                this.annotationsFromTree.remove(alignmentAnnotation);
                for (AlignmentAnnotation annot : this.annotationsFromTree) {
                    if (annot.sequenceRef != alignmentAnnotation.sequenceRef) continue;
                    return true;
                }
                return false;
            }
            this.annotationsFromTree.add(alignmentAnnotation);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAnnotationFromTree(AlignmentAnnotation alignmentAnnotation) {
        if (this.annotationsFromTree == null) {
            this.annotationsFromTree = new ArrayList<AlignmentAnnotation>();
        }
        List<AlignmentAnnotation> list = this.annotationsFromTree;
        synchronized (list) {
            if (!this.annotationsFromTree.contains(alignmentAnnotation)) {
                this.annotationsFromTree.add(alignmentAnnotation);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSequence(SequenceI s, boolean recalc) {
        List<SequenceI> list = this.sequences;
        synchronized (list) {
            this.sequences.remove(s);
            this.changeSupport.firePropertyChange(SEQ_GROUP_CHANGED, this.sequences.size() + 1, this.sequences.size());
            if (recalc) {
                this.recalcConservation();
            }
        }
    }

    @Override
    public int getStartRes() {
        return this.startRes;
    }

    @Override
    public int getEndRes() {
        return this.endRes;
    }

    public void setStartRes(int newStart) {
        int before = this.startRes;
        this.startRes = Math.max(0, newStart);
        this.changeSupport.firePropertyChange(SEQ_GROUP_CHANGED, before, this.startRes);
    }

    public void setEndRes(int i) {
        int before = this.endRes;
        this.endRes = i;
        this.changeSupport.firePropertyChange(SEQ_GROUP_CHANGED, before, this.endRes);
    }

    public int getSize() {
        return this.sequences.size();
    }

    public SequenceI getSequenceAt(int i) {
        return this.sequences.get(i);
    }

    public void setColourText(boolean state) {
        this.colourText = state;
    }

    public boolean getColourText() {
        return this.colourText;
    }

    public void setDisplayText(boolean state) {
        this.displayText = state;
    }

    public boolean getDisplayText() {
        return this.displayText;
    }

    public void setDisplayBoxes(boolean state) {
        this.displayBoxes = state;
    }

    public boolean getDisplayBoxes() {
        return this.displayBoxes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getWidth() {
        List<SequenceI> list = this.sequences;
        synchronized (list) {
            boolean first = true;
            for (SequenceI seq : this.sequences) {
                if (!first && seq.getLength() <= this.width) continue;
                this.width = seq.getLength();
                first = false;
            }
            return this.width;
        }
    }

    public void setOutlineColour(Color c) {
        this.outlineColour = c;
    }

    public Color getOutlineColour() {
        return this.outlineColour;
    }

    public SequenceI[] getSequencesInOrder(AlignmentI al) {
        return this.getSequencesInOrder(al, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SequenceI[] getSequencesInOrder(AlignmentI al, boolean trim) {
        List<SequenceI> list = this.sequences;
        synchronized (list) {
            int sSize = this.sequences.size();
            int alHeight = al.getHeight();
            SequenceI[] seqs = new SequenceI[trim ? sSize : alHeight];
            int index = 0;
            for (int i = 0; i < alHeight && index < sSize; ++i) {
                if (!this.sequences.contains(al.getSequenceAt(i))) continue;
                seqs[trim ? index : i] = al.getSequenceAt(i);
                ++index;
            }
            if (index == 0) {
                return null;
            }
            if (!trim) {
                return seqs;
            }
            if (index < seqs.length) {
                SequenceI[] dummy = seqs;
                seqs = new SequenceI[index];
                while (--index >= 0) {
                    seqs[index] = dummy[index];
                    dummy[index] = null;
                }
            }
            return seqs;
        }
    }

    public Color getIdColour() {
        return this.idColour;
    }

    public void setIdColour(Color idColour) {
        this.idColour = idColour;
    }

    @Override
    public SequenceI getSeqrep() {
        return this.seqrep;
    }

    @Override
    public void setSeqrep(SequenceI seqrep) {
        this.seqrep = seqrep;
    }

    @Override
    public boolean hasSeqrep() {
        return this.seqrep != null;
    }

    public void setHidereps(boolean visibility) {
        this.hidereps = visibility;
    }

    public boolean isHidereps() {
        return this.hidereps;
    }

    public void setHideCols(boolean visibility) {
        this.hidecols = visibility;
    }

    public boolean isHideCols() {
        return this.hidecols;
    }

    public SequenceGroup intersect(AlignmentI alignment, Map<SequenceI, SequenceCollectionI> map) {
        SequenceGroup sgroup = new SequenceGroup(this);
        SequenceI[] insect = this.getSequencesInOrder(alignment);
        sgroup.sequences = new ArrayList<SequenceI>();
        for (int s = 0; insect != null && s < insect.length; ++s) {
            if (map != null && !map.containsKey(insect[s])) continue;
            sgroup.sequences.add(insect[s]);
        }
        return sgroup;
    }

    public List<AlignmentAnnotation> getAnnotationsFromTree() {
        return this.annotationsFromTree;
    }

    public void setAnnotationsFromTree(List<AlignmentAnnotation> annotationsFromTree) {
        this.annotationsFromTree = annotationsFromTree;
    }

    public boolean hasAnnotationsFromTree() {
        return this.annotationsFromTree != null && !this.annotationsFromTree.isEmpty();
    }

    public boolean getShowNonconserved() {
        return this.showNonconserved;
    }

    public void setShowNonconserved(boolean displayNonconserved) {
        this.showNonconserved = displayNonconserved;
    }

    public void setConsensus(AlignmentAnnotation aan) {
        if (this.consensus == null) {
            this.consensus = aan;
        }
    }

    public void setSSConsensusRow(AlignmentAnnotation aan) {
        if (this.ssConsensus == null) {
            this.ssConsensus = new ArrayList<AlignmentAnnotation>();
            this.ssConsensus.add(aan);
        } else {
            boolean annotExists = this.ssConsensus.stream().anyMatch(ssa -> ssa.label.equals(aan.label));
            if (!annotExists) {
                this.ssConsensus.add(aan);
            }
        }
    }

    public AlignmentAnnotation getConsensus() {
        int aWidth = this.getWidth();
        if (aWidth < 0) {
            return null;
        }
        if (this.consensus == null) {
            this.consensus = new AlignmentAnnotation("", "", new Annotation[1], 0.0f, 100.0f, 1);
            this.consensus.hasText = true;
            this.consensus.autoCalculated = true;
            this.consensus.groupRef = this;
            this.consensus.label = "Consensus for " + this.getName();
            this.consensus.description = "Percent Identity";
        }
        return this.consensus;
    }

    public List<AlignmentAnnotation> getSSConsensus(List<String> ssSources) {
        int aWidth = this.getWidth();
        if (aWidth < 0) {
            return null;
        }
        if (this.ssConsensus == null && ssSources != null) {
            this.ssConsensus = new ArrayList<AlignmentAnnotation>();
            for (String ssSource : ssSources) {
                AlignmentAnnotation aa = new AlignmentAnnotation("", "", new Annotation[1], 0.0f, 100.0f, 1);
                aa.visible = "All".equals(ssSource);
                aa.hasText = true;
                aa.autoCalculated = true;
                aa.groupRef = this;
                aa.label = "Secondary Structure Consensus " + ssSource + " " + this.getName();
                aa.description = ssSource + " Secondary Structure Consensus for " + this.getName();
                this.ssConsensus.add(aa);
            }
        }
        return this.ssConsensus;
    }

    void createInformationAnnotation() {
        this.hmmInformation = new AlignmentAnnotation("", "", new Annotation[1], 0.0f, 6.25f, 1);
        this.hmmInformation.hasText = true;
        this.hmmInformation.autoCalculated = false;
        this.hmmInformation.groupRef = this;
        this.hmmInformation.label = this.getName();
        this.hmmInformation.description = MessageManager.getString("label.information_description");
        this.hmmInformation.setCalcId("HMM");
    }

    public void setConservationRow(AlignmentAnnotation aan) {
        if (this.conservation == null) {
            this.conservation = aan;
        }
    }

    public AlignmentAnnotation getConservationRow() {
        if (this.conservation == null) {
            this.conservation = new AlignmentAnnotation("", "", new Annotation[1], 0.0f, 11.0f, 1);
        }
        this.conservation.hasText = true;
        this.conservation.autoCalculated = true;
        this.conservation.groupRef = this;
        this.conservation.label = "Conservation for " + this.getName();
        this.conservation.description = "Conservation for group " + this.getName() + " less than " + this.consPercGaps + "% gaps";
        return this.conservation;
    }

    public boolean hasAnnotationRows() {
        return this.consensus != null || this.conservation != null;
    }

    public SequenceI getConsensusSeq() {
        this.getConsensus();
        StringBuffer seqs = new StringBuffer();
        for (int i = 0; i < this.consensus.annotations.length; ++i) {
            if (this.consensus.annotations[i] == null) continue;
            String desc = this.consensus.annotations[i].description;
            if (desc.length() > 1 && desc.charAt(0) == '[') {
                seqs.append(desc.charAt(1));
                continue;
            }
            seqs.append(this.consensus.annotations[i].displayCharacter);
        }
        Sequence sq = new Sequence("Group" + this.getName() + " Consensus", seqs.toString());
        sq.setDescription("Percentage Identity Consensus " + (this.ignoreGapsInConsensus ? " without gaps" : ""));
        return sq;
    }

    public void setIgnoreGapsConsensus(boolean state) {
        if (this.ignoreGapsInConsensus != state && this.consensus != null) {
            this.ignoreGapsInConsensus = state;
            this.recalcConservation();
        }
        this.ignoreGapsInConsensus = state;
    }

    public boolean getIgnoreGapsConsensus() {
        return this.ignoreGapsInConsensus;
    }

    public void setIgnoreBelowBackground(boolean state) {
        this.hmmIgnoreBelowBackground = state;
    }

    public boolean isIgnoreBelowBackground() {
        return this.hmmIgnoreBelowBackground;
    }

    public void setInfoLetterHeight(boolean state) {
        this.hmmUseInfoLetterHeight = state;
    }

    public boolean isUseInfoLetterHeight() {
        return this.hmmUseInfoLetterHeight;
    }

    public void setshowSequenceLogo(boolean showSequenceLogo) {
        if (this.showSequenceLogo != showSequenceLogo && this.consensus != null) {
            this.showSequenceLogo = showSequenceLogo;
            this.recalcConservation();
        }
        this.showSequenceLogo = showSequenceLogo;
    }

    public void setshowSequenceSSLogo(boolean showSequenceSSLogo) {
        if (this.showSequenceSSLogo != showSequenceSSLogo && this.ssConsensus != null) {
            this.showSequenceSSLogo = showSequenceSSLogo;
            this.recalcConservation();
        }
        this.showSequenceSSLogo = showSequenceSSLogo;
    }

    public void setShowSSConsensusHistogram(boolean showSSConsHist) {
        if (this.showSSConsensusHistogram != showSSConsHist && this.ssConsensus != null) {
            this.showSSConsensusHistogram = showSSConsHist;
            this.recalcConservation();
        }
        this.showSSConsensusHistogram = showSSConsHist;
    }

    public void setShowConsensusHistogram(boolean showConsHist) {
        if (this.showConsensusHistogram != showConsHist && this.consensus != null) {
            this.showConsensusHistogram = showConsHist;
            this.recalcConservation();
        }
        this.showConsensusHistogram = showConsHist;
    }

    public boolean isShowConsensusHistogram() {
        return this.showConsensusHistogram;
    }

    public void setNormaliseSequenceLogo(boolean norm) {
        this.normaliseSequenceLogo = norm;
    }

    public boolean isNormaliseSequenceLogo() {
        return this.normaliseSequenceLogo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AlignmentAnnotation[] getAlignmentAnnotation() {
        ArrayList<AlignmentAnnotation> annot = new ArrayList<AlignmentAnnotation>();
        List<SequenceI> list = this.sequences;
        synchronized (list) {
            for (SequenceI seq : this.sequences) {
                AlignmentAnnotation[] aa = seq.getAnnotation();
                if (aa == null) continue;
                for (AlignmentAnnotation al : aa) {
                    if (al.groupRef != this) continue;
                    annot.add(al);
                }
            }
            if (this.consensus != null) {
                annot.add(this.consensus);
            }
            if (this.conservation != null) {
                annot.add(this.conservation);
            }
        }
        return annot.toArray(new AlignmentAnnotation[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSecondaryStructurePresent() {
        List<SequenceI> list = this.sequences;
        synchronized (list) {
            for (SequenceI seq : this.sequences) {
                AlignmentAnnotation[] aa = seq.getAnnotation();
                if (!AlignmentUtils.isSecondaryStructurePresent(aa)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int noOfSecondaryStructureAnnots() {
        int count = 0;
        List<SequenceI> list = this.sequences;
        synchronized (list) {
            for (SequenceI seq : this.sequences) {
                AlignmentAnnotation[] aa = seq.getAnnotation();
                if (AlignmentUtils.getSecondaryStructureAnnots(aa) == null) continue;
                count += AlignmentUtils.getSecondaryStructureAnnots(aa).size();
            }
        }
        return count;
    }

    @Override
    public Iterable<AlignmentAnnotation> findAnnotation(String calcId) {
        return AlignmentAnnotation.findAnnotation(Arrays.asList(this.getAlignmentAnnotation()), calcId);
    }

    @Override
    public Iterable<AlignmentAnnotation> findAnnotations(SequenceI seq, String calcId, String label) {
        return AlignmentAnnotation.findAnnotations(Arrays.asList(this.getAlignmentAnnotation()), seq, calcId, label);
    }

    public boolean hasAnnotation(String calcId) {
        return AlignmentAnnotation.hasAnnotation(Arrays.asList(this.getAlignmentAnnotation()), calcId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List<SequenceI> list = this.sequences;
        synchronized (list) {
            int before = this.sequences.size();
            this.sequences.clear();
            this.changeSupport.firePropertyChange(SEQ_GROUP_CHANGED, before, this.sequences.size());
        }
    }

    public void setContext(AnnotatedCollectionI ctx, boolean defined) {
        this.setContext(ctx);
        this.isDefined = defined;
    }

    public void setContext(AnnotatedCollectionI ctx) {
        for (AnnotatedCollectionI ref = ctx; ref != null; ref = ref.getContext()) {
            if (ref != this && ref.getContext() != ctx) continue;
            throw new IllegalArgumentException("Circular reference in SequenceGroup.context");
        }
        this.context = ctx;
    }

    @Override
    public AnnotatedCollectionI getContext() {
        return this.context;
    }

    public boolean isDefined() {
        return this.isDefined;
    }

    public void setColourScheme(ColourSchemeI scheme) {
        if (this.cs == null) {
            this.cs = new ResidueShader();
        }
        this.cs.setColourScheme(scheme);
    }

    public void setGroupColourScheme(ResidueShaderI scheme) {
        this.cs = scheme;
    }

    public ColourSchemeI getColourScheme() {
        return this.cs == null ? null : this.cs.getColourScheme();
    }

    public ResidueShaderI getGroupColourScheme() {
        return this.cs;
    }

    @Override
    public boolean isNucleotide() {
        if (this.context != null) {
            return this.context.isNucleotide();
        }
        return false;
    }

    public boolean contains(SequenceI seq1) {
        return this.sequences.contains(seq1);
    }

    public boolean containsAnnotation(AlignmentAnnotation annot) {
        if (this.annotationsFromTree == null) {
            return false;
        }
        return this.annotationsFromTree.contains(annot);
    }

    public boolean contains(SequenceI seq, int apos) {
        return this.startRes <= apos && this.endRes >= apos && this.sequences.contains(seq);
    }

    @Override
    public Collection<ContactMatrixI> getContactMaps() {
        return this.cmholder.getContactMaps();
    }

    @Override
    public ContactMatrixI getContactMatrixFor(AlignmentAnnotation ann) {
        return this.cmholder.getContactMatrixFor(ann);
    }

    @Override
    public ContactListI getContactListFor(AlignmentAnnotation _aa, int column) {
        return this.cmholder.getContactListFor(_aa, column);
    }

    @Override
    public AlignmentAnnotation addContactList(ContactMatrixI cm) {
        AlignmentAnnotation aa = this.cmholder.addContactList(cm);
        Annotation[] _aa = new Annotation[this.getWidth()];
        Annotation dummy = new Annotation(0.0f);
        int i = 0;
        while (i < _aa.length) {
            _aa[i++] = dummy;
        }
        aa.annotations = _aa;
        return aa;
    }

    @Override
    public void addContactListFor(AlignmentAnnotation annotation, ContactMatrixI cm) {
        this.cmholder.addContactListFor(annotation, cm);
    }

    public boolean isShowInformationHistogram() {
        return this.hmmShowHistogram;
    }

    public void setShowInformationHistogram(boolean state) {
        if (this.hmmShowHistogram != state && this.hmmInformation != null) {
            this.hmmShowHistogram = state;
        }
        this.hmmShowHistogram = state;
    }

    public boolean isShowHMMSequenceLogo() {
        return this.hmmShowSequenceLogo;
    }

    public void setShowHMMSequenceLogo(boolean state) {
        this.hmmShowSequenceLogo = state;
    }

    public boolean isNormaliseHMMSequenceLogo() {
        return this.hmmNormaliseSequenceLogo;
    }

    public void setNormaliseHMMSequenceLogo(boolean state) {
        this.hmmNormaliseSequenceLogo = state;
    }

    public ProfilesI getConsensusData() {
        return this.consensusProfiles;
    }

    public ProfilesI getHmmProfiles() {
        return this.hmmProfiles;
    }

    public void setHmmProfiles(ProfilesI hmmProfiles) {
        this.hmmProfiles = hmmProfiles;
    }

    @Override
    public List<SequenceI> getHmmSequences() {
        ArrayList<SequenceI> result = new ArrayList<SequenceI>();
        for (int i = 0; i < this.sequences.size(); ++i) {
            SequenceI seq = this.sequences.get(i);
            if (!seq.hasHMMProfile()) continue;
            result.add(seq);
        }
        return result;
    }
}

