/*
 * Decompiled with CFR 0.152.
 */
package jalview.bin;

import jalview.bin.AppletParams;
import jalview.util.Platform;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;

public class ArgsParser {
    public static final String NOCALCULATION = "nocalculation";
    public static final String NOMENUBAR = "nomenubar";
    public static final String NOSTATUS = "nostatus";
    public static final String SHOWOVERVIEW = "showoverview";
    public static final String ANNOTATIONS = "annotations";
    public static final String COLOUR = "colour";
    public static final String FEATURES = "features";
    public static final String GROOVY = "groovy";
    public static final String GROUPS = "groups";
    public static final String HEADLESS = "headless";
    public static final String JABAWS = "jabaws";
    public static final String NOANNOTATION = "no-annotation";
    public static final String NOANNOTATION2 = "noannotation";
    public static final String NODISPLAY = "nodisplay";
    public static final String NOGUI = "nogui";
    public static final String NONEWS = "nonews";
    public static final String NOQUESTIONNAIRE = "noquestionnaire";
    public static final String NOSORTBYTREE = "nosortbytree";
    public static final String NOUSAGESTATS = "nousagestats";
    public static final String OPEN = "open";
    public static final String OPEN2 = "open2";
    public static final String PROPS = "props";
    public static final String QUESTIONNAIRE = "questionnaire";
    public static final String SETPROP = "setprop";
    public static final String SORTBYTREE = "sortbytree";
    public static final String TREE = "tree";
    public static final String VDOC = "vdoc";
    public static final String VSESS = "vsess";
    private List<String> vargs = new ArrayList<String>();
    private boolean isApplet;
    private AppletParams appletParams;

    public boolean isApplet() {
        return this.isApplet;
    }

    public ArgsParser(String[] args) {
        boolean bl = this.isApplet = args.length > 0 && args[0].startsWith("<applet");
        if (this.isApplet) {
            this.appletParams = AppletParams.getAppletParams(args, this.vargs);
        } else {
            if (Platform.isJS()) {
                this.isApplet = true;
                this.appletParams = AppletParams.getAppletParams(Platform.getAppletInfoAsMap(), this.vargs);
            }
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i].trim();
                if (arg.charAt(0) == '-') {
                    arg = arg.substring(1);
                }
                this.vargs.add(arg);
            }
        }
    }

    public String getValue(String arg) {
        return this.getValue(arg, false);
    }

    public String getValue(String arg, boolean utf8decode) {
        int index = this.vargs.indexOf(arg);
        String dc = null;
        String ret = null;
        if (index != -1) {
            ret = this.vargs.get(index + 1).toString();
            this.vargs.remove(index);
            this.vargs.remove(index);
            if (utf8decode && ret != null) {
                try {
                    ret = dc = URLDecoder.decode(ret, "UTF-8");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return ret;
    }

    public boolean contains(String arg) {
        if (this.vargs.contains(arg)) {
            this.vargs.remove(arg);
            return true;
        }
        return false;
    }

    public String nextValue() {
        return this.vargs.remove(0);
    }

    public int getSize() {
        return this.vargs.size();
    }

    public Object getAppletValue(String key, String def, boolean asString) {
        Object value;
        return this.appletParams == null ? null : ((value = this.appletParams.get(key.toLowerCase())) == null ? def : (asString ? "" + value : value));
    }
}

