/*
 * Decompiled with CFR 0.152.
 */
package jalview.appletgui;

import jalview.api.RotatableCanvasI;
import jalview.appletgui.PaintRefresher;
import jalview.bin.Console;
import jalview.datamodel.Point;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.datamodel.SequencePoint;
import jalview.math.RotatableMatrix;
import jalview.util.MessageManager;
import jalview.viewmodel.AlignmentViewport;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.List;

public class RotatableCanvas
extends Panel
implements MouseListener,
MouseMotionListener,
KeyListener,
RotatableCanvasI {
    private static final int DIMS = 3;
    String tooltip;
    int toolx;
    int tooly;
    boolean drawAxes = true;
    int mouseX = 0;
    int mouseY = 0;
    Image img;
    Graphics ig;
    Dimension prefsize;
    Point centre;
    float[] width = new float[3];
    float[] max = new float[3];
    float[] min = new float[3];
    float maxwidth;
    float scale;
    int npoint;
    List<SequencePoint> points;
    Point[] orig;
    Point[] axisEndPoints;
    int startx;
    int starty;
    int lastx;
    int lasty;
    int rectx1;
    int recty1;
    int rectx2;
    int recty2;
    float scalefactor = 1.0f;
    AlignmentViewport av;
    boolean showLabels = false;

    public RotatableCanvas(AlignmentViewport viewport) {
        this.av = viewport;
        this.axisEndPoints = new Point[3];
    }

    public void showLabels(boolean b) {
        this.showLabels = b;
        this.repaint();
    }

    @Override
    public void setPoints(List<SequencePoint> points, int npoint) {
        this.points = points;
        this.npoint = npoint;
        PaintRefresher.Register(this, this.av.getSequenceSetId());
        this.prefsize = this.getPreferredSize();
        this.orig = new Point[npoint];
        for (int i = 0; i < npoint; ++i) {
            SequencePoint sp = points.get(i);
            this.orig[i] = sp.coord;
        }
        this.resetAxes();
        this.findCentre();
        this.findWidth();
        this.scale = this.findScale();
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.addMouseMotionListener(this);
    }

    public void resetAxes() {
        this.axisEndPoints[0] = new Point(1.0f, 0.0f, 0.0f);
        this.axisEndPoints[1] = new Point(0.0f, 1.0f, 0.0f);
        this.axisEndPoints[2] = new Point(0.0f, 0.0f, 1.0f);
    }

    public void findWidth() {
        this.max = new float[3];
        this.min = new float[3];
        this.max[0] = Float.MIN_VALUE;
        this.max[1] = Float.MIN_VALUE;
        this.max[2] = Float.MIN_VALUE;
        this.min[0] = Float.MAX_VALUE;
        this.min[1] = Float.MAX_VALUE;
        this.min[2] = Float.MAX_VALUE;
        for (SequencePoint sp : this.points) {
            this.max[0] = Math.max(this.max[0], sp.coord.x);
            this.max[1] = Math.max(this.max[1], sp.coord.y);
            this.max[2] = Math.max(this.max[2], sp.coord.z);
            this.min[0] = Math.min(this.min[0], sp.coord.x);
            this.min[1] = Math.min(this.min[1], sp.coord.y);
            this.min[2] = Math.min(this.min[2], sp.coord.z);
        }
        this.width[0] = Math.abs(this.max[0] - this.min[0]);
        this.width[1] = Math.abs(this.max[1] - this.min[1]);
        this.width[2] = Math.abs(this.max[2] - this.min[2]);
        this.maxwidth = Math.max(this.width[0], Math.max(this.width[1], this.width[2]));
    }

    public float findScale() {
        int height;
        int w;
        if (this.getSize().width != 0) {
            w = this.getSize().width;
            height = this.getSize().height;
        } else {
            w = this.prefsize.width;
            height = this.prefsize.height;
        }
        int dim = w < height ? w : height;
        return (float)dim * this.scalefactor / (2.0f * this.maxwidth);
    }

    public void findCentre() {
        this.findWidth();
        float x = (this.max[0] + this.min[0]) / 2.0f;
        float y = (this.max[1] + this.min[1]) / 2.0f;
        float z = (this.max[2] + this.min[2]) / 2.0f;
        this.centre = new Point(x, y, z);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.prefsize != null) {
            return this.prefsize;
        }
        return new Dimension(400, 400);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        if (this.points == null) {
            g.setFont(new Font("Verdana", 0, 18));
            g.drawString(MessageManager.getString("label.calculating_pca") + "....", 20, this.getSize().height / 2);
        } else {
            if (this.img == null || this.prefsize.width != this.getSize().width || this.prefsize.height != this.getSize().height) {
                this.prefsize.width = this.getSize().width;
                this.prefsize.height = this.getSize().height;
                this.scale = this.findScale();
                this.img = this.createImage(this.getSize().width, this.getSize().height);
                this.ig = this.img.getGraphics();
            }
            this.drawBackground(this.ig, Color.black);
            this.drawScene(this.ig);
            if (this.drawAxes) {
                this.drawAxes(this.ig);
            }
            if (this.tooltip != null) {
                this.ig.setColor(Color.red);
                this.ig.drawString(this.tooltip, this.toolx, this.tooly);
            }
            g.drawImage(this.img, 0, 0, this);
        }
    }

    public void drawAxes(Graphics g) {
        g.setColor(Color.yellow);
        for (int i = 0; i < 3; ++i) {
            g.drawLine(this.getSize().width / 2, this.getSize().height / 2, (int)(this.axisEndPoints[i].x * this.scale * this.max[0] + (float)(this.getSize().width / 2)), (int)(this.axisEndPoints[i].y * this.scale * this.max[1] + (float)(this.getSize().height / 2)));
        }
    }

    public void drawBackground(Graphics g, Color col) {
        g.setColor(col);
        g.fillRect(0, 0, this.prefsize.width, this.prefsize.height);
    }

    public void drawScene(Graphics g) {
        for (int i = 0; i < this.npoint; ++i) {
            SequencePoint sp = this.points.get(i);
            SequenceI sequence = sp.getSequence();
            Color sequenceColour = this.av.getSequenceColour(sequence);
            g.setColor(sequenceColour == Color.black ? Color.white : sequenceColour);
            if (this.av.getSelectionGroup() != null && this.av.getSelectionGroup().getSequences(null).contains(sequence)) {
                g.setColor(Color.gray);
            }
            if (sp.coord.z < this.centre.z) {
                g.setColor(g.getColor().darker());
            }
            int halfwidth = this.getSize().width / 2;
            int halfheight = this.getSize().height / 2;
            int x = (int)((sp.coord.x - this.centre.x) * this.scale) + halfwidth;
            int y = (int)((sp.coord.y - this.centre.y) * this.scale) + halfheight;
            g.fillRect(x - 3, y - 3, 6, 6);
            if (!this.showLabels) continue;
            g.setColor(Color.red);
            g.drawString(sequence.getName(), x - 3, y - 4);
        }
    }

    @Override
    public void keyTyped(KeyEvent evt) {
    }

    @Override
    public void keyReleased(KeyEvent evt) {
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        boolean shiftDown = evt.isShiftDown();
        int keyCode = evt.getKeyCode();
        if (keyCode == 38) {
            if (shiftDown) {
                this.rotate(0.0f, -1.0f);
            } else {
                this.zoom(1.1f);
            }
        } else if (keyCode == 40) {
            if (shiftDown) {
                this.rotate(0.0f, 1.0f);
            } else {
                this.zoom(0.9f);
            }
        } else if (shiftDown && keyCode == 37) {
            this.rotate(1.0f, 0.0f);
        } else if (shiftDown && keyCode == 39) {
            this.rotate(-1.0f, 0.0f);
        } else if (evt.getKeyChar() == 's') {
            Console.errPrintln("DEBUG: Rectangle selection");
            if (this.rectx2 != -1 && this.recty2 != -1) {
                this.rectSelect(this.rectx1, this.recty1, this.rectx2, this.recty2);
            }
        }
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
    }

    @Override
    public void mouseExited(MouseEvent evt) {
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        int x = evt.getX();
        int y = evt.getY();
        this.mouseX = x;
        this.mouseY = y;
        this.startx = x;
        this.starty = y;
        this.rectx1 = x;
        this.recty1 = y;
        this.rectx2 = -1;
        this.recty2 = -1;
        SequenceI found = this.findSequenceAtPoint(x, y);
        if (found != null) {
            if (this.av.getSelectionGroup() != null) {
                this.av.getSelectionGroup().addOrRemove(found, true);
                this.av.getSelectionGroup().setEndRes(this.av.getAlignment().getWidth() - 1);
            } else {
                this.av.setSelectionGroup(new SequenceGroup());
                this.av.getSelectionGroup().addOrRemove(found, true);
                this.av.getSelectionGroup().setEndRes(this.av.getAlignment().getWidth() - 1);
            }
            PaintRefresher.Refresh(this, this.av.getSequenceSetId());
            this.av.sendSelection();
        }
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        SequenceI found = this.findSequenceAtPoint(evt.getX(), evt.getY());
        if (found == null) {
            this.tooltip = null;
        } else {
            this.tooltip = found.getName();
            this.toolx = evt.getX();
            this.tooly = evt.getY();
        }
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        int xPos = evt.getX();
        int yPos = evt.getY();
        if (xPos == this.mouseX && yPos == this.mouseY) {
            return;
        }
        int xDelta = xPos - this.mouseX;
        int yDelta = yPos - this.mouseY;
        this.rotate(xDelta, yDelta);
        this.repaint();
    }

    public void rectSelect(int x1, int y1, int x2, int y2) {
        for (int i = 0; i < this.npoint; ++i) {
            SequencePoint sp = this.points.get(i);
            int tmp1 = (int)((double)((sp.coord.x - this.centre.x) * this.scale) + (double)this.getSize().width / 2.0);
            int tmp2 = (int)((double)((sp.coord.y - this.centre.y) * this.scale) + (double)this.getSize().height / 2.0);
            SequenceI sequence = sp.getSequence();
            if (tmp1 <= x1 || tmp1 >= x2 || tmp2 <= y1 || tmp2 >= y2 || this.av == null || this.av.getSelectionGroup().getSequences(null).contains(sequence)) continue;
            this.av.getSelectionGroup().addSequence(sequence, true);
        }
    }

    public SequenceI findSequenceAtPoint(int x, int y) {
        int halfwidth = this.getSize().width / 2;
        int halfheight = this.getSize().height / 2;
        int found = -1;
        for (int i = 0; i < this.npoint; ++i) {
            SequencePoint sp = this.points.get(i);
            int px = (int)((sp.coord.x - this.centre.x) * this.scale) + halfwidth;
            int py = (int)((sp.coord.y - this.centre.y) * this.scale) + halfheight;
            if (Math.abs(px - x) >= 3 || Math.abs(py - y) >= 3) continue;
            found = i;
            break;
        }
        if (found != -1) {
            return this.points.get(found).getSequence();
        }
        return null;
    }

    public void resetView() {
        this.img = null;
        this.resetAxes();
    }

    @Override
    public void zoom(float factor) {
        if (factor > 0.0f) {
            this.scalefactor *= factor;
        }
        this.scale = this.findScale();
    }

    @Override
    public void rotate(float x, float y) {
        int i;
        if (x == 0.0f && y == 0.0f) {
            return;
        }
        RotatableMatrix rotmat = new RotatableMatrix();
        if (y != 0.0f) {
            rotmat.rotate(y, RotatableMatrix.Axis.X);
        }
        if (x != 0.0f) {
            rotmat.rotate(x, RotatableMatrix.Axis.Y);
        }
        for (i = 0; i < this.npoint; ++i) {
            SequencePoint sp = this.points.get(i);
            sp.translate(-this.centre.x, -this.centre.y, -this.centre.z);
            sp.coord = rotmat.vectorMultiply(sp.coord);
            sp.translate(this.centre.x, this.centre.y, this.centre.z);
        }
        for (i = 0; i < 3; ++i) {
            this.axisEndPoints[i] = rotmat.vectorMultiply(this.axisEndPoints[i]);
        }
    }
}

