/*
 * Decompiled with CFR 0.152.
 */
package jalview.analysis.scoremodels;

import jalview.analysis.AlignmentAnnotationUtils;
import jalview.analysis.AlignmentUtils;
import jalview.analysis.scoremodels.DistanceScoreModel;
import jalview.analysis.scoremodels.ScoreMatrix;
import jalview.analysis.scoremodels.ScoreModels;
import jalview.analysis.scoremodels.SimilarityScoreModel;
import jalview.api.AlignmentViewPanel;
import jalview.api.FeatureRenderer;
import jalview.api.analysis.ScoreModelI;
import jalview.api.analysis.SimilarityParamsI;
import jalview.bin.Console;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentView;
import jalview.datamodel.SeqCigar;
import jalview.datamodel.SequenceI;
import jalview.math.Matrix;
import jalview.math.MatrixI;
import jalview.util.Constants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SecondaryStructureDistanceModel
extends DistanceScoreModel {
    private static final String NAME = "Secondary Structure Similarity";
    private ScoreMatrix ssRateMatrix;
    private String description;
    FeatureRenderer fr;
    ArrayList<AlignmentAnnotation> ssForSeqs = null;

    @Override
    public ScoreModelI getInstance(AlignmentViewPanel view) {
        try {
            SecondaryStructureDistanceModel instance = (SecondaryStructureDistanceModel)this.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            instance.configureFromAlignmentView(view);
            return instance;
        }
        catch (IllegalAccessException | InstantiationException e) {
            Console.errPrintln("Error in " + this.getClass().getName() + ".getInstance(): " + e.getMessage());
            return null;
        }
        catch (ReflectiveOperationException roe) {
            return null;
        }
    }

    boolean configureFromAlignmentView(AlignmentViewPanel view) {
        this.fr = view.cloneFeatureRenderer();
        return true;
    }

    @Override
    public SequenceI[] expandSeqData(SequenceI[] sequences, AlignmentView seqData, SimilarityParamsI scoreParams, List<String> labels, ArrayList<AlignmentAnnotation> ssAnnotationForSeqs, HashMap<Integer, String> annotationDetails) {
        this.ssForSeqs = new ArrayList();
        ArrayList<SequenceI> newSequences = new ArrayList<SequenceI>();
        ArrayList<SeqCigar> newCigs = new ArrayList<SeqCigar>();
        int sq = 0;
        AlignmentAnnotation[] alignAnnotList = this.fr.getViewport().getAlignment().getAlignmentAnnotation();
        String ssSource = scoreParams.getSecondaryStructureSource();
        if (ssSource == null || ssSource == "") {
            ssSource = "All";
        }
        Map<SequenceI, ArrayList<AlignmentAnnotation>> ssAlignmentAnnotationForSequences = AlignmentUtils.getSequenceAssociatedAlignmentAnnotations(alignAnnotList, ssSource);
        for (SeqCigar scig : seqData.getSequences()) {
            SequenceI alSeq = sequences[sq++];
            List ssec = ssAlignmentAnnotationForSequences.get(scig.getRefSeq());
            if (ssec == null) {
                newSequences.add(alSeq);
                if (alSeq != null) {
                    labels.add(Constants.STRUCTURE_PROVIDERS.get("None"));
                }
                SeqCigar newSeqCigar = scig;
                newCigs.add(newSeqCigar);
                this.ssForSeqs.add(null);
                continue;
            }
            for (int i = 0; i < ssec.size(); ++i) {
                if (alSeq != null) {
                    if (((AlignmentAnnotation)ssec.get(i)).hasAnnotationDetailsProperty()) {
                        annotationDetails.put(labels.size(), ((AlignmentAnnotation)ssec.get(i)).getAnnotationDetailsProperty());
                    }
                    String provider = AlignmentAnnotationUtils.extractSSSourceFromAnnotationDescription((AlignmentAnnotation)ssec.get(i));
                    labels.add(provider);
                }
                newSequences.add(alSeq);
                SeqCigar newSeqCigar = scig;
                newCigs.add(newSeqCigar);
                this.ssForSeqs.add((AlignmentAnnotation)ssec.get(i));
            }
        }
        ssAnnotationForSeqs.addAll(this.ssForSeqs);
        seqData.setSequences(newCigs.toArray(new SeqCigar[0]));
        return newSequences.toArray(new SequenceI[0]);
    }

    @Override
    public MatrixI findDistances(AlignmentView seqData, SimilarityParamsI params) {
        if (this.ssForSeqs == null || this.ssForSeqs.size() != seqData.getSequences().length) {
            SequenceI[] sequences = new SequenceI[seqData.getSequences().length];
            this.expandSeqData(sequences, seqData, params, new ArrayList<String>(), new ArrayList<AlignmentAnnotation>(), new HashMap<Integer, String>());
        }
        SeqCigar[] seqs = seqData.getSequences();
        int noseqs = seqs.length;
        int cpwidth = 0;
        double[][] similarities = new double[noseqs][noseqs];
        String ssSource = params.getSecondaryStructureSource();
        if (ssSource == null || ssSource == "") {
            ssSource = "All";
        }
        this.ssRateMatrix = ScoreModels.getInstance().getSecondaryStructureMatrix();
        int[] viscont = seqData.getVisibleContigs();
        for (int vc = 0; vc < viscont.length; vc += 2) {
            for (int cpos = viscont[vc]; cpos <= viscont[vc + 1]; ++cpos) {
                ++cpwidth;
                Set<SeqCigar> seqsWithoutGapAtCol = this.findSeqsWithoutGapAtColumn(seqs, cpos);
                for (int i = 0; i < noseqs - 1; ++i) {
                    AlignmentAnnotation aa_i = this.ssForSeqs.get(i);
                    boolean undefinedSS1 = aa_i == null;
                    boolean gap1 = !seqsWithoutGapAtCol.contains(seqs[i]);
                    char ss1 = '*';
                    if (!gap1 && !undefinedSS1) {
                        int seqPosition_i = seqs[i].findPosition(cpos);
                        if (aa_i != null) {
                            ss1 = AlignmentUtils.findSSAnnotationForGivenSeqposition(aa_i, seqPosition_i);
                        }
                    }
                    for (int j = i + 1; j < noseqs; ++j) {
                        boolean undefinedSS2;
                        AlignmentAnnotation aa_j = this.ssForSeqs.get(j);
                        boolean bl = undefinedSS2 = aa_j == null;
                        if (undefinedSS1 && undefinedSS2) {
                            double[] dArray = similarities[i];
                            int n = j;
                            dArray[n] = dArray[n] + (double)this.ssRateMatrix.getMaximumScore();
                            continue;
                        }
                        if (undefinedSS1 || undefinedSS2) {
                            double[] dArray = similarities[i];
                            int n = j;
                            dArray[n] = dArray[n] + (double)this.ssRateMatrix.getMinimumScore();
                            continue;
                        }
                        boolean gap2 = !seqsWithoutGapAtCol.contains(seqs[j]);
                        char ss2 = '*';
                        if (!gap2 && !undefinedSS2) {
                            int seqPosition = seqs[j].findPosition(cpos);
                            if (aa_j != null) {
                                ss2 = AlignmentUtils.findSSAnnotationForGivenSeqposition(aa_j, seqPosition);
                            }
                        }
                        if ((gap1 || gap2) && !params.includeGaps()) continue;
                        double similarityScore = this.ssRateMatrix.getPairwiseScore(ss1, ss2);
                        double[] dArray = similarities[i];
                        int n = j;
                        dArray[n] = dArray[n] + similarityScore;
                    }
                }
            }
        }
        for (int i = 0; i < noseqs; ++i) {
            for (int j = i + 1; j < noseqs; ++j) {
                double[] dArray = similarities[i];
                int n = j;
                dArray[n] = dArray[n] / (double)cpwidth;
                similarities[j][i] = similarities[i][j];
            }
        }
        return SimilarityScoreModel.similarityToDistance(new Matrix(similarities));
    }

    private Set<SeqCigar> findSeqsWithoutGapAtColumn(SeqCigar[] seqs, int columnPosition) {
        HashSet<SeqCigar> seqsWithoutGapAtCol = new HashSet<SeqCigar>();
        for (SeqCigar seq : seqs) {
            int spos = seq.findPosition(columnPosition);
            if (spos == -1) continue;
            seqsWithoutGapAtCol.add(seq);
        }
        return seqsWithoutGapAtCol;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isDNA() {
        return false;
    }

    @Override
    public boolean isProtein() {
        return true;
    }

    @Override
    public boolean isSecondaryStructure() {
        return true;
    }

    public String toString() {
        return "Score between sequences based on similarity between binary vectors marking secondary structure displayed at each column";
    }
}

