/*
 * Decompiled with CFR 0.152.
 */
package jalview.analysis;

import jalview.analysis.TreeModel;
import jalview.analysis.scoremodels.PIDModel;
import jalview.analysis.scoremodels.SimilarityParams;
import jalview.bin.ApplicationSingletonProvider;
import jalview.bin.Console;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.AlignmentOrder;
import jalview.datamodel.BinaryNode;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.datamodel.SequenceNode;
import jalview.util.QuickSort;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

public class AlignmentSorter
implements ApplicationSingletonProvider.ApplicationSingletonI {
    public static final String FEATURE_SCORE = "average_score";
    public static final String FEATURE_LABEL = "text";
    public static final String FEATURE_DENSITY = "density";
    boolean sortIdAscending = true;
    boolean sortDescripionAscending = true;
    int lastGroupHash = 0;
    boolean sortGroupAscending = true;
    AlignmentOrder lastOrder = null;
    boolean sortOrderAscending = true;
    TreeModel lastTree = null;
    boolean sortTreeAscending = true;
    private String lastSortByAnnotation;
    private String sortByFeatureCriteria;
    private boolean sortByFeatureAscending = true;
    private boolean sortLengthAscending;
    private boolean sortEValueAscending;
    private boolean sortBitScoreAscending;

    private AlignmentSorter() {
    }

    public static AlignmentSorter getInstance() {
        return ApplicationSingletonProvider.getInstance(AlignmentSorter.class);
    }

    public static void sortByPID(AlignmentI align, SequenceI s) {
        int nSeq = align.getHeight();
        float[] scores = new float[nSeq];
        Object[] seqs = new SequenceI[nSeq];
        String refSeq = s.getSequenceAsString();
        SimilarityParams pidParams = new SimilarityParams(true, true, true, true);
        for (int i = 0; i < nSeq; ++i) {
            scores[i] = (float)PIDModel.computePID(align.getSequenceAt(i).getSequenceAsString(), refSeq, pidParams);
            seqs[i] = align.getSequenceAt(i);
        }
        QuickSort.sort(scores, seqs);
        AlignmentSorter.setReverseOrder(align, (SequenceI[])seqs);
    }

    public static void sortByID(AlignmentI align) {
        int nSeq = align.getHeight();
        String[] ids = new String[nSeq];
        Object[] seqs = new SequenceI[nSeq];
        for (int i = 0; i < nSeq; ++i) {
            ids[i] = align.getSequenceAt(i).getName();
            seqs[i] = align.getSequenceAt(i);
        }
        QuickSort.sort(ids, seqs);
        AlignmentSorter as = AlignmentSorter.getInstance();
        as.sortIdAscending = !as.sortIdAscending;
        AlignmentSorter.set(align, (SequenceI[])seqs, as.sortIdAscending);
    }

    public static void sortByDescription(AlignmentI align) {
        int nSeq = align.getHeight();
        String[] ids = new String[nSeq];
        Object[] seqs = new SequenceI[nSeq];
        for (int i = 0; i < nSeq; ++i) {
            ids[i] = align.getSequenceAt(i).getDescription() != null ? align.getSequenceAt(i).getDescription() : "";
            seqs[i] = align.getSequenceAt(i);
        }
        QuickSort.sort(ids, seqs);
        AlignmentSorter as = AlignmentSorter.getInstance();
        as.sortDescripionAscending = !as.sortDescripionAscending;
        AlignmentSorter.set(align, (SequenceI[])seqs, as.sortDescripionAscending);
    }

    public static void sortByLength(AlignmentI align) {
        int nSeq = align.getHeight();
        float[] length = new float[nSeq];
        Object[] seqs = new SequenceI[nSeq];
        for (int i = 0; i < nSeq; ++i) {
            seqs[i] = align.getSequenceAt(i);
            length[i] = seqs[i].getEnd() - seqs[i].getStart();
        }
        QuickSort.sort(length, seqs);
        AlignmentSorter as = AlignmentSorter.getInstance();
        as.sortLengthAscending = !as.sortLengthAscending;
        AlignmentSorter.set(align, (SequenceI[])seqs, as.sortLengthAscending);
    }

    public static void sortByEValue(AlignmentI align) {
        int nSeq = align.getHeight();
        double[] evalue = new double[nSeq];
        Object[] seqs = new SequenceI[nSeq];
        for (int i = 0; i < nSeq; ++i) {
            seqs[i] = align.getSequenceAt(i);
            AlignmentAnnotation[] ann = seqs[i].getAnnotation("Search Scores");
            evalue[i] = ann != null ? ann[0].getEValue() : -1.0;
        }
        QuickSort.sort(evalue, seqs);
        AlignmentSorter as = AlignmentSorter.getInstance();
        as.sortEValueAscending = !as.sortEValueAscending;
        AlignmentSorter.set(align, (SequenceI[])seqs, as.sortEValueAscending);
    }

    public static void sortByBitScore(AlignmentI align) {
        int nSeq = align.getHeight();
        double[] score = new double[nSeq];
        Object[] seqs = new SequenceI[nSeq];
        for (int i = 0; i < nSeq; ++i) {
            seqs[i] = align.getSequenceAt(i);
            AlignmentAnnotation[] ann = seqs[i].getAnnotation("Search Scores");
            score[i] = ann != null ? ann[0].getEValue() : -1.0;
        }
        QuickSort.sort(score, seqs);
        AlignmentSorter as = AlignmentSorter.getInstance();
        as.sortBitScoreAscending = !as.sortBitScoreAscending;
        AlignmentSorter.set(align, (SequenceI[])seqs, as.sortBitScoreAscending);
    }

    public static void sortByGroup(AlignmentI align) {
        ArrayList<SequenceGroup> groups = new ArrayList<SequenceGroup>();
        AlignmentSorter as = AlignmentSorter.getInstance();
        if (groups.hashCode() != as.lastGroupHash) {
            as.sortGroupAscending = true;
            as.lastGroupHash = groups.hashCode();
        } else {
            as.sortGroupAscending = !as.sortGroupAscending;
        }
        for (SequenceGroup sg : align.getGroups()) {
            for (int j = 0; j < groups.size(); ++j) {
                SequenceGroup sg2 = (SequenceGroup)groups.get(j);
                if (sg.getSize() <= sg2.getSize()) continue;
                groups.add(j, sg);
                break;
            }
            if (groups.contains(sg)) continue;
            groups.add(sg);
        }
        ArrayList<SequenceI> tmp = new ArrayList<SequenceI>();
        for (int i = 0; i < groups.size(); ++i) {
            SequenceGroup sg = (SequenceGroup)groups.get(i);
            SequenceI[] orderedseqs = sg.getSequencesInOrder(align);
            for (int j = 0; j < orderedseqs.length; ++j) {
                tmp.add(orderedseqs[j]);
            }
        }
        AlignmentSorter.set(align, tmp, as.sortGroupAscending);
    }

    public static void sortBy(AlignmentI align, AlignmentOrder order) {
        List<SequenceI> tmp = order.getOrder();
        AlignmentSorter as = AlignmentSorter.getInstance();
        as.sortOrderAscending = as.lastOrder == order ? !as.sortOrderAscending : true;
        AlignmentSorter.set(align, tmp, as.sortOrderAscending);
    }

    private static List<SequenceI> getOrderByTree(AlignmentI align, TreeModel tree) {
        int nSeq = align.getHeight();
        List<SequenceI> tmp = new ArrayList<SequenceI>();
        tmp = AlignmentSorter._sortByTree(tree.getTopNode(), tmp, align.getSequences());
        if (tmp.size() != nSeq) {
            if (tmp.size() != nSeq) {
                AlignmentSorter.addStrays(align, tmp);
            }
            if (tmp.size() != nSeq) {
                Console.errPrintln("WARNING: tmp.size()=" + tmp.size() + " != nseq=" + nSeq + " in getOrderByTree - tree contains sequences not in alignment");
            }
        }
        return tmp;
    }

    public static void sortByTree(AlignmentI align, TreeModel tree) {
        List<SequenceI> tmp = AlignmentSorter.getOrderByTree(align, tree);
        AlignmentSorter as = AlignmentSorter.getInstance();
        if (as.lastTree != tree) {
            as.sortTreeAscending = true;
            as.lastTree = tree;
        } else {
            as.sortTreeAscending = !as.sortTreeAscending;
        }
        AlignmentSorter.set(align, tmp, as.sortTreeAscending);
    }

    private static void addStrays(AlignmentI align, List<SequenceI> tmp) {
        int nSeq = align.getHeight();
        for (int i = 0; i < nSeq; ++i) {
            if (tmp.contains(align.getSequenceAt(i))) continue;
            tmp.add(align.getSequenceAt(i));
        }
        if (nSeq != tmp.size()) {
            System.err.println("ERROR: Size still not right even after addStrays");
        }
    }

    private static List<SequenceI> _sortByTree(BinaryNode node, List<SequenceI> tmp, List<SequenceI> seqset) {
        if (node == null) {
            return tmp;
        }
        BinaryNode left = node.left();
        BinaryNode right = node.right();
        if (left == null && right == null) {
            if (!(node instanceof SequenceNode && ((SequenceNode)node).isPlaceholder() || node.element() == null || !(node.element() instanceof SequenceI) || tmp.contains(node.element()))) {
                tmp.add((SequenceI)node.element());
            }
            return tmp;
        }
        AlignmentSorter._sortByTree(left, tmp, seqset);
        AlignmentSorter._sortByTree(right, tmp, seqset);
        return tmp;
    }

    public static void recoverOrder(SequenceI[] alignment) {
        float[] ids = new float[alignment.length];
        for (int i = 0; i < alignment.length; ++i) {
            ids[i] = Float.valueOf(alignment[i].getName().substring(8)).floatValue();
        }
        QuickSort.sort(ids, (Object[])alignment);
    }

    public static void sortByAnnotationScore(String scoreLabel, AlignmentI alignment) {
        int i;
        Object[] seqs = alignment.getSequencesArray();
        boolean[] hasScore = new boolean[seqs.length];
        int hasScores = 0;
        double[] scores = new double[seqs.length];
        double min = 0.0;
        double max = 0.0;
        for (i = 0; i < seqs.length; ++i) {
            AlignmentAnnotation[] scoreAnn = seqs[i].getAnnotation(scoreLabel);
            if (scoreAnn != null) {
                hasScore[i] = true;
                scores[i] = scoreAnn[0].getScore();
                if (++hasScores == 1) {
                    max = min = scores[i];
                    continue;
                }
                if (max < scores[i]) {
                    max = scores[i];
                }
                if (!(min > scores[i])) continue;
                min = scores[i];
                continue;
            }
            hasScore[i] = false;
        }
        if (hasScores == 0) {
            return;
        }
        if (hasScores < seqs.length) {
            for (i = 0; i < seqs.length; ++i) {
                if (hasScore[i]) continue;
                scores[i] = max + (double)i + 1.0;
            }
        }
        QuickSort.sort(scores, seqs);
        AlignmentSorter as = AlignmentSorter.getInstance();
        if (as.lastSortByAnnotation != scoreLabel) {
            as.lastSortByAnnotation = scoreLabel;
            AlignmentSorter.setOrder(alignment, (SequenceI[])seqs);
        } else {
            AlignmentSorter.setReverseOrder(alignment, (SequenceI[])seqs);
        }
    }

    public static void sortByFeature(List<String> featureTypes, List<String> groups, int startCol, int endCol, AlignmentI alignment, String method) {
        if (method != FEATURE_SCORE && method != FEATURE_LABEL && method != FEATURE_DENSITY) {
            String msg = String.format("Implementation Error - sortByFeature method must be either '%s' or '%s'", FEATURE_SCORE, FEATURE_DENSITY);
            Console.errPrintln(msg);
            return;
        }
        AlignmentSorter.flipFeatureSortIfUnchanged(method, featureTypes, groups, startCol, endCol);
        Object[] seqs = alignment.getSequencesArray();
        boolean[] hasScore = new boolean[seqs.length];
        int hasScores = 0;
        double[] scores = new double[seqs.length];
        int[] seqScores = new int[seqs.length];
        Object[][] feats = new Object[seqs.length][];
        double min = 0.0;
        double max = 0.0;
        for (int i = 0; i < seqs.length; ++i) {
            String[] types = featureTypes == null ? null : featureTypes.toArray(new String[featureTypes.size()]);
            List<SequenceFeature> sfs = seqs[i].findFeatures(startCol + 1, endCol + 1, types);
            seqScores[i] = 0;
            scores[i] = 0.0;
            ListIterator<SequenceFeature> it = sfs.listIterator();
            while (it.hasNext()) {
                SequenceFeature sf = (SequenceFeature)it.next();
                String featureGroup = sf.getFeatureGroup();
                if (groups != null && featureGroup != null && !"".equals(featureGroup) && !groups.contains(featureGroup)) {
                    it.remove();
                    continue;
                }
                float score = sf.getScore();
                if (!FEATURE_SCORE.equals(method) || Float.isNaN(score)) continue;
                if (seqScores[i] == 0) {
                    ++hasScores;
                }
                int n = i;
                seqScores[n] = seqScores[n] + 1;
                hasScore[i] = true;
                int n2 = i;
                scores[n2] = scores[n2] + (double)score;
            }
            feats[i] = sfs.toArray(new SequenceFeature[sfs.size()]);
            if (!sfs.isEmpty() && method == FEATURE_LABEL) {
                String[] labs = new String[sfs.size()];
                for (int l = 0; l < sfs.size(); ++l) {
                    SequenceFeature sf = sfs.get(l);
                    String description = sf.getDescription();
                    labs[l] = description != null ? description : sf.getType();
                }
                QuickSort.sort(labs, feats[i]);
            }
            if (!hasScore[i]) continue;
            int n = i;
            scores[n] = scores[n] / (double)seqScores[i];
            if (hasScores == 1) {
                max = min = scores[i];
                continue;
            }
            max = Math.max(max, scores[i]);
            min = Math.min(min, scores[i]);
        }
        boolean doSort = false;
        if (FEATURE_SCORE.equals(method)) {
            if (hasScores == 0) {
                return;
            }
            if (hasScores < seqs.length) {
                for (int i = 0; i < seqs.length; ++i) {
                    if (hasScore[i]) continue;
                    scores[i] = max + 1.0 + (double)i;
                }
            }
            doSort = true;
        } else if (FEATURE_DENSITY.equals(method)) {
            for (int i = 0; i < seqs.length; ++i) {
                int featureCount = feats[i] == null ? 0 : ((SequenceFeature[])feats[i]).length;
                scores[i] = featureCount;
            }
            doSort = true;
        }
        if (doSort) {
            QuickSort.sortByDouble(scores, seqs, AlignmentSorter.getInstance().sortByFeatureAscending);
        }
        AlignmentSorter.setOrder(alignment, (SequenceI[])seqs);
    }

    protected static void flipFeatureSortIfUnchanged(String method, List<String> featureTypes, List<String> groups, int startCol, int endCol) {
        StringBuilder sb = new StringBuilder(64);
        sb.append(startCol).append(method).append(endCol);
        if (featureTypes != null) {
            Collections.sort(featureTypes);
            sb.append(featureTypes.toString());
        }
        if (groups != null) {
            Collections.sort(groups);
            sb.append(groups.toString());
        }
        String scoreCriteria = sb.toString();
        AlignmentSorter as = AlignmentSorter.getInstance();
        as.sortByFeatureAscending = as.sortByFeatureCriteria == null || !scoreCriteria.equals(as.sortByFeatureCriteria) ? true : !as.sortByFeatureAscending;
        as.sortByFeatureCriteria = scoreCriteria;
    }

    private static void set(AlignmentI align, List<SequenceI> tmp, boolean ascending) {
        AlignmentSorter.set(align, AlignmentSorter.vectorSubsetToArray(align.getSequences(), tmp), ascending);
    }

    private static void set(AlignmentI align, SequenceI[] seqs, boolean ascending) {
        if (ascending) {
            AlignmentSorter.setOrder(align, seqs);
        } else {
            AlignmentSorter.setReverseOrder(align, seqs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setOrder(AlignmentI align, SequenceI[] seqs) {
        List<SequenceI> seqList;
        List<SequenceI> list = seqList = align.getSequences();
        synchronized (list) {
            int i;
            ArrayList<SequenceI> tmp = new ArrayList<SequenceI>();
            for (i = 0; i < seqs.length; ++i) {
                if (!seqList.contains(seqs[i])) continue;
                tmp.add(seqs[i]);
            }
            seqList.clear();
            for (i = 0; i < tmp.size(); ++i) {
                seqList.add((SequenceI)tmp.get(i));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setReverseOrder(AlignmentI align, SequenceI[] seqs) {
        List<SequenceI> seqList;
        int nSeq = seqs.length;
        int len = (nSeq + nSeq % 2) / 2;
        List<SequenceI> list = seqList = align.getSequences();
        synchronized (list) {
            for (int i = 0; i < len; ++i) {
                seqList.set(i, seqs[nSeq - i - 1]);
                seqList.set(nSeq - i - 1, seqs[i]);
            }
        }
    }

    private static SequenceI[] vectorSubsetToArray(List<SequenceI> seqList, List<SequenceI> tmp) {
        int i;
        ArrayList<SequenceI> seqs = new ArrayList<SequenceI>();
        int n = seqList.size();
        BitSet bs = new BitSet(n);
        bs.set(0, n);
        int nt = tmp.size();
        for (i = 0; i < nt; ++i) {
            SequenceI sq = tmp.get(i);
            int idx = seqList.indexOf(sq);
            if (idx < 0 || !bs.get(idx)) continue;
            seqs.add(sq);
            bs.clear(idx);
        }
        i = bs.nextSetBit(0);
        while (i >= 0) {
            seqs.add(seqList.get(i));
            i = bs.nextSetBit(i + 1);
        }
        return seqs.toArray(new SequenceI[seqs.size()]);
    }
}

