/*
 * Decompiled with CFR 0.152.
 */
package compbio.data.sequence;

import compbio.data.sequence.RNAStructScoreManager;
import compbio.data.sequence.Score;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;

@XmlSeeAlso(value={RNAStructScoreManager.class})
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ScoreManager {
    @XmlTransient
    public static final String SINGLE_ENTRY_KEY = "Alignment";
    protected List<ScoreHolder> seqScores;

    protected ScoreManager() {
    }

    private ScoreManager(String id, Set<Score> data) {
        this.seqScores = new ArrayList<ScoreHolder>();
        this.seqScores.add(new ScoreHolder(id, data));
    }

    private ScoreManager(Map<String, Set<Score>> data) {
        ArrayList<ScoreHolder> seqScores = new ArrayList<ScoreHolder>();
        for (Map.Entry<String, Set<Score>> singleSeqScores : data.entrySet()) {
            seqScores.add(new ScoreHolder(singleSeqScores.getKey(), singleSeqScores.getValue()));
        }
        this.seqScores = seqScores;
    }

    public static ScoreManager newInstance(Map<String, Set<Score>> data) {
        return new ScoreManager(data);
    }

    public static ScoreManager newInstanceSingleScore(Map<String, Score> seqScoresMap) {
        TreeMap<String, Set<Score>> multipleScoresMap = new TreeMap<String, Set<Score>>();
        for (Map.Entry<String, Score> seqScore : seqScoresMap.entrySet()) {
            TreeSet<Score> scores = new TreeSet<Score>();
            scores.add(seqScore.getValue());
            multipleScoresMap.put(seqScore.getKey(), scores);
        }
        return new ScoreManager(multipleScoresMap);
    }

    public static ScoreManager newInstanceSingleSequence(Set<Score> data) {
        return new ScoreManager(SINGLE_ENTRY_KEY, new TreeSet<Score>(data));
    }

    public Map<String, TreeSet<Score>> asMap() {
        TreeMap<String, TreeSet<Score>> seqScoresMap = new TreeMap<String, TreeSet<Score>>();
        for (ScoreHolder sch : this.seqScores) {
            TreeSet<Score> oldValue = seqScoresMap.put(sch.id, new TreeSet<Score>((SortedSet<Score>)sch.scores));
            if (oldValue == null) continue;
            throw new IllegalStateException("Cannot represent this ScoreManager instance as a Map as it contains duplicated keys: " + sch.id);
        }
        return seqScoresMap;
    }

    public Set<Score> asSet() {
        if (this.seqScores.size() == 0 || this.seqScores.size() > 1) {
            throw new IllegalStateException("This ScoreManager has no or multiple sequence entries and thus cannot be represented as a Set. Number of entries are: " + this.seqScores.size());
        }
        ScoreHolder sch = this.seqScores.get(0);
        return sch.scores;
    }

    public int getNumberOfSeq() {
        return this.seqScores.size();
    }

    public ScoreHolder getAnnotationForSequence(String seqId) {
        for (ScoreHolder sch : this.seqScores) {
            if (!sch.id.equals(seqId)) continue;
            return sch;
        }
        return null;
    }

    public void writeOut(Writer outStream) throws IOException {
        assert (outStream != null) : "Output steam is not defined!";
        if (this.seqScores == null) {
            return;
        }
        for (ScoreHolder oneSeqScores : this.seqScores) {
            if (oneSeqScores == null) continue;
            oneSeqScores.writeOut(outStream);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.seqScores == null ? 0 : this.seqScores.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ScoreManager other = (ScoreManager)obj;
        return !(this.seqScores == null ? other.seqScores != null : !this.seqScores.equals(other.seqScores));
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class ScoreHolder {
        public String id;
        public TreeSet<Score> scores;

        private ScoreHolder() {
        }

        ScoreHolder(String id, Set<Score> scores) {
            this.id = id;
            this.scores = new TreeSet<Score>(scores);
        }

        public void writeOut(Writer writer) throws IOException {
            writer.write(">" + this.id + "\n");
            Score.write(this.scores, writer);
        }

        public Score getScoreByMethod(Enum<?> method) {
            for (Score sc : this.scores) {
                if (!method.toString().equals(sc.getMethod())) continue;
                return sc;
            }
            return null;
        }

        public Score getScoreByMethod(String method) {
            for (Score sc : this.scores) {
                if (!method.toString().equals(sc.getMethod())) continue;
                return sc;
            }
            return null;
        }

        public int getNumberOfScores() {
            return this.scores.size();
        }

        public int hashCode() {
            int prime = 17;
            int result = 1;
            result = 17 * result + (this.id == null ? 0 : this.id.hashCode());
            result = 17 * result + (this.scores == null ? 0 : this.scores.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ScoreHolder other = (ScoreHolder)obj;
            if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
                return false;
            }
            return !(this.scores == null ? other.scores != null : !this.scores.equals(other.scores));
        }
    }
}

