/*
 * Decompiled with CFR 0.152.
 */
package jalview.util;

import jalview.util.ErrorLog;
import jalview.util.HttpUtils;
import java.awt.Image;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.ImageIcon;

public class ChannelProperties {
    public static final String CHANNEL_PROPERTIES_FILENAME = "channel.props";
    private static Properties channelProps;
    private static final Properties defaultProps;
    private static Map<String, Image> imageMap;
    private static Map<String, URL> urlMap;
    private static final ArrayList<Image> iconList;
    public static final String FALLBACK_APPNAME = "Jalview";

    protected static void loadProps(File dir) {
        File channelPropsFile = new File(dir, CHANNEL_PROPERTIES_FILENAME);
        if (channelPropsFile.exists()) {
            try {
                FileInputStream is = new FileInputStream(channelPropsFile);
                channelProps.load(is);
            }
            catch (FileNotFoundException e) {
                ErrorLog.errPrintln(e.getMessage());
            }
            catch (IOException e) {
                ErrorLog.errPrintln(e.getMessage());
            }
        }
    }

    private static Properties channelProps() {
        return channelProps;
    }

    private static Map<String, Image> imageMap() {
        return imageMap;
    }

    private static Map<String, URL> urlMap() {
        return urlMap;
    }

    public static String getProperty(String key) {
        return ChannelProperties.getProperty(key, null, true);
    }

    public static String getProperty(String key, String defaultVal) {
        return ChannelProperties.getProperty(key, defaultVal, false);
    }

    private static String getProperty(String key, String defaultVal, boolean useClassDefaultProps) {
        if (ChannelProperties.channelProps() != null) {
            if (ChannelProperties.channelProps().containsKey(key)) {
                return ChannelProperties.channelProps().getProperty(key, useClassDefaultProps ? defaultProps.getProperty(key) : defaultVal);
            }
            ErrorLog.errPrintln("Failed to get channel property '" + key + "'");
        }
        return null;
    }

    public static Image getImage(String key) {
        return ChannelProperties.getImage(key, null, true);
    }

    public static Image getImage(String key, Image defaultImg) {
        return ChannelProperties.getImage(key, defaultImg, false);
    }

    private static Image getImage(String key, Image defaultImg, boolean useClassDefaultImage) {
        Image img = null;
        if (ChannelProperties.imageMap().containsKey(key)) {
            img = ChannelProperties.imageMap().get(key);
        }
        if (img == null) {
            String path = ChannelProperties.getProperty(key, null, useClassDefaultImage);
            if (path == null) {
                return useClassDefaultImage ? null : defaultImg;
            }
            URL imageURL = ChannelProperties.class.getResource(path);
            ImageIcon imgIcon = imageURL == null ? null : new ImageIcon(imageURL);
            Image image = img = imgIcon == null ? null : imgIcon.getImage();
            if (img == null) {
                ErrorLog.errPrintln("Failed to load channel image " + key + "=" + path);
                if (!useClassDefaultImage) {
                    return defaultImg;
                }
            } else {
                ChannelProperties.imageMap().put(key, img);
                urlMap.put(key, imageURL);
            }
        }
        return img;
    }

    public static URL getImageURL(String key) {
        if (ChannelProperties.getImage(key) != null) {
            if (ChannelProperties.urlMap().containsKey(key)) {
                return ChannelProperties.urlMap().getOrDefault(key, null);
            }
            ErrorLog.errPrintln("Do not use getImageURL(key) before using getImage(key...)");
        }
        return null;
    }

    public static ArrayList<Image> getIconList() {
        return iconList;
    }

    static {
        Image logo;
        imageMap = new HashMap<String, Image>();
        urlMap = new HashMap<String, URL>();
        defaultProps = new Properties();
        defaultProps.put("app_name", FALLBACK_APPNAME);
        defaultProps.put("banner", "/default_images/jalview_banner.png");
        defaultProps.put("logo.16", "/default_images/jalview_logo-16.png");
        defaultProps.put("logo.32", "/default_images/jalview_logo-32.png");
        defaultProps.put("logo.38", "/default_images/jalview_logo-38.png");
        defaultProps.put("logo.48", "/default_images/jalview_logo-48.png");
        defaultProps.put("logo.64", "/default_images/jalview_logo-64.png");
        defaultProps.put("logo.128", "/default_images/jalview_logo-128.png");
        defaultProps.put("logo.256", "/default_images/jalview_logo-256.png");
        defaultProps.put("logo.512", "/default_images/jalview_logo-512.png");
        defaultProps.put("rotatable_logo.48", "/default_images/rotatable_jalview_logo-38.png");
        defaultProps.put("bg_logo.28", "/default_images/barton_group-28.png");
        defaultProps.put("bg_logo.30", "/default_images/barton_group-30.png");
        defaultProps.put("bg_logo.32", "/default_images/barton_group-32.png");
        defaultProps.put("uod_banner.28", "/default_images/UoD_banner-28.png");
        defaultProps.put("uod_banner.30", "/default_images/UoD_banner-30.png");
        defaultProps.put("uod_banner.32", "/default_images/UoD_banner-32.png");
        defaultProps.put("default_appbase", "https://www.jalview.org/getdown/release/1.8");
        defaultProps.put("preferences.filename", ".jalview_properties");
        defaultProps.put("channel", "none");
        Properties tryChannelProps = new Properties();
        URL channelPropsURL = ChannelProperties.class.getResource("/channel.props");
        if (channelPropsURL == null) {
            ErrorLog.errPrintln("Failed to find '/channel.props' file at '" + (channelPropsURL == null ? "null" : channelPropsURL.toString()) + "'. Using class defaultProps.");
            tryChannelProps = defaultProps;
        } else {
            try {
                InputStream channelPropsIS = HttpUtils.openStream(channelPropsURL);
                tryChannelProps.load(channelPropsIS);
                channelPropsIS.close();
            }
            catch (IOException e) {
                ErrorLog.errPrintln(e.getMessage());
            }
        }
        channelProps = tryChannelProps;
        iconList = new ArrayList();
        List<String> sizes = Arrays.asList("16", "32", "48", "64", "128", "256", "512");
        for (String size : sizes) {
            logo = null;
            logo = ChannelProperties.getImage("logo." + size, null, false);
            if (logo == null) continue;
            iconList.add(logo);
        }
        if (iconList.size() == 0) {
            for (String size : sizes) {
                logo = null;
                String path = defaultProps.getProperty("logo." + size);
                URL imageURL = ChannelProperties.class.getResource(path);
                ImageIcon imgIcon = imageURL == null ? null : new ImageIcon(imageURL);
                logo = imgIcon == null ? null : imgIcon.getImage();
                if (logo == null) continue;
                iconList.add(logo);
            }
        }
    }
}

