/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.views;

import fr.orsay.lri.varna.VARNAPanel;
import fr.orsay.lri.varna.components.ColorRenderer;
import fr.orsay.lri.varna.models.rna.ModeleBase;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;

public class VueBaseValues
extends JPanel
implements TableModelListener {
    private JTable table;
    private ValueTableModel _tm;
    private VARNAPanel _vp;
    private ArrayList<ModeleBase> data;
    private ArrayList<Double> _backup;
    private ArrayList<Object> columns;

    public VueBaseValues(VARNAPanel vARNAPanel) {
        super(new GridLayout(1, 0));
        this._vp = vARNAPanel;
        this.init();
    }

    private void init() {
        int n;
        Object[] objectArray = new Object[]{"Number", "Base", "Value", "Preview"};
        this.columns = new ArrayList();
        for (n = 0; n < objectArray.length; ++n) {
            this.columns.add(objectArray[n]);
        }
        this._backup = new ArrayList();
        this.data = new ArrayList();
        for (n = 0; n < this._vp.getRNA().get_listeBases().size(); ++n) {
            ModeleBase modeleBase = this._vp.getRNA().get_listeBases().get(n);
            this.data.add(modeleBase);
            this._backup.add(modeleBase.getValue());
        }
        this._tm = new ValueTableModel();
        this.table = new JTable(this._tm);
        this.table.setDefaultRenderer(Color.class, new ColorRenderer(true));
        this.table.setPreferredScrollableViewportSize(new Dimension(300, 300));
        this.table.getModel().addTableModelListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        this.add(jScrollPane);
    }

    public void cancelChanges() {
        for (int i = 0; i < this._vp.getRNA().get_listeBases().size(); ++i) {
            ModeleBase modeleBase = this._vp.getRNA().get_listeBases().get(i);
            modeleBase.setValue(this._backup.get(i));
        }
        this._vp.getRNA().rescaleColorMap(this._vp.getColorMap());
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent.getType() == 0) {
            this.table.repaint();
        }
    }

    private class ValueTableModel
    extends AbstractTableModel {
        private ValueTableModel() {
        }

        @Override
        public String getColumnName(int n) {
            return VueBaseValues.this.columns.get(n).toString();
        }

        @Override
        public int getRowCount() {
            return VueBaseValues.this.data.size();
        }

        @Override
        public int getColumnCount() {
            return VueBaseValues.this.columns.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            ModeleBase modeleBase = (ModeleBase)VueBaseValues.this.data.get(n);
            if (n2 == 0) {
                return new Integer(modeleBase.getBaseNumber());
            }
            if (n2 == 1) {
                return new String(modeleBase.getContent());
            }
            if (n2 == 2) {
                return new Double(modeleBase.getValue());
            }
            if (n2 == 3) {
                return VueBaseValues.this._vp.getColorMap().getColorForValue(modeleBase.getValue());
            }
            return "N/A";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return this.getColumnName(n2).equals("Value");
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (this.getColumnName(n2).equals("Value")) {
                ((ModeleBase)VueBaseValues.this.data.get(n)).setValue((Double)object);
                VueBaseValues.this._vp.getRNA().rescaleColorMap(VueBaseValues.this._vp.getColorMap());
                VueBaseValues.this._vp.repaint();
                this.fireTableCellUpdated(n, n2);
            }
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }
    }
}

