/*
 * Decompiled with CFR 0.152.
 */
import fr.orsay.lri.varna.VARNAPanel;
import fr.orsay.lri.varna.controlers.ControleurScriptParser;
import fr.orsay.lri.varna.exceptions.ExceptionFileFormatOrSyntax;
import fr.orsay.lri.varna.exceptions.ExceptionLoadingFailed;
import fr.orsay.lri.varna.exceptions.ExceptionModeleStyleBaseSyntaxError;
import fr.orsay.lri.varna.exceptions.ExceptionNonEqualLength;
import fr.orsay.lri.varna.exceptions.ExceptionParameterError;
import fr.orsay.lri.varna.interfaces.InterfaceParameterLoader;
import fr.orsay.lri.varna.models.VARNAConfigLoader;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JApplet;
import javax.swing.JOptionPane;

public class VARNA
extends JApplet
implements InterfaceParameterLoader,
DropTargetListener {
    ArrayList<VARNAPanel> _vpl = null;
    private static final long serialVersionUID = -2598221520127067670L;

    @Override
    public void init() {
        try {
            int n;
            VARNAConfigLoader vARNAConfigLoader = new VARNAConfigLoader(this);
            try {
                this._vpl = vARNAConfigLoader.createVARNAPanels();
                for (n = 0; n < this._vpl.size(); ++n) {
                    new DropTarget(this._vpl.get(n), this);
                }
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, iOException.getMessage(), "VARNA Error", 0);
            }
            catch (ExceptionFileFormatOrSyntax exceptionFileFormatOrSyntax) {
                JOptionPane.showMessageDialog(this, exceptionFileFormatOrSyntax.getMessage(), "VARNA Error", 0);
            }
            catch (ExceptionLoadingFailed exceptionLoadingFailed) {
                JOptionPane.showMessageDialog(this, exceptionLoadingFailed.getMessage(), "VARNA Error", 0);
            }
            this.setLayout(new GridLayout(vARNAConfigLoader.getNbColumns(), vARNAConfigLoader.getNbRows()));
            for (n = 0; n < this._vpl.size(); ++n) {
                this.getContentPane().add(this._vpl.get(n));
            }
            this.getContentPane().setVisible(true);
            this.getContentPane().repaint();
        }
        catch (ExceptionParameterError exceptionParameterError) {
            VARNAPanel.errorDialogStatic(exceptionParameterError, this);
        }
        catch (ExceptionModeleStyleBaseSyntaxError exceptionModeleStyleBaseSyntaxError) {
            VARNAPanel.errorDialogStatic(exceptionModeleStyleBaseSyntaxError, this);
        }
        catch (ExceptionNonEqualLength exceptionNonEqualLength) {
            VARNAPanel.errorDialogStatic(exceptionNonEqualLength, this);
        }
    }

    @Override
    public String getParameterValue(String string, String string2) {
        if (this.getParameter(string) == null) {
            return string2;
        }
        return this.getParameter(string);
    }

    @Override
    public String[][] getParameterInfo() {
        return VARNAConfigLoader.getParameterInfo();
    }

    public ArrayList<VARNAPanel> getPanels() {
        return this._vpl;
    }

    public String getSelection() {
        return this.getSelection(0);
    }

    public String getSelection(int n) {
        String string = "[";
        VARNAPanel vARNAPanel = this._vpl.get(n);
        ArrayList<Integer> arrayList = vARNAPanel.getSelectionIndices();
        for (int i = 0; i < arrayList.size(); ++i) {
            int n2 = (Integer)arrayList.get(i);
            if (i > 0) {
                string = string + ",";
            }
            string = string + n2;
        }
        string = string + "]";
        return string;
    }

    public void runScript(String string) {
        if (this._vpl.size() > 0) {
            VARNAPanel vARNAPanel = this._vpl.get(0);
            try {
                ControleurScriptParser.executeScript(vARNAPanel, string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void setRNA(String string, String string2) {
        if (this._vpl.size() > 0) {
            try {
                this._vpl.get(0).drawRNA(string, string2);
            }
            catch (ExceptionNonEqualLength exceptionNonEqualLength) {
                exceptionNonEqualLength.printStackTrace();
            }
        }
    }

    public void setSmoothedRNA(String string, String string2) {
        if (this._vpl.size() > 0) {
            try {
                this._vpl.get(0).drawRNAInterpolated(string, string2);
                this._vpl.get(0).repaint();
            }
            catch (ExceptionNonEqualLength exceptionNonEqualLength) {
                exceptionNonEqualLength.printStackTrace();
            }
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        try {
            Transferable transferable = dropTargetDropEvent.getTransferable();
            DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (!dataFlavorArray[i].isFlavorJavaFileListType()) continue;
                dropTargetDropEvent.acceptDrop(3);
                List list = (List)transferable.getTransferData(dataFlavorArray[i]);
                for (int j = 0; j < list.size(); ++j) {
                    DropTarget dropTarget;
                    Component component;
                    Object e = list.get(j);
                    if (!(dropTargetDropEvent.getSource() instanceof DropTarget) || !((component = (dropTarget = (DropTarget)dropTargetDropEvent.getSource()).getComponent()) instanceof VARNAPanel)) continue;
                    VARNAPanel vARNAPanel = (VARNAPanel)component;
                    String string = e.toString();
                    vARNAPanel.loadFile(string, true);
                    vARNAPanel.repaint();
                }
                dropTargetDropEvent.dropComplete(true);
                return;
            }
            dropTargetDropEvent.rejectDrop();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            dropTargetDropEvent.rejectDrop();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }
}

