/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.vamsas.test.simpleclient;

import java.io.File;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.util.jar.JarFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.zip.ZipFile;
import uk.ac.vamsas.client.simpleclient.Lock;
import uk.ac.vamsas.client.simpleclient.SimpleDocument;
import uk.ac.vamsas.client.simpleclient.VamsasArchiveReader;
import uk.ac.vamsas.client.simpleclient.VamsasFile;
import uk.ac.vamsas.objects.core.ApplicationData;
import uk.ac.vamsas.objects.core.User;
import uk.ac.vamsas.objects.core.VAMSAS;
import uk.ac.vamsas.objects.core.VamsasDocument;
import uk.ac.vamsas.test.objects.Core;
import uk.ac.vamsas.test.simpleclient.ArchiveReports;

public class VamsasArchive {
    static Log log = LogFactory.getLog((Class)VamsasArchive.class);

    public static ApplicationData makeDemoAppdata(uk.ac.vamsas.client.simpleclient.VamsasArchive va, String apname, String userName, String userOrg) {
        if (va == null) {
            return null;
        }
        VamsasArchiveReader vread = null;
        try {
            vread = va.getOriginalArchiveReader();
        }
        catch (Exception e) {
            log.error((Object)"Failed to get original archive reader!", (Throwable)e);
            return null;
        }
        ApplicationData appdata = new ApplicationData();
        appdata.setName("uk.ac.vamsas.test.simpleclient.VamsasArchive");
        appdata.setData(new String("this is some test data.").getBytes());
        User apuser = new User();
        apuser.setFullname(userName);
        apuser.setOrganization(userOrg);
        String appdata_ref = "vamsas:" + apname + "/" + apuser.getOrganization() + "/" + apuser.getFullname();
        SimpleDocument sdoc = new SimpleDocument("test.simpleclient.VamsasArchive");
        if (vread != null) {
            try {
                VamsasDocument orignalnew = sdoc.getVamsasDocument(vread);
                log.info((Object)"*** Dump follows ***");
                ArchiveReports.reportDocument(orignalnew, vread, false, System.out);
                log.info((Object)"*** Dump precedes ***");
            }
            catch (Exception e) {
                log.info((Object)"makeDemoAppdata: Problems accessing original document");
            }
            log.info((Object)"Reading (and avoiding references to) original data");
            if (vread.getAppdataStream(appdata_ref) != null) {
                try {
                    va.transferAppDataEntry(appdata_ref);
                }
                catch (Exception e) {
                    log.warn((Object)("Exception when transferring appdata reference : " + appdata_ref), (Throwable)e);
                }
                int i = 0;
                while (vread.getAppdataStream(appdata_ref + "/" + Integer.toString(++i)) != null) {
                    try {
                        va.transferAppDataEntry(appdata_ref + "/" + Integer.toString(i));
                    }
                    catch (Exception e) {
                        log.warn((Object)("Exception when transferring appdata reference : " + appdata_ref), (Throwable)e);
                    }
                }
                appdata_ref = appdata_ref + "/" + Integer.toString(i);
            }
        }
        log.info((Object)"Adding new data stuff.");
        log.info((Object)"Writing an apdata reference using AppDataStream interface.");
        apuser.setDataReference(appdata_ref);
        appdata.addUser(apuser);
        appdata.setVersion("noggin");
        try {
            ObjectOutputStream ost = new ObjectOutputStream(va.getAppDataStream(appdata_ref));
            ost.writeObject(appdata);
            ost.close();
        }
        catch (Exception e) {
            log.warn((Object)("Couldn't write appdata reference " + appdata_ref));
        }
        return appdata;
    }

    public static void main(String[] args) {
        try {
            VamsasArchiveReader vreader;
            SimpleDocument sdoc;
            VamsasDocument finaldoc;
            Object jf;
            File av = args.length > 0 ? new File(args[0]) : new File("test/vamsas.zip");
            try {
                RandomAccessFile raf = new RandomAccessFile(av, "r");
                raf.readByte();
                raf.close();
            }
            catch (Exception f) {
                log.info((Object)("Couldn't random access file archive " + av), (Throwable)f);
            }
            try {
                jf = new JarFile(av, true, 1);
                if (((JarFile)jf).getEntry("vamsasDocument.xml") != null) {
                    log.info((Object)("Valid archive (sun) " + av));
                }
                ((java.util.zip.ZipFile)jf).close();
            }
            catch (Exception f) {
                log.warn((Object)("Couldn't access jar archive with sun jartools: " + av), (Throwable)f);
            }
            try {
                jf = new ZipFile(av);
                if (((ZipFile)jf).getEntry("vamsasDocument.xml") != null) {
                    log.info((Object)("Valid archive (apache) " + av));
                }
                ((ZipFile)jf).close();
            }
            catch (Exception f) {
                log.warn((Object)("Couldn't access jar archive with apache ziptool: " + av), (Throwable)f);
            }
            log.info((Object)("Opening archive " + av));
            uk.ac.vamsas.client.simpleclient.VamsasArchive varchive = new uk.ac.vamsas.client.simpleclient.VamsasArchive(av, true);
            VAMSAS[] roots = (VAMSAS[])varchive.getOriginalRoots();
            if (roots != null) {
                log.info((Object)"Report on Original roots in archive:");
                ArchiveReports.rootReport(roots, true, System.out);
            }
            log.info((Object)"Getting current vamsas document.");
            VamsasDocument doc = varchive.getVamsasDocument();
            ArchiveReports.reportDocument(doc, varchive.getOriginalArchiveReader(), true, System.out);
            log.info((Object)"Retrieving backup");
            File backup = varchive.backupFile();
            if (backup == null) {
                log.info((Object)(av + " is a New Archive."));
            } else {
                log.info((Object)(av + " has been backed up as " + backup));
            }
            File newf = new File(av.getAbsolutePath() + "_new.zip");
            VamsasFile sfile = new VamsasFile(newf);
            if (newf.exists()) {
                log.info((Object)("Removing existing " + newf));
                newf.delete();
            }
            log.info((Object)("Now writing new Archive into " + newf.getAbsolutePath()));
            uk.ac.vamsas.client.simpleclient.VamsasArchive va = null;
            sfile.getLock();
            va = new uk.ac.vamsas.client.simpleclient.VamsasArchive(newf, true, true, sfile);
            ApplicationData appdata = VamsasArchive.makeDemoAppdata(va, "uk.ac.vamsas.test.simpleclient.VamsasArchive", "arnold Bugger esq", "disOrganised");
            log.info((Object)"Preparing to write new document.");
            doc.addApplicationData(appdata);
            doc.addVAMSAS(Core.getDemoVamsas());
            va.putVamsasDocument(doc);
            va.closeArchive();
            sfile.unLock();
            log.info((Object)"Dump of new vamsas document :");
            log.info((Object)"Testing update: ");
            Lock lock = sfile.getLock();
            if (lock == null) {
                while ((lock = sfile.getLock()) == null) {
                    log.info((Object)"Waiting for lock.");
                    Thread.sleep(100L);
                }
            }
            VamsasArchiveReader vreader2 = new VamsasArchiveReader(sfile.getVamsasFile());
            SimpleDocument sdoc2 = new SimpleDocument("testing new vamsas write");
            ArchiveReports.reportDocument(sdoc2.getVamsasDocument(vreader2), vreader2, true, System.out);
            sfile.unLock();
            log.info((Object)("Now Cancelling write to original archive " + av));
            if (varchive.cancelArchive()) {
                log.info((Object)"Successfully cancelled.");
            } else {
                log.info((Object)"Didn't cancel.");
            }
            long t = System.currentTimeMillis() + 200L;
            while (t > System.currentTimeMillis()) {
            }
            log.info((Object)"Now testing archive update.");
            va = new uk.ac.vamsas.client.simpleclient.VamsasArchive(newf, false, true, sfile);
            doc = va.getVamsasDocument();
            doc.addVAMSAS(Core.getDemoVamsas());
            doc.addApplicationData(VamsasArchive.makeDemoAppdata(va, "uk.ac.vamsas.test.simpleclient.VamsasArchive", "another old Bugger esq", "rescinded"));
            if (va.transferRemainingAppDatas()) {
                log.info((Object)"Remain appdatas were transferred.");
            } else {
                log.warn((Object)"No appdatas were transferred. This is wrong.");
            }
            va.putVamsasDocument(doc);
            va.closeArchive();
            sfile.unLock();
            log.info((Object)"Testing update: ");
            Lock lock2 = sfile.getLock();
            if (lock2 == null) {
                while ((lock2 = sfile.getLock()) == null) {
                    log.info((Object)"Waiting for lock.");
                }
            }
            if ((finaldoc = (sdoc = new SimpleDocument("testing vamsas update")).getVamsasDocument(vreader = new VamsasArchiveReader(newf))) != null) {
                ArchiveReports.reportDocument(finaldoc, vreader, true, System.out);
            } else {
                log.error((Object)("Null Document Read from " + newf));
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }
}

