/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.vamsas.client.simpleclient;

import java.util.Hashtable;
import java.util.zip.CRC32;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.ac.vamsas.client.ClientHandle;
import uk.ac.vamsas.client.SessionHandle;
import uk.ac.vamsas.client.UserHandle;
import uk.ac.vamsas.client.Vobject;
import uk.ac.vamsas.client.VorbaId;
import uk.ac.vamsas.client.VorbaIdFactory;
import uk.ac.vamsas.objects.utils.document.VersionEntries;

public class IdFactory
extends VorbaIdFactory {
    static Log log = LogFactory.getLog((Class)IdFactory.class);
    private SessionHandle session = null;
    private ClientHandle client;
    private UserHandle user;
    private CRC32 unique = new CRC32();
    private String idstring;
    int sequence = 1;

    public IdFactory() {
    }

    protected IdFactory(SessionHandle session, ClientHandle client, UserHandle user) {
        this.session = session;
        this.client = client;
        this.user = user;
        this.unique.reset();
        this.unique.update(new Object[]{session, client, user}.toString().getBytes());
        this.idstring = client.getClientNCname() + "_" + this.unique.getValue() + ".";
        this.extantids = new Hashtable();
        this.extanthashv = new Hashtable();
    }

    protected IdFactory(SessionHandle session, ClientHandle client, UserHandle user, Hashtable extanthashv) {
        this(session, client, user);
        this.extanthashv = extanthashv;
    }

    protected Hashtable getVorbaIdHash() {
        return this.extantids;
    }

    protected Hashtable getVobjhashVals() {
        return this.extanthashv;
    }

    public VorbaId makeVorbaId(Vobject vobject) {
        String newidstring;
        if (this.session == null) {
            throw new Error("makeVorbaId called on improperly initialised IdFactory Vobject!");
        }
        if (!vobject.isRegisterable()) {
            throw new Error("makeVorbaId called on unregisterable object.");
        }
        if (vobject.isRegistered()) {
            throw new Error("makeVorbaId called on already registered object.");
        }
        do {
            if (this.sequence > 0) {
                ++this.sequence;
                continue;
            }
            this.idstring = this.idstring + "1/";
            this.sequence = 1;
        } while (this.extantids.containsKey(newidstring = this.idstring + Integer.toString(this.sequence)));
        VorbaId id = this.newId(newidstring);
        this.extantids.put(id, vobject);
        return id;
    }

    protected void setSession(SessionHandle sessionhandle) {
        if (sessionhandle != null) {
            this.session = sessionhandle;
        } else {
            log.warn((Object)"setSession(null) called.");
        }
    }

    public SessionHandle getSessionHandle() {
        return this.session;
    }

    protected void setClient(ClientHandle appHandle) {
        if (appHandle != null) {
            this.client = appHandle;
        } else {
            log.warn((Object)"setClient(null) called.");
        }
    }

    public ClientHandle getClientHandle() {
        return this.client;
    }

    protected void setUser(UserHandle userHandle) {
        if (userHandle != null) {
            this.user = userHandle;
        } else {
            log.warn((Object)"setUser(null) called.");
        }
    }

    public UserHandle getUserHandle() {
        return this.user;
    }

    protected static IdFactory getDummyFactory(String clientname) {
        if (clientname == null) {
            clientname = "uk.ac.vamsas.client.simpleclient.IdFactory";
        }
        return new IdFactory(new SessionHandle("dummy.session"), new ClientHandle(clientname, VersionEntries.latestVersion()), new UserHandle(clientname, "Arnold User's Inc."));
    }
}

