/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.dundee.compbio.jpred;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Objects;
import java.util.regex.Pattern;
import uk.ac.dundee.compbio.jpred.Utils;

public class JPredRequest {
    private final Reader inputReader;
    private final Mode mode;
    private final Format format;
    private final boolean skipPDB;
    private final String email;
    private final String name;

    public static Builder newBuilder() {
        return new Builder();
    }

    protected JPredRequest(Builder builder) {
        this.inputReader = builder.inputReader;
        this.mode = builder.mode;
        this.format = builder.format;
        this.skipPDB = builder.skipPDB;
        this.email = builder.email;
        this.name = builder.name;
    }

    Reader getInputReader() {
        return this.inputReader;
    }

    Mode getMode() {
        return this.mode;
    }

    Format getFormat() {
        return this.format;
    }

    boolean getSkipPDB() {
        return this.skipPDB;
    }

    String getEmail() {
        return this.email;
    }

    String getName() {
        return this.name;
    }

    public static class Builder {
        Reader inputReader = null;
        Mode mode = null;
        Format format = Format.FASTA;
        boolean skipPDB = false;
        String email = null;
        String name = null;

        public Builder mode(Mode val) {
            Objects.requireNonNull(val);
            this.mode = val;
            return this;
        }

        public Builder format(Format val) {
            Objects.requireNonNull(val);
            this.format = val;
            return this;
        }

        public Builder email(String val) {
            if (val.isEmpty()) {
                throw Utils.newIAE("empty email");
            }
            this.email = val;
            return this;
        }

        public Builder input(CharSequence val) {
            Objects.requireNonNull(val);
            this.inputReader = new StringReader(val.toString());
            return this;
        }

        public Builder input(File val) throws FileNotFoundException {
            Objects.requireNonNull(val);
            this.inputReader = new FileReader(val);
            return this;
        }

        public Builder input(Reader val) {
            Objects.requireNonNull(val);
            this.inputReader = val;
            return this;
        }

        public Builder name(String val) {
            if (!Pattern.matches("^\\w+$", val)) {
                throw Utils.newIAE("invalid name");
            }
            this.name = val;
            return this;
        }

        public Builder skipPDB(boolean val) {
            this.skipPDB = val;
            return this;
        }

        public JPredRequest build() {
            if (this.inputReader == null) {
                throw Utils.newISE("input not set");
            }
            if (this.mode == null) {
                throw Utils.newISE("mode not set");
            }
            if (this.format == null) {
                throw Utils.newISE("format not set");
            }
            if (this.mode == Mode.BATCH) {
                throw new UnsupportedOperationException("batch mode not supported");
            }
            switch (this.mode) {
                case SINGLE: {
                    if (this.format == Format.MSF) {
                        throw Utils.newISE("msf format not allowed in single sequence mode");
                    }
                    if (this.format != Format.BLC) break;
                    throw Utils.newISE("blc format not allowed in single sequence mode");
                }
                case MSA: {
                    if (this.format != Format.SEQ) break;
                    throw Utils.newISE("seq format not allowed in msa mode");
                }
                case BATCH: {
                    if (this.format == Format.MSF) {
                        throw Utils.newISE("msf format not allowed in batch mode");
                    }
                    if (this.format == Format.BLC) {
                        throw Utils.newISE("blc format not allowed in batch mode");
                    }
                    if (this.format != Format.SEQ) break;
                    throw Utils.newISE("seq format not allowed in batch mode");
                }
            }
            if (this.mode == Mode.BATCH && this.email == null) {
                throw Utils.newISE("email is required in batch mode");
            }
            return new JPredRequest(this);
        }
    }

    public static enum Mode {
        MSA,
        SINGLE,
        BATCH;

    }

    public static enum Format {
        FASTA,
        MSF,
        BLC,
        SEQ;

    }
}

