/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws2.params;

import jalview.bin.Console;
import jalview.util.MessageManager;
import jalview.ws.params.ArgumentI;
import jalview.ws.params.ParamDatastoreI;
import jalview.ws.params.ParamManager;
import jalview.ws.params.WsParamSetI;
import jalview.ws2.params.ArgumentBeanList;
import jalview.ws2.params.SimpleParamSet;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class SimpleParamDatastore
implements ParamDatastoreI {
    protected URL serviceUrl;
    protected List<ArgumentI> parameters;
    protected List<SimpleParamSet> servicePresets;
    protected List<SimpleParamSet> userPresets = new ArrayList<SimpleParamSet>();
    protected ParamManager manager;

    public SimpleParamDatastore(URL serviceUrl, List<ArgumentI> parameters, List<? extends WsParamSetI> presets, ParamManager manager) {
        this.serviceUrl = serviceUrl;
        this.parameters = Collections.unmodifiableList(new ArrayList<ArgumentI>(parameters));
        this.servicePresets = new ArrayList<SimpleParamSet>(presets.size());
        for (WsParamSetI wsParamSetI : presets) {
            if (wsParamSetI instanceof SimpleParamSet) {
                this.servicePresets.add((SimpleParamSet)wsParamSetI);
                continue;
            }
            this.servicePresets.add(new SimpleParamSet(wsParamSetI));
        }
        this.servicePresets = Collections.unmodifiableList(this.servicePresets);
        this.manager = manager;
        if (manager != null) {
            this._initManager(manager);
        }
    }

    private void _initManager(ParamManager manager) {
        manager.registerParser(this.serviceUrl.toString(), this);
        WsParamSetI[] paramSets = manager.getParameterSet(null, this.serviceUrl.toString(), true, false);
        if (paramSets != null) {
            for (WsParamSetI paramSet : paramSets) {
                if (paramSet instanceof SimpleParamSet) {
                    this.userPresets.add((SimpleParamSet)paramSet);
                    continue;
                }
                this.userPresets.add(new SimpleParamSet(paramSet));
                Console.warn(String.format("Parameter set instance type %s is not applicable to serviceat %s.", paramSet.getClass(), this.serviceUrl));
            }
        }
    }

    @Override
    public List<WsParamSetI> getPresets() {
        ArrayList<WsParamSetI> presets = new ArrayList<WsParamSetI>();
        presets.addAll(this.servicePresets);
        presets.addAll(this.userPresets);
        return presets;
    }

    @Override
    public SimpleParamSet getPreset(String name) {
        SimpleParamSet preset = null;
        preset = this.getUserPreset(name);
        if (preset != null) {
            return preset;
        }
        preset = this.getServicePreset(name);
        if (preset != null) {
            return preset;
        }
        return null;
    }

    public SimpleParamSet getUserPreset(String name) {
        for (SimpleParamSet preset : this.userPresets) {
            if (!name.equals(preset.getName())) continue;
            return preset;
        }
        return null;
    }

    public SimpleParamSet getServicePreset(String name) {
        for (SimpleParamSet preset : this.servicePresets) {
            if (!name.equals(preset.getName())) continue;
            return preset;
        }
        return null;
    }

    @Override
    public List<ArgumentI> getServiceParameters() {
        return this.parameters;
    }

    @Override
    public boolean presetExists(String name) {
        return this.getPreset(name) != null;
    }

    @Override
    public void deletePreset(String name) {
        SimpleParamSet userPreset = this.getUserPreset(name);
        if (userPreset != null) {
            this.userPresets.remove(userPreset);
            if (this.manager != null) {
                this.manager.deleteParameterSet(userPreset);
            }
        } else {
            if (this.getServicePreset(name) != null) {
                throw new RuntimeException(MessageManager.getString("error.implementation_error_attempt_to_delete_service_preset"));
            }
            Console.warn("Implementation error: no preset to delete");
        }
    }

    @Override
    public void storePreset(String presetName, String text, List<ArgumentI> jobParams) {
        SimpleParamSet.Builder builder = SimpleParamSet.newBuilder();
        builder.name(presetName);
        builder.description(text);
        builder.arguments(jobParams);
        builder.url(this.serviceUrl.toString());
        builder.modifiable(true);
        SimpleParamSet preset = builder.build();
        this.userPresets.add(preset);
        if (this.manager != null) {
            this.manager.storeParameterSet(preset);
        }
    }

    @Override
    public void updatePreset(String oldName, String newName, String text, List<ArgumentI> jobParams) {
        SimpleParamSet preset = this.getPreset(oldName != null ? oldName : newName);
        if (preset == null) {
            throw new RuntimeException(MessageManager.formatMessage("error.implementation_error_cannot_locate_oldname_presetname", oldName, newName));
        }
        preset.setName(newName);
        preset.setDescription(text);
        preset.setArguments(jobParams);
        preset.setApplicableUrls(new String[]{this.serviceUrl.toString()});
        if (this.manager != null) {
            this.manager.storeParameterSet(preset);
        }
    }

    @Override
    public WsParamSetI parseServiceParameterFile(String name, String description, String[] serviceURL, String parameters) throws IOException {
        ArgumentBeanList argList;
        Unmarshaller unmarshaller;
        SimpleParamSet.Builder builder = SimpleParamSet.newBuilder();
        builder.name(name);
        builder.description(description);
        builder.urls(serviceURL);
        builder.modifiable(true);
        try {
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{ArgumentBeanList.class});
            unmarshaller = ctx.createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        try {
            argList = (ArgumentBeanList)unmarshaller.unmarshal((Reader)new StringReader(parameters));
        }
        catch (ClassCastException | JAXBException e) {
            throw new IOException("Unable to load parameters from file", e);
        }
        builder.arguments(argList.arguments);
        return builder.build();
    }

    @Override
    public String generateServiceParameterFile(WsParamSetI pset) throws IOException {
        Marshaller marshaller;
        try {
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{ArgumentBeanList.class});
            marshaller = ctx.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setProperty("jaxb.fragment", (Object)true);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        ArgumentBeanList argList = ArgumentBeanList.fromList(pset.getArguments());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            marshaller.marshal((Object)argList, (OutputStream)out);
        }
        catch (JAXBException e) {
            throw new IOException("Unable to generate parameters file", e);
        }
        return out.toString();
    }
}

