/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws2.gui;

import jalview.api.AlignCalcManagerI2;
import jalview.api.AlignCalcWorkerI;
import jalview.api.AlignViewportI;
import jalview.bin.Console;
import jalview.gui.AlignFrame;
import jalview.gui.Desktop;
import jalview.gui.JvSwingUtils;
import jalview.gui.WsJobParameters;
import jalview.util.MessageManager;
import jalview.viewmodel.AlignmentViewport;
import jalview.ws.params.ArgumentI;
import jalview.ws.params.ParamDatastoreI;
import jalview.ws.params.WsParamSetI;
import jalview.ws2.actions.BaseAction;
import jalview.ws2.actions.BaseTask;
import jalview.ws2.actions.PollingTaskExecutor;
import jalview.ws2.actions.alignment.AlignmentAction;
import jalview.ws2.actions.annotation.AlignCalcWorkerAdapter;
import jalview.ws2.actions.annotation.AnnotationAction;
import jalview.ws2.actions.api.ActionI;
import jalview.ws2.actions.api.TaskEventListener;
import jalview.ws2.actions.api.TaskI;
import jalview.ws2.actions.hmmer.PhmmerAction;
import jalview.ws2.actions.secstructpred.SecStructPredAction;
import jalview.ws2.api.Credentials;
import jalview.ws2.api.WebService;
import jalview.ws2.client.api.WebServiceProviderI;
import jalview.ws2.gui.AlignmentServiceGuiHandler;
import jalview.ws2.gui.AnnotationServiceGuiHandler;
import jalview.ws2.gui.SearchServiceGuiHandler;
import java.awt.Color;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;

public class WebServicesMenuManager {
    private final JMenu menu;
    private final AlignFrame frame;
    private JMenuItem inProgressItem = new JMenuItem("Service discovery in progress");
    private JMenuItem noServicesItem = new JMenuItem("No services available");

    public WebServicesMenuManager(String name, AlignFrame frame) {
        this.inProgressItem.setEnabled(false);
        this.inProgressItem.setVisible(false);
        this.noServicesItem.setEnabled(false);
        this.frame = frame;
        this.menu = new JMenu(name);
        this.menu.add(this.inProgressItem);
        this.menu.add(this.noServicesItem);
    }

    public JMenu getMenu() {
        return this.menu;
    }

    public void setNoServices(boolean noServices) {
        this.noServicesItem.setVisible(noServices);
    }

    public void setInProgress(boolean inProgress) {
        this.inProgressItem.setVisible(inProgress);
    }

    public void setServices(WebServiceProviderI services) {
        this.menu.removeAll();
        HashMap oneshotServices = new HashMap();
        HashMap<String, List> interactiveServices = new HashMap<String, List>();
        for (WebService<?> service : services.getServices()) {
            HashMap<String, List> map = service.isInteractive() ? interactiveServices : oneshotServices;
            map.computeIfAbsent(service.getCategory(), k -> new ArrayList()).add(service);
        }
        HashSet allKeysSet = new HashSet(oneshotServices.keySet());
        allKeysSet.addAll(interactiveServices.keySet());
        ArrayList allKeys = new ArrayList(allKeysSet);
        allKeys.sort(Comparator.naturalOrder());
        for (String category : allKeys) {
            List interactive;
            JMenu categoryMenu = new JMenu(category);
            List oneshot = (List)oneshotServices.get(category);
            if (oneshot != null) {
                this.addOneshotEntries(oneshot, categoryMenu);
            }
            if ((interactive = (List)interactiveServices.get(category)) != null) {
                if (oneshot != null) {
                    categoryMenu.addSeparator();
                }
                this.addInteractiveEntries(interactive, categoryMenu);
            }
            this.menu.add(categoryMenu);
        }
        this.menu.add(this.inProgressItem);
        this.menu.add(this.noServicesItem);
    }

    private void addOneshotEntries(List<WebService<?>> services, JMenu menu) {
        services.sort((ws1, ws2) -> {
            int res = ws1.getUrl().toString().compareTo(ws2.getUrl().toString());
            if (res == 0) {
                res = ws1.getName().compareTo(ws2.getName());
            }
            return res;
        });
        URL lastHost = null;
        for (WebService<?> service : services) {
            URL host = service.getUrl();
            if (!host.equals(lastHost)) {
                if (lastHost != null) {
                    menu.addSeparator();
                }
                JMenuItem item = new JMenuItem(host.toString());
                item.setForeground(Color.BLUE);
                item.addActionListener(e -> Desktop.showUrl(host.toString()));
                menu.add(item);
                lastHost = host;
            }
            menu.addSeparator();
            TreeMap<String, List> actionsByCategory = new TreeMap<String, List>();
            for (ActionI actionI : service.getActions()) {
                actionsByCategory.computeIfAbsent(actionI.getSubcategory() != null ? actionI.getSubcategory() : "", k -> new ArrayList()).add(actionI);
            }
            for (Map.Entry entry : actionsByCategory.entrySet()) {
                JMenu atMenu;
                String category = (String)entry.getKey();
                List actions = (List)entry.getValue();
                JMenu jMenu = atMenu = category.isEmpty() ? menu : new JMenu(String.format("%s with %s", category, service.getName()));
                if (atMenu != menu) {
                    menu.add(atMenu);
                }
                actions.sort(Comparator.comparing(ActionI::getName, Comparator.nullsFirst(Comparator.naturalOrder())));
                for (int i = 0; i < actions.size(); ++i) {
                    this.addEntriesForAction((ActionI)actions.get(i), atMenu, atMenu == menu);
                }
            }
        }
    }

    private void addEntriesForAction(ActionI<?> action, JMenu menu, boolean isTopLevel) {
        List<WsParamSetI> presets;
        Object itemName;
        boolean enabled = this.isActionEnabled(action);
        WebService<ActionI<?>> service = action.getWebService();
        if (isTopLevel) {
            itemName = service.getName();
            if (action.getName() != null && !action.getName().isEmpty()) {
                itemName = (String)itemName + " " + action.getName();
            }
        } else {
            itemName = action.getName() == null || action.getName().isEmpty() ? "Run" : action.getName();
        }
        ParamDatastoreI datastore = service.getParamDatastore();
        Object text = itemName;
        if (datastore.hasParameters() || datastore.hasPresets()) {
            text = (String)text + " with defaults";
        }
        JMenuItem item = new JMenuItem((String)text);
        item.setEnabled(enabled);
        item.addActionListener(e -> this.runAction(action, this.frame.getCurrentView(), Collections.emptyList(), Credentials.empty()));
        menu.add(item);
        if (datastore.hasParameters()) {
            JMenuItem item2 = new JMenuItem("Edit settings and run...");
            item2.setEnabled(enabled);
            item2.addActionListener(e -> WebServicesMenuManager.openEditParamsDialog(datastore, null, null).thenAccept(args -> {
                if (args != null) {
                    this.runAction(action, this.frame.getCurrentView(), (List<ArgumentI>)args, Credentials.empty());
                }
            }));
            menu.add(item2);
        }
        if ((presets = datastore.getPresets()) != null && presets.size() > 0) {
            JMenu presetsMenu = new JMenu(MessageManager.formatMessage("label.run_with_preset_params", service.getName()));
            presetsMenu.setEnabled(enabled);
            final int dismissDelay = ToolTipManager.sharedInstance().getDismissDelay();
            int QUICK_TOOLTIP = 1500;
            for (WsParamSetI preset : presets) {
                JMenuItem item3 = new JMenuItem(preset.getName());
                item3.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseEntered(MouseEvent evt) {
                        ToolTipManager.sharedInstance().setDismissDelay(1500);
                    }

                    @Override
                    public void mouseExited(MouseEvent evt) {
                        ToolTipManager.sharedInstance().setDismissDelay(dismissDelay);
                    }
                });
                String tooltipTitle = MessageManager.getString(preset.isModifiable() ? "label.user_preset" : "label.service_preset");
                String tooltip = String.format("<strong>%s</strong><br/>%s", tooltipTitle, preset.getDescription());
                tooltip = JvSwingUtils.wrapTooltip(true, tooltip);
                item3.setToolTipText(tooltip);
                item3.addActionListener(event -> this.runAction(action, this.frame.getCurrentView(), preset.getArguments(), Credentials.empty()));
                presetsMenu.add(item3);
            }
            menu.add(presetsMenu);
        }
    }

    private void addInteractiveEntries(List<WebService<?>> services, JMenu menu) {
        TreeMap<String, List> byServiceName = new TreeMap<String, List>(String.CASE_INSENSITIVE_ORDER);
        for (WebService<?> webService : services) {
            byServiceName.computeIfAbsent(webService.getName(), k -> new ArrayList()).add(webService);
        }
        for (Map.Entry entry : byServiceName.entrySet()) {
            InteractiveServiceEntryGroup group = new InteractiveServiceEntryGroup((String)entry.getKey(), (List)entry.getValue());
            group.appendTo(menu);
        }
    }

    private boolean isActionEnabled(ActionI<?> action) {
        if (this.frame == null || this.frame.getViewport() == null || this.frame.getViewport().getAlignment() == null) {
            return false;
        }
        boolean isNa = this.frame.getViewport().getAlignment().isNucleotide();
        return isNa && action.doAllowNucleotide() || !isNa && action.doAllowProtein();
    }

    private void runAction(ActionI<?> action, AlignmentViewport viewport, List<ArgumentI> args, Credentials credentials) {
        if (action instanceof AlignmentAction) {
            AlignmentAction _action = (AlignmentAction)action;
            AlignmentServiceGuiHandler handler = new AlignmentServiceGuiHandler(_action, this.frame);
            TaskI task = _action.createTask((AlignViewportI)viewport, (List)args, credentials);
            PollingTaskExecutor executor = PollingTaskExecutor.fromPool(viewport.getServiceExecutor());
            ((BaseTask)task).addTaskEventListener(handler);
            Future<?> future = executor.submit(task);
            ((BaseTask)task).setCancelAction(() -> future.cancel(true));
            return;
        }
        if (action instanceof AnnotationAction) {
            AlignCalcManagerI2 calcManager = viewport.getCalcManager();
            AnnotationAction _action = (AnnotationAction)action;
            AlignCalcWorkerAdapter worker = new AlignCalcWorkerAdapter(viewport, this.frame.alignPanel, _action, args, credentials);
            AnnotationServiceGuiHandler handler = new AnnotationServiceGuiHandler(_action, this.frame);
            worker.setWorkerListener(handler);
            for (AlignCalcWorkerI w : calcManager.getWorkers()) {
                if (worker.getCalcName() == null || !worker.getCalcName().equals(w.getCalcName())) continue;
                calcManager.cancelWorker(w);
                calcManager.removeWorker(w);
            }
            if (action.getWebService().isInteractive()) {
                calcManager.registerWorker(worker);
            } else {
                calcManager.startWorker(worker);
            }
            return;
        }
        if (action instanceof PhmmerAction || action instanceof SecStructPredAction) {
            BaseAction _action = (BaseAction)action;
            SearchServiceGuiHandler handler = new SearchServiceGuiHandler(_action, this.frame);
            BaseTask task = (BaseTask)_action.createTask(viewport, args, credentials);
            PollingTaskExecutor executor = PollingTaskExecutor.fromPool(viewport.getServiceExecutor());
            task.addTaskEventListener(handler);
            Future<?> future = executor.submit(task);
            task.setCancelAction(() -> future.cancel(true));
            return;
        }
        Console.warn(String.format("No known handler for action type %s. All output will be discarded.", action.getClass().getName()));
        TaskI<?> task = action.createTask(viewport, args, credentials);
        task.addTaskEventListener(TaskEventListener.nullListener());
        PollingTaskExecutor.fromPool(viewport.getServiceExecutor()).submit(task);
    }

    private static CompletionStage<List<ArgumentI>> openEditParamsDialog(ParamDatastoreI paramStore, WsParamSetI preset, List<ArgumentI> arguments) {
        WsJobParameters jobParams = preset == null && arguments != null && arguments.size() > 0 ? new WsJobParameters(paramStore, null, arguments) : new WsJobParameters(paramStore, preset, null);
        if (preset != null) {
            jobParams.setName(MessageManager.getString("label.adjusting_parameters_for_calculation"));
        }
        CompletionStage<Boolean> stage = jobParams.showRunDialog();
        return stage.thenApply(startJob -> {
            if (!startJob.booleanValue()) {
                return null;
            }
            if (jobParams.getPreset() != null) {
                return jobParams.getPreset().getArguments();
            }
            if (jobParams.isServiceDefaults()) {
                return Collections.emptyList();
            }
            return jobParams.getJobParams();
        });
    }

    private class InteractiveServiceEntryGroup {
        JLabel serviceLabel;
        JMenuItem urlItem = new JMenuItem();
        JCheckBoxMenuItem serviceItem = new JCheckBoxMenuItem();
        JMenuItem editParamsItem = new JMenuItem("Edit parameters...");
        JMenu presetsMenu = new JMenu("Change preset");
        JMenu alternativesMenu = new JMenu("Choose action");

        InteractiveServiceEntryGroup(String name, List<WebService<?>> services) {
            this.urlItem.setForeground(Color.BLUE);
            this.urlItem.setVisible(false);
            this.serviceItem.setVisible(false);
            this.editParamsItem.setVisible(false);
            this.presetsMenu.setVisible(false);
            this.serviceLabel = new JLabel(name);
            this.serviceLabel.setBorder(new EmptyBorder(0, 6, 0, 6));
            this.buildAlternativesMenu(services);
        }

        private void buildAlternativesMenu(List<WebService<?>> services) {
            JMenu menu = this.alternativesMenu;
            services.sort((ws1, ws2) -> {
                int res = ws1.getUrl().toString().compareTo(ws2.getUrl().toString());
                if (res == 0) {
                    res = ws1.getName().compareTo(ws2.getName());
                }
                return res;
            });
            URL lastHost = null;
            for (WebService<?> service : services) {
                URL host = service.getUrl();
                if (!host.equals(lastHost)) {
                    if (lastHost != null) {
                        menu.addSeparator();
                    }
                    JMenuItem item = new JMenuItem(host.toString());
                    item.setForeground(Color.BLUE);
                    item.addActionListener(e -> Desktop.showUrl(host.toString()));
                    menu.add(item);
                    lastHost = host;
                }
                menu.addSeparator();
                TreeMap<String, List> actionsByCategory = new TreeMap<String, List>();
                for (ActionI action : service.getActions()) {
                    actionsByCategory.computeIfAbsent(action.getSubcategory() != null ? action.getSubcategory() : "", k -> new ArrayList()).add(action);
                }
                actionsByCategory.forEach((key, actions) -> {
                    boolean topLevel;
                    JMenu atMenu = key.isEmpty() ? menu : new JMenu(key + " with " + service.getName());
                    boolean bl = topLevel = atMenu == menu;
                    if (!topLevel) {
                        menu.add(atMenu);
                    }
                    actions.sort(Comparator.comparing(a -> a.getName(), Comparator.nullsFirst(Comparator.naturalOrder())));
                    for (ActionI action : actions) {
                        JMenuItem item = new JMenuItem(action.getFullName());
                        item.setEnabled(WebServicesMenuManager.this.isActionEnabled(action));
                        item.addActionListener(e -> this.setAlternative(action));
                        atMenu.add(item);
                    }
                });
            }
        }

        private void setAlternative(ActionI<?> action) {
            ArrayList<ArgumentI> arguments = new ArrayList<ArgumentI>();
            WsParamSetI[] lastPreset = new WsParamSetI[]{null};
            String url = action.getWebService().getUrl().toString();
            this.urlItem.setText(url);
            this.urlItem.setVisible(true);
            for (ActionListener l : this.urlItem.getActionListeners()) {
                this.urlItem.removeActionListener(l);
            }
            this.urlItem.addActionListener(e -> Desktop.showUrl(url));
            this.serviceItem.setText(action.getFullName());
            this.serviceItem.setVisible(true);
            for (ActionListener l : this.serviceItem.getActionListeners()) {
                this.serviceItem.removeActionListener(l);
            }
            WebService<ActionI<?>> service = action.getWebService();
            this.serviceItem.addActionListener(e -> WebServicesMenuManager.this.runAction(action, WebServicesMenuManager.this.frame.getCurrentView(), arguments, Credentials.empty()));
            this.serviceItem.setSelected(true);
            ParamDatastoreI datastore = service.getParamDatastore();
            this.editParamsItem.setVisible(datastore.hasParameters());
            for (ActionListener l : this.editParamsItem.getActionListeners()) {
                this.editParamsItem.removeActionListener(l);
            }
            if (datastore.hasParameters()) {
                this.editParamsItem.addActionListener(e -> WebServicesMenuManager.openEditParamsDialog(service.getParamDatastore(), lastPreset[0], arguments).thenAccept(args -> {
                    if (args != null) {
                        lastPreset[0] = null;
                        arguments.clear();
                        arguments.addAll((Collection<ArgumentI>)args);
                        WebServicesMenuManager.this.runAction(action, WebServicesMenuManager.this.frame.getCurrentView(), arguments, Credentials.empty());
                    }
                }));
            }
            this.presetsMenu.removeAll();
            this.presetsMenu.setEnabled(datastore.hasPresets());
            if (datastore.hasPresets()) {
                for (WsParamSetI preset : datastore.getPresets()) {
                    JMenuItem item = new JMenuItem(preset.getName());
                    item.addActionListener(e -> {
                        lastPreset[0] = preset;
                        WebServicesMenuManager.this.runAction(action, WebServicesMenuManager.this.frame.getCurrentView(), preset.getArguments(), Credentials.empty());
                    });
                    this.presetsMenu.add(item);
                }
            }
            WebServicesMenuManager.this.runAction(action, WebServicesMenuManager.this.frame.getCurrentView(), arguments, Credentials.empty());
        }

        void appendTo(JMenu menu) {
            menu.add(this.serviceLabel);
            menu.add(this.urlItem);
            menu.add(this.serviceItem);
            menu.add(this.editParamsItem);
            menu.add(this.presetsMenu);
            menu.add(this.alternativesMenu);
        }
    }
}

