/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws2.client.slivka;

import jalview.bin.Console;
import jalview.ws.params.ParamManager;
import jalview.ws2.actions.BaseAction;
import jalview.ws2.actions.alignment.AlignmentAction;
import jalview.ws2.actions.annotation.AnnotationAction;
import jalview.ws2.api.WebService;
import jalview.ws2.client.api.AbstractWebServiceDiscoverer;
import jalview.ws2.client.slivka.SlivkaAlignmentWSClient;
import jalview.ws2.client.slivka.SlivkaAnnotationWSClient;
import jalview.ws2.client.slivka.SlivkaParamStoreFactory;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import uk.ac.dundee.compbio.slivkaclient.SlivkaClient;
import uk.ac.dundee.compbio.slivkaclient.SlivkaService;

public class SlivkaWSDiscoverer
extends AbstractWebServiceDiscoverer {
    private static final String SLIVKA_HOST_URLS = "SLIVKAHOSTURLS";
    private static final URL DEFAULT_URL;
    private static SlivkaWSDiscoverer instance;
    private static ParamManager paramManager;
    private final Function<URI, SlivkaClient> clientFactory;
    static final int SERVICE_CLASS_UNSUPPORTED = -1;
    static final int SERVICE_CLASS_MSA = 1;
    static final int SERVICE_CLASS_RNA_SEC_STR_PRED = 2;
    static final int SERVICE_CLASS_CONSERVATION = 3;
    static final int SERVICE_CLASS_PROT_SEQ_ANALYSIS = 4;
    static final int SERVICE_CLASS_PROT_SEC_STR_PRED = 5;

    SlivkaWSDiscoverer(Function<URI, SlivkaClient> clientFactory) {
        this.clientFactory = clientFactory;
    }

    public static SlivkaWSDiscoverer getInstance() {
        if (instance == null) {
            instance = new SlivkaWSDiscoverer(SlivkaClient::newInstance);
        }
        return instance;
    }

    public static void setParamManager(ParamManager manager) {
        paramManager = manager;
    }

    @Override
    public int getStatusForUrl(URL url) {
        try {
            List services = this.clientFactory.apply(url.toURI()).getServices();
            return services.isEmpty() ? 0 : 1;
        }
        catch (URISyntaxException e) {
            Console.error("invalid URL " + url, e);
            return -1;
        }
        catch (IOException e) {
            Console.error("slivka could not retrieve services from " + url, e);
            return -1;
        }
    }

    @Override
    protected String getUrlsPropertyKey() {
        return SLIVKA_HOST_URLS;
    }

    @Override
    protected URL getDefaultUrl() {
        return DEFAULT_URL;
    }

    @Override
    protected List<WebService<?>> fetchServices(URL url) throws IOException {
        SlivkaClient slivkaClient;
        ArrayList allServices = new ArrayList();
        try {
            slivkaClient = this.clientFactory.apply(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new MalformedURLException(e.getMessage());
        }
        for (SlivkaService slivkaService : slivkaClient.getServices()) {
            AnnotationAction.Builder actionBuilder;
            WebService.Builder<BaseAction> wsb;
            int serviceClass = SlivkaWSDiscoverer.getServiceClass(slivkaService);
            if (serviceClass == 1) {
                wsb = WebService.newBuilder();
                this.initServiceBuilder(slivkaClient, slivkaService, wsb);
                wsb.category("Alignment");
                wsb.interactive(false);
                wsb.actionClass(AlignmentAction.class);
                WebService<AlignmentAction> msaService = wsb.build();
                boolean canRealign = msaService.getName().contains("lustal");
                SlivkaAlignmentWSClient client = new SlivkaAlignmentWSClient(slivkaClient, slivkaService);
                AlignmentAction.Builder actionBuilder2 = AlignmentAction.newBuilder(client);
                actionBuilder2.name("Alignment");
                actionBuilder2.webService(msaService);
                if (canRealign) {
                    actionBuilder2.subcategory("Align");
                }
                actionBuilder2.minSequences(2);
                msaService.addAction(actionBuilder2.build());
                if (canRealign) {
                    actionBuilder2.name("Re-alignment");
                    actionBuilder2.subcategory("Realign");
                    actionBuilder2.submitGaps(true);
                    msaService.addAction(actionBuilder2.build());
                }
                allServices.add(msaService);
                continue;
            }
            if (serviceClass == 4) {
                wsb = WebService.newBuilder();
                this.initServiceBuilder(slivkaClient, slivkaService, wsb);
                wsb.category("Protein Disorder");
                wsb.interactive(false);
                wsb.actionClass(AnnotationAction.class);
                WebService<AnnotationAction> psaService = wsb.build();
                SlivkaAnnotationWSClient client = new SlivkaAnnotationWSClient(slivkaClient, slivkaService);
                actionBuilder = AnnotationAction.newBuilder(client);
                actionBuilder.webService(psaService);
                actionBuilder.name("Analysis");
                psaService.addAction(actionBuilder.build());
                allServices.add(psaService);
                continue;
            }
            if (serviceClass == 3) {
                wsb = WebService.newBuilder();
                this.initServiceBuilder(slivkaClient, slivkaService, wsb);
                wsb.category("Conservation");
                wsb.interactive(true);
                wsb.actionClass(AnnotationAction.class);
                WebService<AnnotationAction> conService = wsb.build();
                SlivkaAnnotationWSClient client = new SlivkaAnnotationWSClient(slivkaClient, slivkaService);
                actionBuilder = AnnotationAction.newBuilder(client);
                actionBuilder.webService(conService);
                actionBuilder.name("");
                actionBuilder.alignmentAnalysis(true);
                actionBuilder.requireAlignedSequences(true);
                actionBuilder.filterSymbols(true);
                conService.addAction(actionBuilder.build());
                allServices.add(conService);
                continue;
            }
            if (serviceClass != 2) continue;
            wsb = WebService.newBuilder();
            this.initServiceBuilder(slivkaClient, slivkaService, wsb);
            wsb.category("Secondary Structure Prediction");
            wsb.interactive(true);
            wsb.actionClass(AnnotationAction.class);
            WebService<AnnotationAction> predService = wsb.build();
            SlivkaAnnotationWSClient client = new SlivkaAnnotationWSClient(slivkaClient, slivkaService);
            actionBuilder = AnnotationAction.newBuilder(client);
            actionBuilder.webService(predService);
            actionBuilder.name("Prediction");
            actionBuilder.minSequences(2);
            actionBuilder.allowNucleotide(true);
            actionBuilder.allowProtein(false);
            actionBuilder.alignmentAnalysis(true);
            actionBuilder.requireAlignedSequences(true);
            actionBuilder.filterSymbols(false);
            predService.addAction(actionBuilder.build());
            allServices.add(predService);
        }
        return allServices;
    }

    private void initServiceBuilder(SlivkaClient client, SlivkaService service, WebService.Builder<?> wsBuilder) {
        try {
            wsBuilder.url(client.getUrl().toURL());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        wsBuilder.clientName("slivka");
        wsBuilder.name(service.getName());
        wsBuilder.description(service.getDescription());
        SlivkaParamStoreFactory storeBuilder = new SlivkaParamStoreFactory(service, paramManager);
        wsBuilder.paramDatastore(storeBuilder.createParamDatastore());
    }

    private static int getServiceClass(SlivkaService service) {
        for (String classifier : service.getClassifiers()) {
            String tail;
            String[] path = classifier.split("\\s*::\\s*");
            if (path.length < 3 || !path[0].equalsIgnoreCase("operation")) continue;
            switch (tail = path[path.length - 1].toLowerCase()) {
                case "multiple sequence alignment": {
                    return 1;
                }
                case "rna secondary structure prediction": {
                    return 2;
                }
                case "sequence alignment analysis (conservation)": {
                    return 3;
                }
                case "protein sequence analysis": {
                    return 4;
                }
                case "protein secondary structure prediction": {
                    return 5;
                }
            }
        }
        return -1;
    }

    static {
        try {
            DEFAULT_URL = new URL("https://www.compbio.dundee.ac.uk/slivka/");
        }
        catch (MalformedURLException e) {
            throw new AssertionError((Object)e);
        }
        instance = null;
        paramManager = null;
    }
}

