/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws2.api;

import jalview.ws.params.ParamDatastoreI;
import jalview.ws2.actions.api.ActionI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class WebService<A extends ActionI<?>> {
    private final URL url;
    private final String clientName;
    private final String category;
    private final String name;
    private final String description;
    private final boolean interactive;
    private final ParamDatastoreI paramDatastore;
    private final List<A> actions;
    private final Class<A> actionClass;

    protected WebService(Builder<A> builder) {
        Objects.requireNonNull(builder.url);
        Objects.requireNonNull(builder.clientName);
        Objects.requireNonNull(builder.category);
        Objects.requireNonNull(builder.name);
        Objects.requireNonNull(builder.paramDatastore);
        Objects.requireNonNull(builder.actionClass);
        this.url = builder.url;
        this.clientName = builder.clientName;
        this.category = builder.category;
        this.name = builder.name;
        this.description = builder.description;
        this.interactive = builder.interactive;
        this.paramDatastore = builder.paramDatastore;
        this.actions = new ArrayList<A>();
        this.actionClass = builder.actionClass;
    }

    public static <A extends ActionI<?>> Builder<A> newBuilder() {
        return new Builder();
    }

    public void addAction(A action) {
        this.actions.add(action);
    }

    public void addActions(Collection<? extends A> actions) {
        this.actions.addAll(actions);
    }

    public URL getUrl() {
        return this.url;
    }

    public String getClientName() {
        return this.clientName;
    }

    public String getCategory() {
        return this.category;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public ParamDatastoreI getParamDatastore() {
        return this.paramDatastore;
    }

    public List<A> getActions() {
        return this.actions;
    }

    public Class<A> getActionClass() {
        return this.actionClass;
    }

    public static class Builder<A extends ActionI<?>> {
        private URL url;
        private String clientName;
        private String category;
        private String name;
        private String description = "";
        private boolean interactive = false;
        private ParamDatastoreI paramDatastore;
        private Class<A> actionClass;

        public Builder<A> url(URL val) {
            this.url = val;
            return this;
        }

        public Builder<A> clientName(String val) {
            this.clientName = val;
            return this;
        }

        public Builder<A> category(String val) {
            this.category = val;
            return this;
        }

        public Builder<A> name(String val) {
            this.name = val;
            return this;
        }

        public Builder<A> description(String val) {
            this.description = val;
            return this;
        }

        public Builder<A> interactive(boolean val) {
            this.interactive = val;
            return this;
        }

        public Builder<A> paramDatastore(ParamDatastoreI val) {
            this.paramDatastore = val;
            return this;
        }

        public Builder<A> actionClass(Class<A> val) {
            this.actionClass = val;
            return this;
        }

        public WebService<A> build() {
            return new WebService(this);
        }
    }
}

