/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.slivkaws;

import jalview.datamodel.AlignmentI;
import jalview.datamodel.SequenceI;
import jalview.gui.WebserviceInfo;
import jalview.io.DataSourceType;
import jalview.io.FileFormat;
import jalview.io.FileFormatI;
import jalview.io.FormatAdapter;
import jalview.ws.api.JalviewServiceEndpointProviderI;
import jalview.ws.api.JalviewWebServiceI;
import jalview.ws.api.JobId;
import jalview.ws.api.ServiceWithParameters;
import jalview.ws.gui.WsJob;
import jalview.ws.params.ArgumentI;
import jalview.ws.params.ParamDatastoreI;
import jalview.ws.params.ParamManager;
import jalview.ws.params.WsParamSetI;
import jalview.ws.slivkaws.SlivkaDatastore;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javajs.http.ClientProtocolException;
import uk.ac.dundee.compbio.slivkaclient.Job;
import uk.ac.dundee.compbio.slivkaclient.Parameter;
import uk.ac.dundee.compbio.slivkaclient.RemoteFile;
import uk.ac.dundee.compbio.slivkaclient.RequestValues;
import uk.ac.dundee.compbio.slivkaclient.SlivkaClient;
import uk.ac.dundee.compbio.slivkaclient.SlivkaService;

public abstract class SlivkaWSInstance
extends ServiceWithParameters
implements JalviewServiceEndpointProviderI,
JalviewWebServiceI {
    protected final SlivkaClient client;
    protected final SlivkaService service;
    protected SlivkaDatastore store = null;
    protected static final EnumMap<Job.Status, WsJob.JobState> stateMap = new EnumMap(Job.Status.class);
    protected final Set<WsJob.JobState> failedStates;

    public SlivkaWSInstance(SlivkaClient client, SlivkaService service, String action) {
        super(action, action, service.getName(), "Slivka", client.getUrl().toString());
        stateMap.put(Job.Status.PENDING, WsJob.JobState.QUEUED);
        stateMap.put(Job.Status.REJECTED, WsJob.JobState.INVALID);
        stateMap.put(Job.Status.ACCEPTED, WsJob.JobState.QUEUED);
        stateMap.put(Job.Status.QUEUED, WsJob.JobState.QUEUED);
        stateMap.put(Job.Status.RUNNING, WsJob.JobState.RUNNING);
        stateMap.put(Job.Status.COMPLETED, WsJob.JobState.FINISHED);
        stateMap.put(Job.Status.INTERRUPTED, WsJob.JobState.CANCELLED);
        stateMap.put(Job.Status.DELETED, WsJob.JobState.CANCELLED);
        stateMap.put(Job.Status.FAILED, WsJob.JobState.FAILED);
        stateMap.put(Job.Status.ERROR, WsJob.JobState.SERVERERROR);
        stateMap.put(Job.Status.UNKNOWN, WsJob.JobState.UNKNOWN);
        this.failedStates = new HashSet<WsJob.JobState>(Arrays.asList(WsJob.JobState.INVALID, WsJob.JobState.BROKEN, WsJob.JobState.FAILED, WsJob.JobState.SERVERERROR, WsJob.JobState.CANCELLED));
        this.client = client;
        this.service = service;
    }

    protected final JobId submit(List<SequenceI> sequences, WsParamSetI preset, List<ArgumentI> args) throws Throwable {
        List parameters = this.service.getParameters();
        RequestValues request = new RequestValues();
        for (Parameter param : parameters) {
            FileFormat format;
            if (!(param instanceof Parameter.FileParameter)) continue;
            FormatAdapter fa = new FormatAdapter();
            fa.setNewlineString("\r\n");
            Parameter.FileParameter fileParam = (Parameter.FileParameter)param;
            switch (fileParam.getMediaType()) {
                case "application/pfam": {
                    format = FileFormat.Pfam;
                    break;
                }
                case "application/stockholm": {
                    format = FileFormat.Stockholm;
                    break;
                }
                default: {
                    format = FileFormat.Fasta;
                }
            }
            ByteArrayInputStream stream = new ByteArrayInputStream(format.getWriter(null).print(sequences.toArray(new SequenceI[0]), false).getBytes());
            request.addFile(param.getId(), (InputStream)stream);
        }
        if (args != null) {
            for (ArgumentI arg : args) {
                String paramId = arg.getName().split("\\$", 2)[0];
                Parameter param = this.service.getParameter(paramId);
                if (param instanceof Parameter.FlagParameter) {
                    if (arg.getValue() != null && !arg.getValue().isBlank()) {
                        request.addData(paramId, (Object)true);
                        continue;
                    }
                    request.addData(paramId, (Object)false);
                    continue;
                }
                request.addData(paramId, (Object)arg.getValue());
            }
        }
        String jobId = this.client.submitJob(this.service, request);
        return new JobId(this.service.getName(), this.service.getName(), jobId);
    }

    @Override
    public final void updateStatus(WsJob job) {
        try {
            job.setState(stateMap.get(this.client.fetchJobStatus(job.getJobId())));
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public final boolean updateJobProgress(WsJob job) throws IOException {
        Collection files = this.client.fetchFilesList(job.getJobId());
        RemoteFile logFile = null;
        for (RemoteFile f : files) {
            if (!f.getLabel().equals("log")) continue;
            logFile = f;
            break;
        }
        boolean newContent = false;
        if (logFile != null) {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            this.client.writeFileTo(logFile, (OutputStream)output);
            if ((long)output.size() > job.getNextChunk()) {
                newContent = true;
                job.setStatus(output.toString("UTF-8"));
                job.setnextChunk(output.size());
            }
        }
        if (this.failedStates.contains((Object)job.getJobState())) {
            RemoteFile errLogFile = null;
            for (RemoteFile f : files) {
                if (!f.getLabel().equals("error-log")) continue;
                errLogFile = f;
                break;
            }
            if (errLogFile != null) {
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                this.client.writeFileTo(errLogFile, (OutputStream)output);
                if (output.size() > 0) {
                    newContent = true;
                    job.setStatus(job.getStatus() + "\n" + output.toString("UTF-8"));
                }
            }
        }
        return newContent;
    }

    @Override
    public final boolean handleSubmitError(Throwable _lex, WsJob j, WebserviceInfo wsInfo) {
        if (_lex instanceof ClientProtocolException) {
            j.setState(WsJob.JobState.INVALID);
            j.setStatus(_lex.getMessage());
            return true;
        }
        return false;
    }

    @Override
    public final boolean handleCollectionException(Exception e, WsJob msjob, WebserviceInfo wsInfo) {
        return false;
    }

    final SlivkaService getService() {
        return this.service;
    }

    @Override
    public final Object getEndpoint() {
        return this;
    }

    @Override
    public final void initParamStore(ParamManager userParameterStore) {
        if (this.store == null) {
            this.store = new SlivkaDatastore(this.service);
        }
    }

    @Override
    public boolean hasParameters() {
        return true;
    }

    @Override
    public final ParamDatastoreI getParamStore() {
        if (this.store == null) {
            this.initParamStore(null);
        }
        return this.store;
    }

    public static AlignmentI readAlignment(RemoteFile f) throws IOException {
        FileFormat format;
        String mimetype = f.getMediaType();
        if (mimetype.equals("application/clustal")) {
            format = FileFormat.Clustal;
        } else if (mimetype.equals("application/fasta")) {
            format = FileFormat.Fasta;
        } else {
            return null;
        }
        return new FormatAdapter().readFile(f.getContentUrl().toString(), DataSourceType.URL, (FileFormatI)format);
    }
}

