/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.rest.params;

import jalview.datamodel.AlignmentI;
import jalview.ws.params.OptionI;
import jalview.ws.params.simple.Option;
import jalview.ws.rest.InputType;
import jalview.ws.rest.NoValidInputDataException;
import jalview.ws.rest.RestJob;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;

public class AnnotationFile
extends InputType {
    final String JVANNOT = "JalviewAnnotation";
    final String CSVANNOT = "CsvAnnotationRow";
    String format = "JalviewAnnotation";

    public AnnotationFile() {
        super(new Class[]{AlignmentI.class});
    }

    @Override
    public ContentBody formatForInput(RestJob rj) throws UnsupportedEncodingException, NoValidInputDataException {
        AlignmentI al = rj.getAlignmentForInput(this.token, InputType.molType.MIX);
        if (this.format.equals("JalviewAnnotation")) {
            return new StringBody(new jalview.io.AnnotationFile().printAnnotationsForAlignment(al));
        }
        if (!this.format.equals("CsvAnnotationRow")) {
            throw new UnsupportedEncodingException("Unrecognised format for exporting Annotation (" + this.format + ")");
        }
        return new StringBody(new jalview.io.AnnotationFile().printCSVAnnotations(al.getAlignmentAnnotation()));
    }

    @Override
    public List<String> getURLEncodedParameter() {
        ArrayList<String> prms = new ArrayList<String>();
        super.addBaseParams(prms);
        prms.add("format='" + this.format + "'");
        return prms;
    }

    @Override
    public String getURLtokenPrefix() {
        return "ALANNOTATION";
    }

    @Override
    public boolean configureProperty(String tok, String val, StringBuffer warnings) {
        if (tok.startsWith("format")) {
            for (String fmt : new String[]{"CsvAnnotationRow", "JalviewAnnotation"}) {
                if (!val.equalsIgnoreCase(fmt)) continue;
                this.format = fmt;
                return true;
            }
            warnings.append("Invalid annotation file format '" + val + "'. Must be one of (");
            for (String fmt : new String[]{"CsvAnnotationRow", "JalviewAnnotation"}) {
                warnings.append(" " + fmt);
            }
            warnings.append(")\n");
        }
        return false;
    }

    @Override
    public List<OptionI> getOptions() {
        List<OptionI> lst = this.getBaseOptions();
        lst.add(new Option("format", "Alignment annotation upload format", true, "JalviewAnnotation", this.format, Arrays.asList("JalviewAnnotation", "CsvAnnotationRow"), null));
        return lst;
    }
}

