/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.params.simple;

import jalview.ws.params.ParameterI;
import jalview.ws.params.ValueConstrainI;
import jalview.ws.params.simple.Option;

public class LogarithmicParameter
extends Option
implements ParameterI {
    final double defval;
    final double min;
    final double max;

    @Override
    public ValueConstrainI getValidValue() {
        return new ValueConstrainI(){

            @Override
            public ValueConstrainI.ValueType getType() {
                return ValueConstrainI.ValueType.Double;
            }

            @Override
            public Number getMin() {
                return LogarithmicParameter.this.min < LogarithmicParameter.this.max ? Double.valueOf(LogarithmicParameter.this.min) : null;
            }

            @Override
            public Number getMax() {
                return LogarithmicParameter.this.min < LogarithmicParameter.this.max ? Double.valueOf(LogarithmicParameter.this.max) : null;
            }
        };
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public LogarithmicParameter(Builder builder) {
        super(builder);
        this.min = builder.min;
        this.max = builder.max;
        this.defval = this.defvalue != null ? Double.parseDouble(this.defvalue) : 0.0;
    }

    public LogarithmicParameter(LogarithmicParameter parm) {
        super(parm);
        this.max = parm.max;
        this.min = parm.min;
        this.defval = 0.0;
    }

    public LogarithmicParameter(String name, String description, boolean required, Double defValue, double min, double max) {
        super(name, description, required, String.valueOf(defValue), null, null, null);
        this.defval = defValue;
        this.min = min;
        this.max = max;
    }

    public LogarithmicParameter(String name, String description, boolean required, Double defValue, double value, double min, double max) {
        super(name, description, required, String.valueOf(defValue), String.valueOf(value), null, null);
        this.defval = defValue;
        this.min = min;
        this.max = max;
    }

    @Override
    public LogarithmicParameter copy() {
        return new LogarithmicParameter(this);
    }

    public static class Builder
    extends Option.Builder {
        protected double min = Double.POSITIVE_INFINITY;
        protected double max = Double.NEGATIVE_INFINITY;

        @Override
        public void setValue(String value) {
            throw new UnsupportedOperationException();
        }

        public void setValue(Double value) {
            if (value != null) {
                super.setValue(value.toString());
            } else {
                super.setValue(null);
            }
        }

        @Override
        public void setDefaultValue(String defaultValue) {
            throw new UnsupportedOperationException();
        }

        public void setDefaultValue(Double defaultValue) {
            if (defaultValue != null) {
                super.setDefaultValue(defaultValue.toString());
            } else {
                super.setDefaultValue(null);
            }
        }

        public void setMin(Double min) {
            this.min = min != null ? min : Double.POSITIVE_INFINITY;
        }

        public void setMax(Double max) {
            this.max = max != null ? max : Double.NEGATIVE_INFINITY;
        }

        public void setBounds(Double min, Double max) {
            this.setMin(min);
            this.setMax(max);
        }

        @Override
        public LogarithmicParameter build() {
            return new LogarithmicParameter(this);
        }
    }
}

