/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.jws2.jabaws2;

import compbio.data.msa.JABAService;
import compbio.ws.client.Services;
import jalview.bin.ApplicationSingletonProvider;
import jalview.ws.jws2.jabaws2.AAConClient;
import jalview.ws.jws2.jabaws2.Jws2Instance;
import jalview.ws.jws2.jabaws2.RNAalifoldClient;
import jalview.ws.uimodel.AlignAnalysisUIText;
import java.util.HashMap;
import java.util.HashSet;

public class Jws2InstanceFactory
implements ApplicationSingletonProvider.ApplicationSingletonI {
    private HashMap<String, AlignAnalysisUIText> aaConGUI;
    private HashSet<String> ignoreGUI;

    private Jws2InstanceFactory() {
    }

    private static Jws2InstanceFactory getInstance() {
        return ApplicationSingletonProvider.getInstance(Jws2InstanceFactory.class);
    }

    private static String category_rewrite(String cat_name) {
        return cat_name != null && cat_name.equals("Prediction") ? "Secondary Structure Prediction" : cat_name;
    }

    private void init() {
        if (this.aaConGUI == null) {
            this.aaConGUI = new HashMap();
            this.aaConGUI.put(Services.AAConWS.toString(), AAConClient.getAlignAnalysisUIText());
            this.aaConGUI.put(Services.RNAalifoldWS.toString(), RNAalifoldClient.getAlignAnalysisUIText());
            this.ignoreGUI = new HashSet();
        }
    }

    public static boolean ignoreService(String serviceType) {
        Jws2InstanceFactory.getInstance().init();
        return Jws2InstanceFactory.getInstance().ignoreGUI.contains(serviceType.toString());
    }

    public static Jws2Instance newJws2Instance(String jwsservers, String serviceType, String name, String description, JABAService service) {
        Jws2InstanceFactory.getInstance().init();
        Jws2Instance svc = new Jws2Instance(jwsservers, serviceType, Jws2InstanceFactory.category_rewrite(name), description, service);
        svc.setAlignAnalysisUI(Jws2InstanceFactory.getInstance().aaConGUI.get(serviceType.toString()));
        return svc;
    }
}

