/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.jws2;

import jalview.analysis.AlignSeq;
import jalview.analysis.AlignmentAnnotationUtils;
import jalview.analysis.SeqsetUtils;
import jalview.api.FeatureColourI;
import jalview.api.PollableAlignCalcWorkerI;
import jalview.bin.Console;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.AnnotatedCollectionI;
import jalview.datamodel.Annotation;
import jalview.datamodel.ContiguousI;
import jalview.datamodel.Mapping;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceI;
import jalview.datamodel.features.FeatureMatcherSetI;
import jalview.gui.AlignFrame;
import jalview.gui.AlignViewport;
import jalview.gui.AlignmentPanel;
import jalview.gui.Desktop;
import jalview.gui.IProgressIndicator;
import jalview.gui.IProgressIndicatorHandler;
import jalview.gui.JvOptionPane;
import jalview.gui.WebserviceInfo;
import jalview.schemes.FeatureSettingsAdapter;
import jalview.schemes.ResidueProperties;
import jalview.util.Comparison;
import jalview.util.MapList;
import jalview.util.MessageManager;
import jalview.workers.AlignCalcWorker;
import jalview.ws.JobStateSummary;
import jalview.ws.api.CancellableI;
import jalview.ws.api.JalviewServiceEndpointProviderI;
import jalview.ws.api.JobId;
import jalview.ws.api.SequenceAnnotationServiceI;
import jalview.ws.api.ServiceWithParameters;
import jalview.ws.api.WSAnnotationCalcManagerI;
import jalview.ws.gui.AnnotationWsJob;
import jalview.ws.jws2.dm.AAConSettings;
import jalview.ws.params.ArgumentI;
import jalview.ws.params.WsParamSetI;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SeqAnnotationServiceCalcWorker
extends AlignCalcWorker
implements WSAnnotationCalcManagerI,
PollableAlignCalcWorkerI {
    protected ServiceWithParameters service;
    protected WsParamSetI preset;
    protected List<ArgumentI> arguments;
    protected IProgressIndicator guiProgress;
    protected boolean submitGaps = true;
    protected boolean filterNonStandardResidues = true;
    protected boolean alignedSeqs = true;
    protected boolean nucleotidesAllowed = false;
    protected boolean proteinAllowed = false;
    protected boolean bySequence = false;
    protected Map<String, SequenceI> seqNames;
    protected boolean[] gapMap;
    int realw;
    protected int start;
    int end;
    private AlignFrame alignFrame;
    protected SequenceAnnotationServiceI annotService;
    protected final boolean cancellable;
    volatile JobId rslt = null;
    AnnotationWsJob running = null;
    private int min_valid_seqs;
    private long progressId = -1L;
    JobStateSummary job = null;
    WebserviceInfo info = null;
    List<SequenceI> seqs = null;

    protected void initViewportParams() {
        if (this.getCalcId() != null) {
            ((AlignViewport)this.alignViewport).setCalcIdSettingsFor(this.getCalcId(), new AAConSettings(true, this.service, this.preset, this.arguments), true);
        }
    }

    public String getCalcId() {
        return this.service.getAlignAnalysisUI() == null ? null : this.service.getAlignAnalysisUI().getCalcId();
    }

    public WsParamSetI getPreset() {
        return this.preset;
    }

    public List<ArgumentI> getArguments() {
        return this.arguments;
    }

    public void updateParameters(WsParamSetI newpreset, List<ArgumentI> newarguments) {
        this.preset = newpreset;
        this.arguments = newarguments;
        this.calcMan.startWorker(this);
        this.initViewportParams();
    }

    public boolean[] getGapMap() {
        return this.gapMap;
    }

    public SeqAnnotationServiceCalcWorker(ServiceWithParameters service, AlignFrame alignFrame, WsParamSetI preset, List<ArgumentI> paramset) {
        super(alignFrame.getCurrentView(), alignFrame.alignPanel);
        this.alignFrame = alignFrame;
        this.guiProgress = alignFrame;
        this.preset = preset;
        this.arguments = paramset;
        this.service = service;
        try {
            this.annotService = (SequenceAnnotationServiceI)((JalviewServiceEndpointProviderI)((Object)service)).getEndpoint();
        }
        catch (ClassCastException cce) {
            this.annotService = null;
            JvOptionPane.showMessageDialog((Component)Desktop.getInstance(), MessageManager.formatMessage("label.service_called_is_not_an_annotation_service", new String[]{service.getName()}), MessageManager.getString("label.internal_jalview_error"), 2);
        }
        this.cancellable = CancellableI.class.isInstance(this.annotService);
        this.proteinAllowed = service.isProteinService();
        this.nucleotidesAllowed = service.isNucleotideService();
        this.alignedSeqs = service.isNeedsAlignedSequences();
        this.bySequence = !service.isAlignmentAnalysis();
        this.filterNonStandardResidues = service.isFilterSymbols();
        this.min_valid_seqs = service.getMinimumInputSequences();
        this.submitGaps = service.isAlignmentAnalysis();
        if (service.isInteractiveUpdate()) {
            this.initViewportParams();
        }
    }

    public boolean hasService() {
        return this.annotService != null;
    }

    @Override
    public void startUp() throws Throwable {
        if (this.alignViewport.isClosed()) {
            this.abortAndDestroy();
            return;
        }
        if (!this.hasService()) {
            return;
        }
        StringBuffer msg = new StringBuffer();
        this.job = new JobStateSummary();
        this.info = new WebserviceInfo("foo", "bar", false);
        this.seqs = this.getInputSequences(this.alignViewport.getAlignment(), this.bySequence ? this.alignViewport.getSelectionGroup() : null);
        if (this.seqs == null || !this.checkValidInputSeqs(this.seqs)) {
            Console.debug("Sequences for analysis service were null or not valid");
            return;
        }
        if (this.guiProgress != null) {
            this.progressId = System.currentTimeMillis();
            this.guiProgress.setProgressBar(this.service.getActionText(), this.progressId);
        }
        Console.debug("submitted " + this.seqs.size() + " sequences to " + this.service.getActionText());
        this.rslt = this.annotService.submitToService(this.seqs, this.getPreset(), this.getArguments());
        if (this.rslt == null) {
            return;
        }
        Console.debug("Service " + this.service.getUri() + "\nSubmitted job ID: " + this.rslt);
        this.running = new AnnotationWsJob();
        this.running.setJobHandle(this.rslt);
        this.running.setSeqNames(this.seqNames);
        this.running.setStartPos(this.start);
        this.running.setSeqs(this.seqs);
        this.job.updateJobPanelState(this.info, "", this.running);
        if (this.guiProgress != null) {
            this.guiProgress.registerHandler(this.progressId, new IProgressIndicatorHandler(){

                @Override
                public boolean cancelActivity(long id) {
                    SeqAnnotationServiceCalcWorker.this.calcMan.cancelWorker(SeqAnnotationServiceCalcWorker.this);
                    return true;
                }

                @Override
                public boolean canCancel() {
                    return SeqAnnotationServiceCalcWorker.this.cancellable;
                }
            });
        }
    }

    @Override
    public boolean poll() throws Throwable {
        boolean finished = false;
        Console.debug("Updating status for annotation service.");
        this.annotService.updateStatus(this.running);
        this.job.updateJobPanelState(this.info, "", this.running);
        if (this.running.isSubjobComplete()) {
            Console.debug("Finished polling analysis service job: status reported is " + this.running.getState());
            finished = true;
        } else {
            Console.debug("Status now " + this.running.getState());
        }
        Console.debug("Updating progress log for annotation service.");
        try {
            this.annotService.updateJobProgress(this.running);
        }
        catch (Throwable thr) {
            Console.debug("Ignoring exception during progress update.", thr);
        }
        Console.debug("Result of poll: " + this.running.getStatus());
        if (finished) {
            Console.debug("Job poll loop exited. Job is " + this.running.getState());
            if (this.running.isFinished()) {
                this.running.setFeatureRenderer(((AlignmentPanel)this.ap).cloneFeatureRenderer());
                Console.debug("retrieving job results.");
                final HashMap<String, FeatureColourI> featureColours = new HashMap<String, FeatureColourI>();
                final HashMap<String, FeatureMatcherSetI> featureFilters = new HashMap<String, FeatureMatcherSetI>();
                List<AlignmentAnnotation> returnedAnnot = this.annotService.getAnnotationResult(this.running.getJobHandle(), this.seqs, featureColours, featureFilters);
                Console.debug("Obtained " + (String)(returnedAnnot == null ? "no rows" : "" + returnedAnnot.size()));
                Console.debug("There were " + featureColours.size() + " feature colours and " + featureFilters.size() + " filters defined.");
                if (returnedAnnot != null) {
                    for (AlignmentAnnotation aa : returnedAnnot) {
                        if (this.getCalcId() != null && aa.getCalcId() == null || "".equals(aa.getCalcId())) {
                            aa.setCalcId(this.getCalcId());
                        }
                        aa.autoCalculated = this.service.isAlignmentAnalysis() && this.service.isInteractiveUpdate();
                    }
                }
                this.running.setAnnotation(returnedAnnot);
                if (this.running.hasResults()) {
                    Console.debug("Updating result annotation from Job " + this.rslt + " at " + this.service.getUri());
                    this.updateResultAnnotation(true);
                    if (this.running.isTransferSequenceFeatures()) {
                        Console.debug("Updating feature display settings and transferring features from Job " + this.rslt + " at " + this.service.getUri());
                        this.alignViewport.applyFeaturesStyle(new FeatureSettingsAdapter(){

                            @Override
                            public FeatureColourI getFeatureColour(String type) {
                                return (FeatureColourI)featureColours.get(type);
                            }

                            @Override
                            public FeatureMatcherSetI getFeatureFilters(String type) {
                                return (FeatureMatcherSetI)featureFilters.get(type);
                            }

                            @Override
                            public boolean isFeatureDisplayed(String type) {
                                return featureColours.containsKey(type);
                            }
                        });
                        if (this.alignFrame.alignPanel == this.ap) {
                            this.alignViewport.setShowSequenceFeatures(true);
                            this.alignFrame.setMenusForViewport();
                        }
                    }
                    this.ap.adjustAnnotationHeight();
                }
            }
            Console.debug("Annotation Service Worker thread finished.");
        }
        return finished;
    }

    @Override
    public void cancel() {
        this.cancelCurrentJob();
    }

    @Override
    public void done() {
        if (this.ap != null) {
            if (this.guiProgress != null && this.progressId != -1L) {
                this.guiProgress.removeProgressBar(this.progressId);
            }
            this.ap.paintAlignment(false, false);
        }
    }

    boolean checkValidInputSeqs(List<SequenceI> seqs) {
        int nvalid = 0;
        for (SequenceI sq : seqs) {
            if (sq.getStart() > sq.getEnd() || !(sq.isProtein() ? this.proteinAllowed : this.nucleotidesAllowed) || !this.submitGaps && sq.getLength() != sq.getEnd() - sq.getStart() + 1) continue;
            ++nvalid;
        }
        return nvalid >= this.min_valid_seqs;
    }

    public void cancelCurrentJob() {
        try {
            String id = this.running.getJobId();
            if (this.cancellable && ((CancellableI)((Object)this.annotService)).cancel(this.running)) {
                System.err.println("Cancelled job " + id);
            } else {
                System.err.println("Job " + id + " couldn't be cancelled.");
            }
        }
        catch (Exception q) {
            q.printStackTrace();
        }
    }

    boolean isInteractiveUpdate() {
        return this.service.isInteractiveUpdate();
    }

    public List<SequenceI> getInputSequences(AlignmentI alignment, AnnotatedCollectionI inputSeqs) {
        if (alignment == null || alignment.getWidth() <= 0 || alignment.getSequences() == null || alignment.isNucleotide() ? !this.nucleotidesAllowed : !this.proteinAllowed) {
            return null;
        }
        if (inputSeqs == null || inputSeqs.getWidth() <= 0 || inputSeqs.getSequences() == null || inputSeqs.getSequences().size() < 1) {
            inputSeqs = alignment;
        }
        ArrayList<SequenceI> seqs = new ArrayList<SequenceI>();
        int minlen = 10;
        int ln = -1;
        if (this.bySequence) {
            this.seqNames = new HashMap<String, SequenceI>();
        }
        this.gapMap = new boolean[0];
        this.start = inputSeqs.getStartRes();
        this.end = inputSeqs.getEndRes();
        for (SequenceI sq : inputSeqs.getSequences()) {
            Sequence seq;
            if (!(this.bySequence ? sq.findPosition(this.end + 1) - sq.findPosition(this.start + 1) > minlen - 1 : sq.getEnd() - sq.getStart() > minlen - 1)) continue;
            String newname = SeqsetUtils.unique_name(seqs.size() + 1);
            if (this.seqNames != null) {
                this.seqNames.put(newname, sq);
            }
            if (this.submitGaps) {
                int p;
                seq = new Sequence(newname, sq.getSequenceAsString());
                seqs.add(seq);
                if (this.gapMap == null || this.gapMap.length < seq.getLength()) {
                    boolean[] blArray = this.gapMap;
                    this.gapMap = new boolean[seq.getLength()];
                    System.arraycopy(blArray, 0, this.gapMap, 0, blArray.length);
                    for (p = blArray.length; p < this.gapMap.length; ++p) {
                        this.gapMap[p] = false;
                    }
                }
                int[] nArray = sq.gapMap();
                p = nArray.length;
                for (int i = 0; i < p; ++i) {
                    int n = nArray[i];
                    char sqc = sq.getCharAt(n);
                    if (this.filterNonStandardResidues && !(sq.isProtein() ? ResidueProperties.aaIndex[sqc] < 20 : ResidueProperties.nucleotideIndex[sqc] < 5)) continue;
                    this.gapMap[n] = true;
                }
            } else {
                seq = new Sequence(newname, AlignSeq.extractGaps(Comparison.GapChars, sq.getSequenceAsString(this.start, this.end + 1)));
                seqs.add(seq);
            }
            if (seq.getLength() <= ln) continue;
            ln = seq.getLength();
        }
        if (this.alignedSeqs && this.submitGaps) {
            this.realw = 0;
            for (int i = 0; i < this.gapMap.length; ++i) {
                if (!this.gapMap[i]) continue;
                ++this.realw;
            }
            for (int p = 0; p < seqs.size(); ++p) {
                SequenceI sq;
                sq = (SequenceI)seqs.get(p);
                char[] padded = new char[this.realw];
                char[] orig = sq.getSequence();
                int n = 0;
                int pp = 0;
                while (n < this.realw) {
                    if (this.gapMap[pp]) {
                        padded[n++] = orig.length > pp ? orig[pp] : 45;
                    }
                    ++pp;
                }
                seqs.set(p, new Sequence(sq.getName(), new String(padded)));
            }
        }
        return seqs;
    }

    @Override
    public void updateAnnotation() {
        this.updateResultAnnotation(false);
    }

    public void updateResultAnnotation(boolean immediate) {
        if ((immediate || !this.calcMan.isWorking(this)) && this.running != null && this.running.hasResults()) {
            List<AlignmentAnnotation> ourAnnot = this.running.getAnnotation();
            ArrayList<AlignmentAnnotation> newAnnots = new ArrayList<AlignmentAnnotation>();
            int graphGroup = 1;
            if (this.alignViewport.getAlignment().getAlignmentAnnotation() != null) {
                for (AlignmentAnnotation ala : this.alignViewport.getAlignment().getAlignmentAnnotation()) {
                    if (ala.graphGroup <= graphGroup) continue;
                    graphGroup = ala.graphGroup;
                }
            }
            for (AlignmentAnnotation ala : ourAnnot) {
                if (ala.graphGroup > 0) {
                    ala.graphGroup += graphGroup;
                }
                SequenceI aseq = ala.sequenceRef == null ? null : this.running.getSeqNames().get(ala.sequenceRef.getName());
                Annotation[] resAnnot = ala.annotations;
                Annotation[] gappedAnnot = new Annotation[Math.max(this.alignViewport.getAlignment().getWidth(), this.gapMap.length)];
                int p = 0;
                for (int ap = 0; ap < gappedAnnot.length; ++ap) {
                    if (this.gapMap != null && this.gapMap.length > ap && !this.gapMap[ap]) {
                        gappedAnnot[ap] = new Annotation("", "", ' ', Float.NaN);
                        continue;
                    }
                    if (p >= resAnnot.length) continue;
                    gappedAnnot[ap] = resAnnot[p++];
                }
                ala.sequenceRef = aseq;
                AlignmentAnnotation newAnnot = this.getAlignViewport().getAlignment().updateFromOrCopyAnnotation(ala);
                newAnnot.annotations = gappedAnnot;
                if (aseq != null) {
                    newAnnot.createSequenceMapping(aseq, aseq.findPosition(this.start), false);
                    aseq.addAlignmentAnnotation(newAnnot);
                    newAnnot.adjustForAlignment();
                    AlignmentAnnotationUtils.replaceAnnotationOnAlignmentWith(newAnnot, newAnnot.label, newAnnot.getCalcId());
                }
                newAnnots.add(newAnnot);
            }
            for (SequenceI sq : this.running.getSeqs()) {
                SequenceI dseq;
                if (!sq.getFeatures().hasFeatures() && (sq.getDBRefs() == null || sq.getDBRefs().size() == 0)) continue;
                this.running.setTransferSequenceFeatures(true);
                SequenceI seq = this.running.getSeqNames().get(sq.getName());
                ContiguousI seqRange = seq.findPositions(this.start, this.end);
                while ((dseq = seq).getDatasetSequence() != null) {
                    seq = seq.getDatasetSequence();
                }
                ArrayList<ContiguousI> sourceRange = new ArrayList<ContiguousI>();
                if (this.gapMap != null && this.gapMap.length >= this.end) {
                    int lastcol = this.start;
                    int col = this.start;
                    do {
                        if (col != this.end && this.gapMap[col]) continue;
                        if (lastcol <= col - 1) {
                            seqRange = seq.findPositions(lastcol, col);
                            sourceRange.add(seqRange);
                        }
                        lastcol = col + 1;
                    } while (++col <= this.end);
                } else {
                    sourceRange.add(seq.findPositions(this.start, this.end));
                }
                int i = 0;
                int[] source_startend = new int[sourceRange.size() * 2];
                for (ContiguousI range : sourceRange) {
                    source_startend[i++] = range.getBegin();
                    source_startend[i++] = range.getEnd();
                }
                Mapping mp = new Mapping(new MapList(source_startend, new int[]{seq.getStart(), seq.getEnd()}, 1, 1));
                dseq.transferAnnotation(sq, mp);
            }
            this.updateOurAnnots(newAnnots);
        }
    }

    protected void updateOurAnnots(List<AlignmentAnnotation> ourAnnot) {
        List our = this.ourAnnots;
        this.ourAnnots = ourAnnot;
        AlignmentI alignment = this.alignViewport.getAlignment();
        if (our != null) {
            if (our.size() > 0) {
                for (AlignmentAnnotation an : our) {
                    if (this.ourAnnots.contains(an)) continue;
                    alignment.deleteAnnotation(an);
                }
            }
            our.clear();
        }
        for (AlignmentAnnotation an : this.ourAnnots) {
            this.alignViewport.getAlignment().validateAnnotation(an);
        }
        this.ap.adjustAnnotationHeight();
    }

    public SequenceAnnotationServiceI getService() {
        return this.annotService;
    }
}

