/*
 * Decompiled with CFR 0.152.
 */
package jalview.urls;

import jalview.bin.Console;
import jalview.urls.UrlLinkDisplay;
import jalview.urls.api.UrlProviderI;
import jalview.util.UrlLink;
import java.util.Iterator;
import java.util.List;
import javax.swing.RowFilter;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class UrlLinkTableModel
extends AbstractTableModel {
    private List<UrlLinkDisplay> data;
    private UrlProviderI dataProvider;
    private List<String> displayColumns;
    private int primaryRow;

    public UrlLinkTableModel(UrlProviderI baseData) {
        this.dataProvider = baseData;
        this.data = baseData.getLinksForTable();
        this.displayColumns = UrlLinkDisplay.getDisplayColumnNames();
        this.primaryRow = 0;
        Iterator<UrlLinkDisplay> it = this.data.iterator();
        while (it.hasNext() && !it.next().getIsPrimary()) {
            ++this.primaryRow;
        }
        this.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                try {
                    UrlLinkTableModel.this.dataProvider.setUrlData(UrlLinkTableModel.this.data);
                }
                catch (IllegalArgumentException ex) {
                    Console.error(ex.getMessage());
                }
            }
        });
    }

    @Override
    public int getRowCount() {
        if (this.data == null) {
            return 0;
        }
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return this.displayColumns.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.data.get(rowIndex).getValue(columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.data.get(rowIndex).isEditable(columnIndex);
    }

    public boolean isRowEditable(int rowIndex) {
        return this.dataProvider.isUserEntry(this.data.get(rowIndex).getId());
    }

    public boolean isRowDeletable(int rowIndex) {
        return this.dataProvider.isUserEntry(this.data.get(rowIndex).getId()) && !this.data.get(rowIndex).getIsPrimary();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 4) {
            if (rowIndex != this.primaryRow) {
                this.data.get(this.primaryRow).setValue(columnIndex, false);
                this.fireTableRowsUpdated(this.primaryRow, this.primaryRow);
                this.primaryRow = rowIndex;
                this.data.get(rowIndex).setValue(columnIndex, aValue);
                this.fireTableRowsUpdated(rowIndex, rowIndex);
            }
        } else {
            this.data.get(rowIndex).setValue(columnIndex, aValue);
            this.fireTableRowsUpdated(rowIndex, rowIndex);
        }
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.getValueAt(0, columnIndex).getClass();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.displayColumns.get(columnIndex);
    }

    public void removeRow(int rowIndex) {
        this.data.remove(rowIndex);
        if (this.primaryRow > rowIndex) {
            --this.primaryRow;
        }
        this.fireTableRowsDeleted(rowIndex, rowIndex);
    }

    public int insertRow(String name, String url) {
        UrlLink link = new UrlLink(name, url, name);
        UrlLinkDisplay u = new UrlLinkDisplay(name, link, true, false);
        int index = this.data.size();
        this.data.add(u);
        this.fireTableRowsInserted(index, index);
        return index;
    }

    public int getPrimaryColumn() {
        return 4;
    }

    public int getNameColumn() {
        return 1;
    }

    public int getDatabaseColumn() {
        return 0;
    }

    public int getIdColumn() {
        return 5;
    }

    public int getUrlColumn() {
        return 2;
    }

    public int getSelectedColumn() {
        return 3;
    }

    public boolean isUserEntry(RowFilter.Entry<? extends TableModel, ? extends Object> entry) {
        return this.dataProvider.isUserEntry(entry.getStringValue(5));
    }

    public boolean isUniqueName(String name) {
        return !this.dataProvider.contains(name);
    }
}

