/*
 * Decompiled with CFR 0.152.
 */
package jalview.schemes;

import jalview.datamodel.AnnotatedCollectionI;
import jalview.datamodel.ResidueCount;
import jalview.datamodel.SequenceCollectionI;
import jalview.datamodel.SequenceI;
import jalview.schemes.HmmerColourScheme;
import jalview.schemes.JalviewColourScheme;
import java.util.HashMap;
import java.util.List;

public class HmmerLocalBackground
extends HmmerColourScheme {
    float logTotalCount;

    public HmmerLocalBackground(AnnotatedCollectionI ac) {
        super(ac.getHmmSequences());
        this.countFrequencies(ac);
    }

    public HmmerLocalBackground() {
    }

    @Override
    public String getSchemeName() {
        return JalviewColourScheme.HMMERA.toString();
    }

    public void countFrequencies(SequenceCollectionI sc) {
        HashMap<Character, Float> freqs = new HashMap<Character, Float>();
        ResidueCount counts = new ResidueCount();
        List<SequenceI> seqs = sc.getSequences();
        for (SequenceI seq : seqs) {
            if (seq.hasHMMProfile()) continue;
            char[] cArray = seq.getSequence();
            int n = cArray.length;
            for (int i = 0; i < n; ++i) {
                char c = cArray[i];
                counts.add(c);
            }
        }
        int total = counts.getTotalResidueCount();
        for (char symbol : counts.getSymbolCounts().symbols) {
            double freq = (double)counts.getCount(symbol) / (double)total;
            freqs.put(Character.valueOf(symbol), Float.valueOf((float)freq));
        }
        this.setFrequencies(freqs);
        this.logTotalCount = (float)Math.log(total);
    }

    @Override
    float getMaxInformationScore() {
        return this.logTotalCount;
    }

    @Override
    protected HmmerColourScheme newInstance(AnnotatedCollectionI ac) {
        return new HmmerLocalBackground(ac);
    }
}

