/*
 * Decompiled with CFR 0.152.
 */
package jalview.schemes;

import jalview.api.AlignViewportI;
import jalview.datamodel.AnnotatedCollectionI;
import jalview.datamodel.SequenceCollectionI;
import jalview.schemes.ColourSchemeI;
import jalview.schemes.HmmerColourScheme;
import jalview.schemes.JalviewColourScheme;
import jalview.schemes.ResidueProperties;

public class HmmerGlobalBackground
extends HmmerColourScheme {
    private static final float MAX_LOG_RATIO = 4.519f;

    public HmmerGlobalBackground(SequenceCollectionI ac) {
        super(ac.getHmmSequences());
        String alphabetType = this.getHmm() == null ? "amino" : this.getHmm().getAlphabetType();
        this.setFrequencies(ResidueProperties.backgroundFrequencies.get(alphabetType));
    }

    public HmmerGlobalBackground() {
    }

    @Override
    public String getSchemeName() {
        return JalviewColourScheme.HMMERU.toString();
    }

    @Override
    protected HmmerColourScheme newInstance(AnnotatedCollectionI ac) {
        return new HmmerGlobalBackground(ac);
    }

    @Override
    float getMaxInformationScore() {
        return 4.519f;
    }

    @Override
    public ColourSchemeI getInstance(AlignViewportI viewport, AnnotatedCollectionI ac) {
        return this.newInstance(ac);
    }
}

