/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import jalview.bin.Console;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceI;
import jalview.io.AlignFile;
import jalview.io.DataSourceType;
import jalview.io.FileParse;
import jalview.io.JnetAnnotationMaker;
import jalview.util.MessageManager;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;

public class JPredFile
extends AlignFile {
    Vector ids;
    Vector conf;
    Hashtable Scores;
    Hashtable Symscores;
    private int QuerySeqPosition;
    Vector annotSeqs = null;

    public JPredFile(Object inFile, DataSourceType sourceType) throws IOException {
        super(inFile, sourceType);
    }

    public JPredFile(FileParse source) throws IOException {
        super(source);
    }

    public void setQuerySeqPosition(int QuerySeqPosition) {
        this.QuerySeqPosition = QuerySeqPosition;
    }

    public int getQuerySeqPosition() {
        return this.QuerySeqPosition;
    }

    public Hashtable getScores() {
        return this.Scores;
    }

    public Hashtable getSymscores() {
        return this.Symscores;
    }

    @Override
    public void initData() {
        super.initData();
        this.Scores = new Hashtable();
        this.ids = null;
        this.conf = null;
    }

    @Override
    public void parse() throws IOException {
        String line;
        this.QuerySeqPosition = -1;
        this.noSeqs = 0;
        Vector<CharSequence> seq_entries = new Vector<CharSequence>();
        Vector<Object> ids = new Vector<Object>();
        Hashtable<Object, Integer> Symscores = new Hashtable<Object, Integer>();
        while ((line = this.nextLine()) != null) {
            int i;
            StringTokenizer str = new StringTokenizer(line, ":");
            Object id = "";
            if (!str.hasMoreTokens()) continue;
            id = str.nextToken();
            String seqsym = str.nextToken();
            StringTokenizer symbols = new StringTokenizer(seqsym, ",");
            int numSymbols = symbols.countTokens();
            if (numSymbols == 0) continue;
            if (seqsym.length() != 2 * numSymbols) {
                if (this.Scores.containsKey(id)) {
                    int i2 = 1;
                    while (this.Scores.containsKey((String)id + "_" + i2)) {
                        ++i2;
                    }
                    id = (String)id + "_" + i2;
                }
                Vector<Object> scores = new Vector<Object>();
                i = 0;
                String ascore = "dead";
                try {
                    while (symbols.hasMoreTokens()) {
                        ascore = symbols.nextToken();
                        Float score = Float.valueOf(ascore);
                        scores.addElement(score);
                    }
                    this.Scores.put(id, scores);
                }
                catch (Exception e) {
                    i = scores.size();
                    for (int j = 0; j < i; ++j) {
                        scores.setElementAt(((Float)scores.elementAt(j)).toString(), j);
                    }
                    scores.addElement(ascore);
                    while (symbols.hasMoreTokens()) {
                        ascore = symbols.nextToken();
                        scores.addElement(ascore);
                    }
                    this.Scores.put(id, scores);
                }
                continue;
            }
            if (((String)id).equals("jnetconf")) {
                id = "Prediction Confidence";
                this.conf = new Vector(numSymbols);
                for (int i3 = 0; i3 < numSymbols; ++i3) {
                    this.conf.setElementAt(symbols.nextToken(), i3);
                }
                continue;
            }
            StringBuffer newseq = new StringBuffer();
            for (i = 0; i < numSymbols; ++i) {
                newseq.append(symbols.nextToken());
            }
            if (((String)id).indexOf(";") > -1) {
                seq_entries.addElement(newseq);
                i = 1;
                Object name = ((String)id).substring(((String)id).indexOf(";") + 1);
                while (ids.lastIndexOf(name) > -1) {
                    name = ((String)id).substring(((String)id).indexOf(";") + 1) + "_" + ++i;
                }
                if (this.QuerySeqPosition == -1) {
                    this.QuerySeqPosition = ids.size();
                }
                ids.addElement(name);
                ++this.noSeqs;
                continue;
            }
            if (((String)id).equals("JNETPRED")) {
                id = "Predicted Secondary Structure";
            }
            seq_entries.addElement(newseq.toString());
            ids.addElement(id);
            Symscores.put(id, ids.size() - 1);
        }
        this.maxLength = seq_entries.elementAt(0).toString().length();
        for (int i = 0; i < ids.size(); ++i) {
            Sequence newSeq = new Sequence(ids.elementAt(i).toString(), seq_entries.elementAt(i).toString(), 1, seq_entries.elementAt(i).toString().length());
            if (this.maxLength != seq_entries.elementAt(i).toString().length()) {
                throw new IOException(MessageManager.formatMessage("exception.jpredconcide_entry_has_unexpected_number_of_columns", new String[]{ids.elementAt(i).toString()}));
            }
            if ((newSeq.getName().startsWith("QUERY") || newSeq.getName().startsWith("align;")) && this.QuerySeqPosition == -1) {
                this.QuerySeqPosition = this.seqs.size();
            }
            this.seqs.addElement(newSeq);
        }
        if (this.seqs.size() > 0 && this.QuerySeqPosition > -1) {
            Alignment tal = new Alignment(this.getSeqsAsArray());
            try {
                JnetAnnotationMaker.add_annotation(this, tal, this.QuerySeqPosition, true);
            }
            catch (Exception e) {
                tal = null;
                IOException ex = new IOException(MessageManager.formatMessage("exception.couldnt_parse_concise_annotation_for_prediction", new String[]{e.getMessage()}));
                e.printStackTrace();
                throw ex;
            }
            this.annotations = new Vector();
            AlignmentAnnotation[] aan = tal.getAlignmentAnnotation();
            for (int aai = 0; aan != null && aai < aan.length; ++aai) {
                this.annotations.addElement(aan[aai]);
            }
        }
    }

    @Override
    public String print(SequenceI[] sqs, boolean jvsuffix) {
        return "Not Supported";
    }

    public static void main(String[] args) {
        try {
            JPredFile jpred = new JPredFile(args[0], DataSourceType.FILE);
            for (int i = 0; i < jpred.seqs.size(); ++i) {
                Console.outPrintln(((Sequence)jpred.seqs.elementAt(i)).getName() + "\n" + ((Sequence)jpred.seqs.elementAt(i)).getSequenceAsString() + "\n");
            }
        }
        catch (IOException e) {
            Console.errPrintln("Exception " + e);
        }
    }

    public void removeNonSequences() {
        int i;
        if (this.annotSeqs != null) {
            return;
        }
        this.annotSeqs = new Vector();
        Vector newseqs = new Vector();
        int j = this.seqs.size();
        for (i = 0; i < this.QuerySeqPosition; ++i) {
            this.annotSeqs.addElement(this.seqs.elementAt(i));
        }
        SequenceI sq = (SequenceI)this.seqs.elementAt(j - 1);
        if (sq.getName().toUpperCase(Locale.ROOT).startsWith("JPRED")) {
            this.annotSeqs.addElement(sq);
            this.seqs.removeElementAt(--j);
        }
        while (i < j) {
            newseqs.addElement(this.seqs.elementAt(i));
            ++i;
        }
        this.seqs.removeAllElements();
        this.seqs = newseqs;
    }
}

