/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import fr.orsay.lri.varna.exceptions.ExceptionFileFormatOrSyntax;
import fr.orsay.lri.varna.exceptions.ExceptionLoadingFailed;
import fr.orsay.lri.varna.exceptions.ExceptionPermissionDenied;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import jalview.io.AlignFile;
import jalview.io.DataSourceType;
import jalview.io.FileParse;
import jalview.util.MessageManager;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class BSMLFile
extends AlignFile {
    public BSMLFile() {
    }

    public BSMLFile(String inFile, DataSourceType type) throws IOException {
        super(inFile, type);
    }

    public BSMLFile(FileParse source) throws IOException {
        super(source);
    }

    public BufferedReader CreateReader() throws FileNotFoundException {
        FileReader fr = null;
        fr = new FileReader(this.inFile);
        BufferedReader r = new BufferedReader(fr);
        return r;
    }

    @Override
    public void parse() throws IOException {
        try {
            this._parse();
        }
        catch (ExceptionPermissionDenied pdx) {
            this.errormessage = MessageManager.formatMessage("exception.BSML_couldnt_access_datasource", new String[]{pdx.getMessage()});
            throw new IOException(pdx);
        }
        catch (ExceptionLoadingFailed lf) {
            this.errormessage = MessageManager.formatMessage("exception.BSML_couldnt_process_data", new String[]{lf.getMessage()});
            throw new IOException(lf);
        }
        catch (ExceptionFileFormatOrSyntax iff) {
            this.errormessage = MessageManager.formatMessage("exception.BSML_invalid_file", new String[]{iff.getMessage()});
            throw new IOException(iff);
        }
        catch (Exception x) {
            this.error = true;
            this.errormessage = MessageManager.formatMessage("exception.BSML_problem_parsing_data", new String[]{x.getMessage()});
            throw new IOException(this.errormessage, x);
        }
    }

    public void _parse() throws ExceptionPermissionDenied, ExceptionLoadingFailed, ExceptionFileFormatOrSyntax, ParserConfigurationException, SAXException, IOException {
        SequenceI seq;
        Element e;
        int i;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setIgnoringElementContentWhitespace(true);
        dbf.setIgnoringComments(true);
        dbf.setValidating(true);
        dbf.setCoalescing(true);
        dbf.setNamespaceAware(true);
        dbf.setFeature("http://xml.org/sax/features/namespaces", false);
        dbf.setFeature("http://xml.org/sax/features/validation", false);
        dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
        dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Hashtable<String, Sequence> htSeq = new Hashtable<String, Sequence>();
        InputSource is = new InputSource(this.getReader());
        Document d = db.parse(is);
        NodeList sequences = d.getElementsByTagName("Sequence-data");
        int n = sequences.getLength();
        SequenceI[] sqs = new SequenceI[n];
        for (i = 0; i < n; ++i) {
            e = (Element)sequences.item(i);
            String s = e.getTextContent();
            String id = e.getAttribute("seq-name");
            seq = sqs[i] = new Sequence(id, s, 1, s.length());
            htSeq.put(id, (Sequence)seq);
        }
        sequences = d.getElementsByTagName("Sequence");
        n = sequences.getLength();
        for (i = 0; i < n; ++i) {
            e = (Element)sequences.item(i);
            String mol = e.getAttribute("molecule");
            if (!"dna".equals(mol)) {
                System.err.println("BSML molecule=rna not implemented");
                continue;
            }
            String title = e.getAttribute("title");
            seq = (SequenceI)htSeq.get(title);
            if (seq == null) continue;
            NodeList features = e.getElementsByTagName("Feature");
            int featureCount = features.getLength();
            for (int f = 0; f < featureCount; ++f) {
                String fclass;
                Element feature = (Element)features.item(f);
                Element iloc = (Element)feature.getElementsByTagName("Interval-loc").item(0);
                String complement = iloc.getAttribute("complement");
                if (!"0".equals(complement) || !"GENE".equals(fclass = feature.getAttribute("class"))) continue;
                String ftitle = feature.getAttribute("title");
                int start = Integer.parseInt(iloc.getAttribute("startpos"));
                int end = Integer.parseInt(iloc.getAttribute("endpos"));
                SequenceFeature sf = new SequenceFeature("GENE", ftitle, start, end, null);
                seq.addSequenceFeature(sf);
            }
            this.setSeqs(sqs);
        }
    }

    @Override
    public String print(SequenceI[] s, boolean jvSuffix) {
        return "not yet implemented";
    }
}

