/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import javax.swing.JSlider;

public class Slider
extends JSlider {
    private static final int SCALE_TICKS = 1000;
    private float trueMin;
    private float trueMax;
    private float sliderScaleFactor;

    public Slider(float min, float max, float value) {
        this.setSliderModel(min, max, value);
    }

    public void setSliderModel(float min, float max, float value) {
        this.trueMin = min;
        this.trueMax = max;
        this.setMinimum(0);
        this.sliderScaleFactor = 1000.0f / (max - min);
        int sliderMax = (int)((max - min) * this.sliderScaleFactor);
        this.setMaximum(sliderMax);
        this.setSliderValue(value);
    }

    public float getSliderValue() {
        int value = this.getValue();
        return value == this.getMaximum() ? this.trueMax : (float)value / this.sliderScaleFactor + this.trueMin;
    }

    public void setSliderValue(float value) {
        this.setValue(Math.round((value - this.trueMin) * this.sliderScaleFactor));
    }

    public float getSliderPercentageValue() {
        return (float)(this.getValue() - this.getMinimum()) * 100.0f / (float)(this.getMaximum() - this.getMinimum());
    }

    public void setSliderPercentageValue(float pct) {
        float pc = pct / 100.0f * (float)this.getMaximum();
        this.setValue((int)pc);
    }
}

