/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.api.AlignViewportI;
import jalview.api.FinderI;
import jalview.datamodel.SearchResultMatchI;
import jalview.datamodel.SearchResultsI;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignFrame;
import jalview.gui.AlignmentPanel;
import jalview.gui.Desktop;
import jalview.gui.FeatureEditor;
import jalview.gui.JvOptionPane;
import jalview.jbgui.GFinder;
import jalview.util.MessageManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.KeyStroke;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class Finder
extends GFinder {
    private static final int MIN_WIDTH = 350;
    private static final int MIN_HEIGHT = 120;
    private static final int MY_HEIGHT = 150;
    private static final int MY_WIDTH = 400;
    private AlignViewportI av;
    private AlignmentPanel ap;
    private JInternalFrame frame;
    private Map<AlignViewportI, FinderI> finders;
    private SearchResultsI searchResults;
    private boolean focusFixed;

    public Finder(AlignmentPanel alignPanel, boolean fixedFocus, String scope) {
        this.av = alignPanel.getAlignViewport();
        this.ap = alignPanel;
        this.focusFixed = fixedFocus;
        this.finders = new HashMap<AlignViewportI, FinderI>();
        this.frame = new JInternalFrame();
        this.frame.setFrameIcon(null);
        this.frame.setContentPane(this);
        this.frame.setLayer(JLayeredPane.PALETTE_LAYER);
        this.frame.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosing(InternalFrameEvent e) {
                Finder.this.closeAction();
            }
        });
        this.frame.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                Finder.this.getFocusedViewport();
            }
        });
        this.addEscapeHandler();
        Object title = MessageManager.getString("label.find");
        if (scope != null) {
            title = (String)title + " " + scope;
        }
        Desktop.addInternalFrame(this.frame, (String)title, true, 400, 150, true, true);
        this.frame.setMinimumSize(new Dimension(350, 120));
        this.searchBox.getComponent().requestFocus();
    }

    private void addEscapeHandler() {
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "Cancel");
        this.getRootPane().getActionMap().put("Cancel", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Finder.this.closeAction();
            }
        });
    }

    @Override
    public void findNext_actionPerformed() {
        if (this.getFocusedViewport()) {
            this.doSearch(false);
        }
    }

    @Override
    public void findAll_actionPerformed() {
        if (this.getFocusedViewport()) {
            this.doSearch(true);
        }
    }

    boolean getFocusedViewport() {
        if (this.focusFixed || Desktop.getDesktopPane() == null) {
            if (this.ap != null && this.av != null) {
                this.ignoreHidden.setEnabled(this.av.hasHiddenColumns());
                return true;
            }
            return false;
        }
        JInternalFrame[] frames = Desktop.getDesktopPane().getAllFrames();
        for (int f = 0; f < frames.length; ++f) {
            JInternalFrame alignFrame = frames[f];
            if (alignFrame == null || !(alignFrame instanceof AlignFrame) || alignFrame.isIcon()) continue;
            this.av = ((AlignFrame)alignFrame).viewport;
            this.ap = ((AlignFrame)alignFrame).alignPanel;
            this.ignoreHidden.setEnabled(this.av.hasHiddenColumns());
            return true;
        }
        return false;
    }

    @Override
    public void createFeatures_actionPerformed() {
        if (this.searchResults.isEmpty()) {
            return;
        }
        ArrayList<SequenceI> seqs = new ArrayList<SequenceI>();
        ArrayList<SequenceFeature> features = new ArrayList<SequenceFeature>();
        String searchString = this.searchBox.getUserInput();
        String desc = "Search Results";
        for (SearchResultMatchI match : this.searchResults.getResults()) {
            seqs.add(match.getSequence().getDatasetSequence());
            features.add(new SequenceFeature(searchString, desc, match.getStart(), match.getEnd(), desc));
        }
        new FeatureEditor(this.ap, seqs, features, true).showDialog();
    }

    @Override
    protected void copyToClipboard_actionPerformed() {
        if (this.searchResults.isEmpty()) {
            return;
        }
        this.ap.alignFrame.avc.copyHighlightedRegionsToClipboard();
    }

    void doSearch(boolean doFindAll) {
        this.createFeatures.setEnabled(false);
        this.copyToClipboard.setEnabled(false);
        String searchString = this.searchBox.getUserInput();
        if (this.isInvalidSearchString(searchString)) {
            return;
        }
        FinderI finder = this.finders.get(this.av);
        if (finder == null) {
            finder = new jalview.analysis.Finder(this.av);
            this.finders.put(this.av, finder);
        }
        finder.setFeatureRenderer(this.ap.getFeatureRenderer());
        boolean isCaseSensitive = this.caseSensitive.isSelected();
        boolean doSearchDescription = this.searchDescription.isSelected();
        boolean doSearchfeatures = this.searchFeatures.isSelected();
        boolean skipHidden = this.ignoreHidden.isSelected();
        if (doFindAll) {
            finder.findAll(searchString, isCaseSensitive, doSearchDescription, doSearchfeatures, skipHidden);
        } else {
            finder.findNext(searchString, isCaseSensitive, doSearchDescription, doSearchfeatures, skipHidden);
        }
        this.searchResults = finder.getSearchResults();
        List<SequenceI> idMatch = finder.getIdMatches();
        this.ap.getIdPanel().highlightSearchResults(idMatch);
        if (this.searchResults.isEmpty()) {
            this.searchResults = null;
        } else {
            this.createFeatures.setEnabled(true);
            this.copyToClipboard.setEnabled(true);
        }
        this.searchBox.updateCache();
        this.ap.highlightSearchResults(this.searchResults);
        if (idMatch.isEmpty() && this.searchResults == null) {
            JvOptionPane.showInternalMessageDialog((Component)this, MessageManager.getString("label.finished_searching"), null, -1);
        } else if (doFindAll) {
            StringBuilder message = new StringBuilder();
            if (idMatch.size() > 0) {
                message.append(idMatch.size()).append(" IDs");
            }
            if (this.searchResults != null) {
                if (idMatch.size() > 0 && this.searchResults.getCount() > 0) {
                    message.append(" ").append(MessageManager.getString("label.and").toLowerCase(Locale.ROOT)).append(" ");
                }
                message.append(MessageManager.formatMessage("label.subsequence_matches_found", this.searchResults.getCount()));
            }
            JvOptionPane.showInternalMessageDialog((Component)this, message.toString(), null, 1);
        }
    }

    protected boolean isInvalidSearchString(String searchString) {
        String error = this.getSearchValidationError(searchString);
        if (error == null) {
            return false;
        }
        JvOptionPane.showInternalMessageDialog((Component)this, error, MessageManager.getString("label.invalid_search"), 0);
        return true;
    }

    protected String getSearchValidationError(String searchString) {
        Object error = null;
        if (searchString == null || searchString.length() == 0) {
            error = MessageManager.getString("label.invalid_search");
        }
        try {
            Pattern.compile(searchString);
        }
        catch (PatternSyntaxException e) {
            error = MessageManager.getString("error.invalid_regex") + ": " + e.getDescription();
        }
        return error;
    }

    protected void closeAction() {
        this.frame.setVisible(false);
        this.frame.dispose();
        this.searchBox.persistCache();
        if (this.getFocusedViewport()) {
            this.ap.alignFrame.requestFocus();
        }
    }
}

