/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RangeIterator
implements Iterator<int[]> {
    private int currentPosition = 0;
    private int[] currentRange;
    private List<int[]> localRanges;

    RangeIterator(List<int[]> rangeList) {
        if (!rangeList.isEmpty()) {
            int last = rangeList.get(rangeList.size() - 1)[1];
            this.init(0, last, rangeList);
        } else {
            this.init(0, 0, rangeList);
        }
    }

    RangeIterator(int lowerBound, int upperBound, List<int[]> rangeList) {
        this.init(lowerBound, upperBound, rangeList);
    }

    private void init(int lowerBound, int upperBound, List<int[]> rangeList) {
        int start = lowerBound;
        int end = upperBound;
        if (rangeList != null) {
            int i;
            this.localRanges = new ArrayList<int[]>();
            for (i = 0; i < rangeList.size() && rangeList.get(i)[1] < start; ++i) {
            }
            while (i < rangeList.size() && rangeList.get(i)[0] <= end) {
                int[] rh = rangeList.get(i);
                int[] cp = new int[2];
                System.arraycopy(rh, 0, cp, 0, rh.length);
                this.localRanges.add(cp);
                ++i;
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.localRanges != null && this.currentPosition < this.localRanges.size();
    }

    @Override
    public int[] next() {
        this.currentRange = this.localRanges.get(this.currentPosition);
        ++this.currentPosition;
        return this.currentRange;
    }

    @Override
    public void remove() {
        this.localRanges.remove(--this.currentPosition);
    }
}

