/*
 * Decompiled with CFR 0.152.
 */
package jalview.appletgui;

import jalview.analysis.AAFrequency;
import jalview.analysis.AlignmentAnnotationUtils;
import jalview.analysis.AlignmentUtils;
import jalview.analysis.Conservation;
import jalview.appletgui.AlignmentPanel;
import jalview.appletgui.AppletJmol;
import jalview.appletgui.CutAndPasteTransfer;
import jalview.appletgui.EditNameDialog;
import jalview.appletgui.SliderPanel;
import jalview.appletgui.UserDefinedColours;
import jalview.bin.Console;
import jalview.bin.JalviewLite;
import jalview.commands.ChangeCaseCommand;
import jalview.commands.EditCommand;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.io.AppletFormatAdapter;
import jalview.io.DataSourceType;
import jalview.io.FileFormatI;
import jalview.io.FileFormats;
import jalview.io.SequenceAnnotationReport;
import jalview.renderer.ResidueShader;
import jalview.renderer.ResidueShaderI;
import jalview.schemes.Blosum62ColourScheme;
import jalview.schemes.BuriedColourScheme;
import jalview.schemes.ClustalxColourScheme;
import jalview.schemes.HelixColourScheme;
import jalview.schemes.HydrophobicColourScheme;
import jalview.schemes.JalviewColourScheme;
import jalview.schemes.NucleotideColourScheme;
import jalview.schemes.PIDColourScheme;
import jalview.schemes.PurinePyrimidineColourScheme;
import jalview.schemes.StrandColourScheme;
import jalview.schemes.TaylorColourScheme;
import jalview.schemes.TurnColourScheme;
import jalview.schemes.ZappoColourScheme;
import jalview.util.MessageManager;
import jalview.util.UrlLink;
import java.awt.CheckboxMenuItem;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import mc_view.AppletPDBViewer;

public class APopupMenu
extends PopupMenu
implements ActionListener,
ItemListener {
    Menu groupMenu = new Menu();
    MenuItem editGroupName = new MenuItem();
    CheckboxMenuItem noColour = new CheckboxMenuItem();
    protected CheckboxMenuItem clustalColour = new CheckboxMenuItem();
    protected CheckboxMenuItem zappoColour = new CheckboxMenuItem();
    protected CheckboxMenuItem taylorColour = new CheckboxMenuItem();
    protected CheckboxMenuItem hydrophobicityColour = new CheckboxMenuItem();
    protected CheckboxMenuItem helixColour = new CheckboxMenuItem();
    protected CheckboxMenuItem strandColour = new CheckboxMenuItem();
    protected CheckboxMenuItem turnColour = new CheckboxMenuItem();
    protected CheckboxMenuItem buriedColour = new CheckboxMenuItem();
    protected CheckboxMenuItem PIDColour = new CheckboxMenuItem();
    protected CheckboxMenuItem BLOSUM62Colour = new CheckboxMenuItem();
    CheckboxMenuItem nucleotideColour = new CheckboxMenuItem();
    CheckboxMenuItem purinePyrimidineColour = new CheckboxMenuItem();
    protected MenuItem userDefinedColour = new MenuItem();
    protected CheckboxMenuItem abovePIDColour = new CheckboxMenuItem();
    MenuItem modifyPID = new MenuItem();
    protected CheckboxMenuItem conservationColour = new CheckboxMenuItem();
    MenuItem modifyConservation = new MenuItem();
    MenuItem noColourmenuItem = new MenuItem();
    final AlignmentPanel ap;
    MenuItem unGroupMenuItem = new MenuItem();
    MenuItem createGroupMenuItem = new MenuItem();
    Menu colourMenu = new Menu();
    CheckboxMenuItem showBoxes = new CheckboxMenuItem();
    CheckboxMenuItem showText = new CheckboxMenuItem();
    CheckboxMenuItem showColourText = new CheckboxMenuItem();
    CheckboxMenuItem displayNonconserved = new CheckboxMenuItem();
    Menu seqShowAnnotationsMenu = new Menu(MessageManager.getString("label.show_annotations"));
    Menu seqHideAnnotationsMenu = new Menu(MessageManager.getString("label.hide_annotations"));
    MenuItem seqAddReferenceAnnotations = new MenuItem(MessageManager.getString("label.add_reference_annotations"));
    Menu groupShowAnnotationsMenu = new Menu(MessageManager.getString("label.show_annotations"));
    Menu groupHideAnnotationsMenu = new Menu(MessageManager.getString("label.hide_annotations"));
    MenuItem groupAddReferenceAnnotations = new MenuItem(MessageManager.getString("label.add_reference_annotations"));
    Menu editMenu = new Menu(MessageManager.getString("action.edit"));
    MenuItem copy = new MenuItem(MessageManager.getString("action.copy"));
    MenuItem cut = new MenuItem(MessageManager.getString("action.cut"));
    MenuItem toUpper = new MenuItem(MessageManager.getString("label.to_upper_case"));
    MenuItem toLower = new MenuItem(MessageManager.getString("label.to_lower_case"));
    MenuItem toggleCase = new MenuItem(MessageManager.getString("label.toggle_case"));
    Menu outputmenu = new Menu();
    Menu seqMenu = new Menu();
    MenuItem pdb = new MenuItem();
    MenuItem hideSeqs = new MenuItem();
    MenuItem repGroup = new MenuItem();
    MenuItem sequenceName = new MenuItem(MessageManager.getString("label.edit_name_description"));
    MenuItem sequenceFeature = new MenuItem(MessageManager.getString("label.create_sequence_feature"));
    MenuItem editSequence = new MenuItem(MessageManager.getString("label.edit_sequence"));
    MenuItem sequenceDetails = new MenuItem(MessageManager.getString("label.sequence_details"));
    MenuItem selSeqDetails = new MenuItem(MessageManager.getString("label.sequence_details"));
    MenuItem makeReferenceSeq = new MenuItem();
    SequenceI seq;
    MenuItem revealAll = new MenuItem();
    MenuItem revealSeq = new MenuItem();
    int revealSeq_index = -1;
    Menu menu1 = new Menu();

    public APopupMenu(AlignmentPanel apanel, SequenceI seq, List<String> links) {
        this.ap = apanel;
        this.seq = seq;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (String ff : FileFormats.getInstance().getWritableFormats(true)) {
            MenuItem item = new MenuItem(ff);
            item.addActionListener(this);
            this.outputmenu.add(item);
        }
        this.buildAnnotationSubmenus();
        SequenceGroup sg = this.ap.av.getSelectionGroup();
        if (sg != null && sg.getSize() > 0) {
            if (sg.isNucleotide()) {
                this.conservationColour.setEnabled(false);
                this.clustalColour.setEnabled(false);
                this.BLOSUM62Colour.setEnabled(false);
                this.zappoColour.setEnabled(false);
                this.taylorColour.setEnabled(false);
                this.hydrophobicityColour.setEnabled(false);
                this.helixColour.setEnabled(false);
                this.strandColour.setEnabled(false);
                this.turnColour.setEnabled(false);
                this.buriedColour.setEnabled(false);
            } else {
                this.purinePyrimidineColour.setEnabled(false);
                this.nucleotideColour.setEnabled(false);
            }
            this.editGroupName.setLabel(MessageManager.formatMessage("label.name_param", sg.getName()));
            this.showText.setState(sg.getDisplayText());
            this.showColourText.setState(sg.getColourText());
            this.showBoxes.setState(sg.getDisplayBoxes());
            this.displayNonconserved.setState(sg.getShowNonconserved());
            if (!this.ap.av.getAlignment().getGroups().contains(sg)) {
                this.menu1.setLabel(MessageManager.getString("action.edit_new_group"));
                this.groupMenu.remove(this.unGroupMenuItem);
            } else {
                this.menu1.setLabel(MessageManager.getString("action.edit_group"));
                this.groupMenu.remove(this.createGroupMenuItem);
                if (sg.cs != null) {
                    this.abovePIDColour.setState(sg.cs.getThreshold() > 0);
                    this.conservationColour.setState(sg.cs.conservationApplied());
                    this.modifyPID.setEnabled(this.abovePIDColour.getState());
                    this.modifyConservation.setEnabled(this.conservationColour.getState());
                }
            }
            this.setSelectedColour(sg.cs);
        } else {
            this.remove(this.hideSeqs);
            this.remove(this.groupMenu);
        }
        if (links != null && links.size() > 0) {
            this.addFeatureLinks(seq, links);
        }
        if (seq != null) {
            this.seqMenu.setLabel(seq.getName());
            if (seq == this.ap.av.getAlignment().getSeqrep()) {
                this.makeReferenceSeq.setLabel(MessageManager.getString("action.unmark_as_reference"));
            } else {
                this.makeReferenceSeq.setLabel(MessageManager.getString("action.set_as_reference"));
            }
            this.repGroup.setLabel(MessageManager.formatMessage("label.represent_group_with", seq.getName()));
        } else {
            this.remove(this.seqMenu);
        }
        if (!this.ap.av.hasHiddenRows()) {
            this.remove(this.revealAll);
            this.remove(this.revealSeq);
        } else {
            int index = this.ap.av.getAlignment().findIndex(seq);
            if (this.ap.av.adjustForHiddenSeqs(index) - this.ap.av.adjustForHiddenSeqs(index - 1) > 1) {
                this.revealSeq_index = index;
            } else {
                this.remove(this.revealSeq);
            }
        }
    }

    protected void setSelectedColour(ResidueShaderI cs) {
        if (cs == null || cs.getColourScheme() == null) {
            this.noColour.setState(true);
        } else {
            String name = cs.getColourScheme().getSchemeName();
            for (int i = 0; i < this.colourMenu.getItemCount(); ++i) {
                MenuItem item = this.colourMenu.getItem(i);
                if (!(item instanceof CheckboxMenuItem) || !name.equals(item.getName())) continue;
                ((CheckboxMenuItem)item).setState(true);
            }
        }
    }

    void addFeatureLinks(SequenceI seq, List<String> links) {
        Menu linkMenu = new Menu(MessageManager.getString("action.link"));
        LinkedHashMap<String, List<String>> linkset = new LinkedHashMap<String, List<String>>();
        for (String link : links) {
            UrlLink urlLink = null;
            try {
                urlLink = new UrlLink(link);
            }
            catch (Exception foo) {
                Console.errPrintln("Exception for URLLink '" + link + "': " + foo.getMessage());
                continue;
            }
            if (!urlLink.isValid()) {
                Console.errPrintln(urlLink.getInvalidMessage());
                continue;
            }
            urlLink.createLinksFromSeq(seq, linkset);
        }
        this.addshowLinks(linkMenu, linkset.values());
        if (linkMenu.getItemCount() > 0) {
            linkMenu.setEnabled(true);
        } else {
            linkMenu.setEnabled(false);
        }
        if (seq != null) {
            this.seqMenu.add(linkMenu);
        } else {
            this.add(linkMenu);
        }
    }

    private void addshowLinks(Menu linkMenu, Collection<List<String>> linkset) {
        for (List<String> linkstrset : linkset) {
            this.addshowLink(linkMenu, linkstrset.get(1), linkstrset.get(3));
        }
    }

    private void buildAnnotationSubmenus() {
        List<SequenceI> selectedSequence = this.seq == null ? Collections.emptyList() : Arrays.asList(this.seq);
        this.buildAnnotationTypesMenus(this.seqShowAnnotationsMenu, this.seqHideAnnotationsMenu, selectedSequence);
        this.configureReferenceAnnotationsMenu(this.seqAddReferenceAnnotations, selectedSequence);
        List<SequenceI> selectedGroup = this.ap.av.getSelectionGroup() == null ? Collections.emptyList() : this.ap.av.getSelectionGroup().getSequences();
        this.buildAnnotationTypesMenus(this.groupShowAnnotationsMenu, this.groupHideAnnotationsMenu, selectedGroup);
        this.configureReferenceAnnotationsMenu(this.groupAddReferenceAnnotations, selectedGroup);
    }

    private void configureReferenceAnnotationsMenu(MenuItem menuItem, List<SequenceI> forSequences) {
        menuItem.setEnabled(false);
        TreeMap<String, String> tipEntries = new TreeMap<String, String>();
        final LinkedHashMap<SequenceI, List<AlignmentAnnotation>> candidates = new LinkedHashMap<SequenceI, List<AlignmentAnnotation>>();
        AlignmentI al = this.ap.av.getAlignment();
        AlignmentUtils.findAddableReferenceAnnotations(forSequences, tipEntries, candidates, al);
        if (!candidates.isEmpty()) {
            StringBuilder tooltip = new StringBuilder(64);
            tooltip.append(MessageManager.getString("label.add_annotations_for"));
            menuItem.setEnabled(true);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    APopupMenu.this.addReferenceAnnotations_actionPerformed(candidates);
                }
            });
        }
    }

    protected void addReferenceAnnotations_actionPerformed(Map<SequenceI, List<AlignmentAnnotation>> candidates) {
        SequenceGroup selectionGroup = this.ap.av.getSelectionGroup();
        AlignmentI alignment = this.ap.getAlignment();
        AlignmentUtils.addReferenceAnnotations(candidates, alignment, selectionGroup);
        this.refresh();
    }

    private void addshowLink(Menu linkMenu, String target, String url) {
        this.addshowLink(linkMenu, target, target, url);
    }

    private void addshowLink(Menu linkMenu, final String target, String label, final String url) {
        MenuItem item = new MenuItem(label);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                APopupMenu.this.ap.alignFrame.showURL(url, target);
            }
        });
        linkMenu.add(item);
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        Object source = evt.getSource();
        if (source == this.noColour) {
            this.noColourmenuItem_actionPerformed();
        } else if (source == this.clustalColour) {
            this.clustalColour_actionPerformed();
        } else if (source == this.BLOSUM62Colour) {
            this.BLOSUM62Colour_actionPerformed();
        } else if (evt.getSource() == this.PIDColour) {
            this.PIDColour_actionPerformed();
        } else if (source == this.zappoColour) {
            this.zappoColour_actionPerformed();
        } else if (source == this.taylorColour) {
            this.taylorColour_actionPerformed();
        } else if (source == this.hydrophobicityColour) {
            this.hydrophobicityColour_actionPerformed();
        } else if (source == this.helixColour) {
            this.helixColour_actionPerformed();
        } else if (source == this.strandColour) {
            this.strandColour_actionPerformed();
        } else if (source == this.turnColour) {
            this.turnColour_actionPerformed();
        } else if (source == this.buriedColour) {
            this.buriedColour_actionPerformed();
        } else if (source == this.nucleotideColour) {
            this.nucleotideMenuItem_actionPerformed();
        } else if (source == this.purinePyrimidineColour) {
            this.purinePyrimidineColour_actionPerformed();
        } else if (source == this.abovePIDColour) {
            this.abovePIDColour_itemStateChanged();
        } else if (source == this.conservationColour) {
            this.conservationMenuItem_itemStateChanged();
        } else if (source == this.showColourText) {
            this.showColourText_itemStateChanged();
        } else if (source == this.showText) {
            this.showText_itemStateChanged();
        } else if (source == this.showBoxes) {
            this.showBoxes_itemStateChanged();
        } else if (source == this.displayNonconserved) {
            this.showNonconserved_itemStateChanged();
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.userDefinedColour) {
            this.userDefinedColour_actionPerformed();
        } else if (source == this.modifyConservation) {
            this.conservationMenuItem_itemStateChanged();
        } else if (source == this.modifyPID) {
            this.abovePIDColour_itemStateChanged();
        } else if (source == this.unGroupMenuItem) {
            this.unGroupMenuItem_actionPerformed();
        } else if (source == this.createGroupMenuItem) {
            this.createGroupMenuItem_actionPerformed();
        } else if (source == this.sequenceName) {
            this.editName();
        } else if (source == this.makeReferenceSeq) {
            this.makeReferenceSeq_actionPerformed();
        } else if (source == this.sequenceDetails) {
            this.showSequenceDetails();
        } else if (source == this.selSeqDetails) {
            this.showSequenceSelectionDetails();
        } else if (source == this.pdb) {
            this.addPDB();
        } else if (source == this.hideSeqs) {
            this.hideSequences(false);
        } else if (source == this.repGroup) {
            this.hideSequences(true);
        } else if (source == this.revealSeq) {
            this.ap.av.showSequence(this.revealSeq_index);
        } else if (source == this.revealAll) {
            this.ap.av.showAllHiddenSeqs();
        } else if (source == this.editGroupName) {
            EditNameDialog dialog = new EditNameDialog(this.getGroup().getName(), this.getGroup().getDescription(), "       Group Name", "Group Description", this.ap.alignFrame, "Edit Group Name / Description", 500, 100, true);
            if (dialog.accept) {
                this.getGroup().setName(dialog.getName().replace(' ', '_'));
                this.getGroup().setDescription(dialog.getDescription());
            }
        } else if (source == this.copy) {
            this.ap.alignFrame.copy_actionPerformed();
        } else if (source == this.cut) {
            this.ap.alignFrame.cut_actionPerformed();
        } else if (source == this.editSequence) {
            SequenceGroup sg = this.ap.av.getSelectionGroup();
            if (sg != null) {
                if (this.seq == null) {
                    this.seq = sg.getSequenceAt(0);
                }
                EditNameDialog dialog = new EditNameDialog(this.seq.getSequenceAsString(sg.getStartRes(), sg.getEndRes() + 1), null, "Edit Sequence ", null, this.ap.alignFrame, "Edit Sequence", 500, 100, true);
                if (dialog.accept) {
                    EditCommand editCommand = new EditCommand(MessageManager.getString("label.edit_sequences"), EditCommand.Action.REPLACE, dialog.getName().replace(' ', this.ap.av.getGapCharacter()), sg.getSequencesAsArray(this.ap.av.getHiddenRepSequences()), sg.getStartRes(), sg.getEndRes() + 1, this.ap.av.getAlignment());
                    this.ap.alignFrame.addHistoryItem(editCommand);
                    this.ap.av.notifyAlignment();
                }
            }
        } else if (source == this.toUpper || source == this.toLower || source == this.toggleCase) {
            SequenceGroup sg = this.ap.av.getSelectionGroup();
            if (sg != null) {
                int caseChange;
                String description;
                List<int[]> startEnd = this.ap.av.getVisibleRegionBoundaries(sg.getStartRes(), sg.getEndRes() + 1);
                if (source == this.toggleCase) {
                    description = "Toggle Case";
                    caseChange = ChangeCaseCommand.TOGGLE_CASE;
                } else if (source == this.toUpper) {
                    description = "To Upper Case";
                    caseChange = ChangeCaseCommand.TO_UPPER;
                } else {
                    description = "To Lower Case";
                    caseChange = ChangeCaseCommand.TO_LOWER;
                }
                ChangeCaseCommand caseCommand = new ChangeCaseCommand(description, sg.getSequencesAsArray(this.ap.av.getHiddenRepSequences()), startEnd, caseChange);
                this.ap.alignFrame.addHistoryItem(caseCommand);
                this.ap.av.notifyAlignment();
            }
        } else if (source == this.sequenceFeature) {
            SequenceGroup sg = this.ap.av.getSelectionGroup();
            if (sg == null) {
                return;
            }
            int gSize = sg.getSize();
            ArrayList<SequenceI> seqs = new ArrayList<SequenceI>();
            ArrayList<SequenceFeature> features = new ArrayList<SequenceFeature>();
            for (int i = 0; i < gSize; ++i) {
                int end;
                int start = sg.getSequenceAt(i).findPosition(sg.getStartRes());
                if (start > (end = sg.findEndRes(sg.getSequenceAt(i)))) continue;
                seqs.add(sg.getSequenceAt(i));
                features.add(new SequenceFeature(null, null, start, end, "Jalview"));
            }
            if (!seqs.isEmpty() && this.ap.seqPanel.seqCanvas.getFeatureRenderer().amendFeatures(seqs, features, true, this.ap)) {
                this.ap.alignFrame.sequenceFeatures.setState(true);
                this.ap.av.setShowSequenceFeatures(true);
                this.ap.av.setSearchResults(null);
                this.ap.repaint();
            }
        } else {
            this.outputText(evt);
        }
    }

    void outputText(ActionEvent e) {
        CutAndPasteTransfer cap = new CutAndPasteTransfer(true, this.ap.alignFrame);
        Frame frame = new Frame();
        frame.add(cap);
        JalviewLite.addFrame(frame, MessageManager.formatMessage("label.selection_output_command", e.getActionCommand()), 600, 500);
        FileFormatI fileFormat = FileFormats.getInstance().forName(e.getActionCommand());
        cap.setText(new AppletFormatAdapter().formatSequences(fileFormat, this.ap.av.getShowJVSuffix(), this.ap, true));
    }

    protected void showSequenceSelectionDetails() {
        this.createSequenceDetailsReport(this.ap.av.getSequenceSelection());
    }

    protected void showSequenceDetails() {
        this.createSequenceDetailsReport(new SequenceI[]{this.seq});
    }

    public void createSequenceDetailsReport(SequenceI[] sequences) {
        CutAndPasteTransfer cap = new CutAndPasteTransfer(false, this.ap.alignFrame);
        StringBuilder contents = new StringBuilder(128);
        for (SequenceI seq : sequences) {
            contents.append(MessageManager.formatMessage("label.annotation_for_displayid", seq.getDisplayId(true)));
            new SequenceAnnotationReport(false).createSequenceAnnotationReport(contents, seq, true, true, this.ap.seqPanel.seqCanvas.fr);
            contents.append("</p>");
        }
        Frame frame = new Frame();
        frame.add(cap);
        JalviewLite.addFrame(frame, "Sequence Details for " + (sequences.length == 1 ? sequences[0].getDisplayId(true) : "Selection"), 600, 500);
        cap.setText(MessageManager.formatMessage("label.html_content", contents.toString()));
    }

    void editName() {
        EditNameDialog dialog = new EditNameDialog(this.seq.getName(), this.seq.getDescription(), "       Sequence Name", "Sequence Description", this.ap.alignFrame, "Edit Sequence Name / Description", 500, 100, true);
        if (dialog.accept) {
            this.seq.setName(dialog.getName());
            this.seq.setDescription(dialog.getDescription());
            this.ap.paintAlignment(false, false);
        }
    }

    void addPDB() {
        Vector<PDBEntry> pdbs = this.seq.getAllPDBEntries();
        if (pdbs != null && !pdbs.isEmpty()) {
            PDBEntry entry = pdbs.firstElement();
            if (this.ap.av.applet.jmolAvailable) {
                new AppletJmol(entry, new SequenceI[]{this.seq}, null, this.ap, DataSourceType.URL);
            } else {
                new AppletPDBViewer(entry, new SequenceI[]{this.seq}, null, this.ap, DataSourceType.URL);
            }
        } else {
            CutAndPasteTransfer cap = new CutAndPasteTransfer(true, this.ap.alignFrame);
            cap.setText(MessageManager.getString("label.paste_pdb_file"));
            cap.setPDBImport(this.seq);
            Frame frame = new Frame();
            frame.add(cap);
            JalviewLite.addFrame(frame, MessageManager.formatMessage("label.paste_pdb_file_for_sequence", this.seq.getName()), 400, 300);
        }
    }

    private void jbInit() throws Exception {
        this.groupMenu.setLabel(MessageManager.getString("label.selection"));
        this.sequenceFeature.addActionListener(this);
        this.editGroupName.addActionListener(this);
        this.unGroupMenuItem.setLabel(MessageManager.getString("action.remove_group"));
        this.unGroupMenuItem.addActionListener(this);
        this.createGroupMenuItem.setLabel(MessageManager.getString("action.create_group"));
        this.createGroupMenuItem.addActionListener(this);
        this.modifyPID.setEnabled(this.abovePIDColour.getState());
        this.modifyConservation.setEnabled(this.conservationColour.getState());
        this.colourMenu.setLabel(MessageManager.getString("label.group_colour"));
        this.showBoxes.setLabel(MessageManager.getString("action.boxes"));
        this.showBoxes.setState(true);
        this.showBoxes.addItemListener(this);
        this.sequenceName.addActionListener(this);
        this.sequenceDetails.addActionListener(this);
        this.selSeqDetails.addActionListener(this);
        this.displayNonconserved.setLabel(MessageManager.getString("label.show_non_conserved"));
        this.displayNonconserved.setState(false);
        this.displayNonconserved.addItemListener(this);
        this.showText.setLabel(MessageManager.getString("action.text"));
        this.showText.addItemListener(this);
        this.showColourText.setLabel(MessageManager.getString("label.colour_text"));
        this.showColourText.addItemListener(this);
        this.outputmenu.setLabel(MessageManager.getString("label.out_to_textbox"));
        this.seqMenu.setLabel(MessageManager.getString("label.sequence"));
        this.pdb.setLabel(MessageManager.getString("label.view_pdb_structure"));
        this.hideSeqs.setLabel(MessageManager.getString("action.hide_sequences"));
        this.repGroup.setLabel(MessageManager.formatMessage("label.represent_group_with", ""));
        this.revealAll.setLabel(MessageManager.getString("action.reveal_all"));
        this.revealSeq.setLabel(MessageManager.getString("action.reveal_sequences"));
        this.menu1.setLabel(MessageManager.getString("label.group:"));
        this.add(this.groupMenu);
        this.add(this.seqMenu);
        this.add(this.hideSeqs);
        this.add(this.revealSeq);
        this.add(this.revealAll);
        this.groupMenu.add(this.groupShowAnnotationsMenu);
        this.groupMenu.add(this.groupHideAnnotationsMenu);
        this.groupMenu.add(this.groupAddReferenceAnnotations);
        this.groupMenu.add(this.editMenu);
        this.groupMenu.add(this.outputmenu);
        this.groupMenu.add(this.sequenceFeature);
        this.groupMenu.add(this.createGroupMenuItem);
        this.groupMenu.add(this.unGroupMenuItem);
        this.groupMenu.add(this.menu1);
        this.colourMenu.add(this.noColour);
        this.colourMenu.add(this.clustalColour);
        this.colourMenu.add(this.BLOSUM62Colour);
        this.colourMenu.add(this.PIDColour);
        this.colourMenu.add(this.zappoColour);
        this.colourMenu.add(this.taylorColour);
        this.colourMenu.add(this.hydrophobicityColour);
        this.colourMenu.add(this.helixColour);
        this.colourMenu.add(this.strandColour);
        this.colourMenu.add(this.turnColour);
        this.colourMenu.add(this.buriedColour);
        this.colourMenu.add(this.nucleotideColour);
        this.colourMenu.add(this.purinePyrimidineColour);
        this.colourMenu.add(this.userDefinedColour);
        this.colourMenu.addSeparator();
        this.colourMenu.add(this.conservationColour);
        this.colourMenu.add(this.modifyConservation);
        this.colourMenu.add(this.abovePIDColour);
        this.colourMenu.add(this.modifyPID);
        this.noColour.setLabel(MessageManager.getString("label.none"));
        this.noColour.addItemListener(this);
        this.clustalColour.setLabel(MessageManager.getString("label.colourScheme_clustal"));
        this.clustalColour.setName(JalviewColourScheme.Clustal.toString());
        this.clustalColour.addItemListener(this);
        this.BLOSUM62Colour.setLabel(MessageManager.getString("label.colourScheme_blosum62"));
        this.BLOSUM62Colour.setName(JalviewColourScheme.Blosum62.toString());
        this.BLOSUM62Colour.addItemListener(this);
        this.PIDColour.setLabel(MessageManager.getString("label.colourScheme_%identity"));
        this.PIDColour.setName(JalviewColourScheme.PID.toString());
        this.PIDColour.addItemListener(this);
        this.zappoColour.setLabel(MessageManager.getString("label.colourScheme_zappo"));
        this.zappoColour.setName(JalviewColourScheme.Zappo.toString());
        this.zappoColour.addItemListener(this);
        this.taylorColour.setLabel(MessageManager.getString("label.colourScheme_taylor"));
        this.taylorColour.setName(JalviewColourScheme.Taylor.toString());
        this.taylorColour.addItemListener(this);
        this.hydrophobicityColour.setLabel(MessageManager.getString("label.colourScheme_hydrophobic"));
        this.hydrophobicityColour.setName(JalviewColourScheme.Hydrophobic.toString());
        this.hydrophobicityColour.addItemListener(this);
        this.helixColour.setLabel(MessageManager.getString("label.colourScheme_helixpropensity"));
        this.helixColour.setName(JalviewColourScheme.Helix.toString());
        this.helixColour.addItemListener(this);
        this.strandColour.setLabel(MessageManager.getString("label.colourScheme_strandpropensity"));
        this.strandColour.setName(JalviewColourScheme.Strand.toString());
        this.strandColour.addItemListener(this);
        this.turnColour.setLabel(MessageManager.getString("label.colourScheme_turnpropensity"));
        this.turnColour.setName(JalviewColourScheme.Turn.toString());
        this.turnColour.addItemListener(this);
        this.buriedColour.setLabel(MessageManager.getString("label.colourScheme_buriedindex"));
        this.buriedColour.setName(JalviewColourScheme.Buried.toString());
        this.buriedColour.addItemListener(this);
        this.nucleotideColour.setLabel(MessageManager.getString("label.colourScheme_nucleotide"));
        this.nucleotideColour.setName(JalviewColourScheme.Nucleotide.toString());
        this.nucleotideColour.addItemListener(this);
        this.purinePyrimidineColour.setLabel(MessageManager.getString("label.colourScheme_purine/pyrimidine"));
        this.purinePyrimidineColour.setName(JalviewColourScheme.PurinePyrimidine.toString());
        this.purinePyrimidineColour.addItemListener(this);
        this.userDefinedColour.setLabel(MessageManager.getString("action.user_defined"));
        this.userDefinedColour.addActionListener(this);
        this.abovePIDColour.setLabel(MessageManager.getString("label.above_identity_threshold"));
        this.abovePIDColour.addItemListener(this);
        this.modifyPID.setLabel(MessageManager.getString("label.modify_identity_threshold"));
        this.modifyPID.addActionListener(this);
        this.conservationColour.setLabel(MessageManager.getString("action.by_conservation"));
        this.conservationColour.addItemListener(this);
        this.modifyConservation.setLabel(MessageManager.getString("label.modify_conservation_threshold"));
        this.modifyConservation.addActionListener(this);
        this.PIDColour.addActionListener(this);
        this.BLOSUM62Colour.addActionListener(this);
        this.editMenu.add(this.copy);
        this.copy.addActionListener(this);
        this.editMenu.add(this.cut);
        this.cut.addActionListener(this);
        this.editMenu.add(this.editSequence);
        this.editSequence.addActionListener(this);
        this.editMenu.add(this.toUpper);
        this.toUpper.addActionListener(this);
        this.editMenu.add(this.toLower);
        this.toLower.addActionListener(this);
        this.editMenu.add(this.toggleCase);
        this.seqMenu.add(this.seqShowAnnotationsMenu);
        this.seqMenu.add(this.seqHideAnnotationsMenu);
        this.seqMenu.add(this.seqAddReferenceAnnotations);
        this.seqMenu.add(this.sequenceName);
        this.seqMenu.add(this.makeReferenceSeq);
        if (!this.ap.av.applet.useXtrnalSviewer) {
            this.seqMenu.add(this.pdb);
        }
        this.seqMenu.add(this.repGroup);
        this.menu1.add(this.editGroupName);
        this.menu1.add(this.colourMenu);
        this.menu1.add(this.showBoxes);
        this.menu1.add(this.showText);
        this.menu1.add(this.showColourText);
        this.menu1.add(this.displayNonconserved);
        this.toggleCase.addActionListener(this);
        this.pdb.addActionListener(this);
        this.hideSeqs.addActionListener(this);
        this.repGroup.addActionListener(this);
        this.revealAll.addActionListener(this);
        this.revealSeq.addActionListener(this);
        this.makeReferenceSeq.addActionListener(this);
    }

    void refresh() {
        this.ap.paintAlignment(true, true);
    }

    protected void clustalColour_actionPerformed() {
        SequenceGroup sg = this.getGroup();
        sg.cs = new ResidueShader(new ClustalxColourScheme(sg, this.ap.av.getHiddenRepSequences()));
        this.refresh();
    }

    protected void zappoColour_actionPerformed() {
        this.getGroup().cs = new ResidueShader(new ZappoColourScheme());
        this.refresh();
    }

    protected void taylorColour_actionPerformed() {
        this.getGroup().cs = new ResidueShader(new TaylorColourScheme());
        this.refresh();
    }

    protected void hydrophobicityColour_actionPerformed() {
        this.getGroup().cs = new ResidueShader(new HydrophobicColourScheme());
        this.refresh();
    }

    protected void helixColour_actionPerformed() {
        this.getGroup().cs = new ResidueShader(new HelixColourScheme());
        this.refresh();
    }

    protected void strandColour_actionPerformed() {
        this.getGroup().cs = new ResidueShader(new StrandColourScheme());
        this.refresh();
    }

    protected void turnColour_actionPerformed() {
        this.getGroup().cs = new ResidueShader(new TurnColourScheme());
        this.refresh();
    }

    protected void buriedColour_actionPerformed() {
        this.getGroup().cs = new ResidueShader(new BuriedColourScheme());
        this.refresh();
    }

    public void nucleotideMenuItem_actionPerformed() {
        this.getGroup().cs = new ResidueShader(new NucleotideColourScheme());
        this.refresh();
    }

    public void purinePyrimidineColour_actionPerformed() {
        this.getGroup().cs = new ResidueShader(new PurinePyrimidineColourScheme());
        this.refresh();
    }

    protected void abovePIDColour_itemStateChanged() {
        SequenceGroup sg = this.getGroup();
        if (sg.cs == null) {
            return;
        }
        if (this.abovePIDColour.getState()) {
            sg.cs.setConsensus(AAFrequency.calculate(sg.getSequences(this.ap.av.getHiddenRepSequences()), 0, this.ap.av.getAlignment().getWidth()));
            int threshold = SliderPanel.setPIDSliderSource(this.ap, sg.cs, this.getGroup().getName());
            sg.cs.setThreshold(threshold, this.ap.av.isIgnoreGapsConsensus());
            SliderPanel.showPIDSlider();
        } else {
            SliderPanel.hidePIDSlider();
            sg.cs.setThreshold(0, this.ap.av.isIgnoreGapsConsensus());
        }
        this.modifyPID.setEnabled(this.abovePIDColour.getState());
        this.refresh();
    }

    protected void userDefinedColour_actionPerformed() {
        new UserDefinedColours(this.ap, this.getGroup());
    }

    protected void PIDColour_actionPerformed() {
        SequenceGroup sg = this.getGroup();
        sg.cs = new ResidueShader(new PIDColourScheme());
        sg.cs.setConsensus(AAFrequency.calculate(sg.getSequences(this.ap.av.getHiddenRepSequences()), 0, this.ap.av.getAlignment().getWidth()));
        this.refresh();
    }

    protected void BLOSUM62Colour_actionPerformed() {
        SequenceGroup sg = this.getGroup();
        sg.cs = new ResidueShader(new Blosum62ColourScheme());
        sg.cs.setConsensus(AAFrequency.calculate(sg.getSequences(this.ap.av.getHiddenRepSequences()), 0, this.ap.av.getAlignment().getWidth()));
        this.refresh();
    }

    protected void noColourmenuItem_actionPerformed() {
        this.getGroup().cs = null;
        this.refresh();
    }

    protected void conservationMenuItem_itemStateChanged() {
        SequenceGroup sg = this.getGroup();
        if (sg.cs == null) {
            return;
        }
        if (this.conservationColour.getState()) {
            Conservation conservation = Conservation.calculateConservation("Group", sg.getSequences(this.ap.av.getHiddenRepSequences()), 0, this.ap.av.getAlignment().getWidth(), false, this.ap.av.getConsPercGaps(), false);
            sg.getGroupColourScheme().setConservation(conservation);
            SliderPanel.setConservationSlider(this.ap, sg.cs, sg.getName());
            SliderPanel.showConservationSlider();
        } else {
            SliderPanel.hideConservationSlider();
            sg.cs.setConservation(null);
        }
        this.modifyConservation.setEnabled(this.conservationColour.getState());
        this.refresh();
    }

    SequenceGroup getGroup() {
        SequenceGroup sg = this.ap.av.getSelectionGroup();
        if (sg != null) {
            this.ap.av.getAlignment().addGroup(sg);
        }
        return sg;
    }

    void unGroupMenuItem_actionPerformed() {
        SequenceGroup sg = this.ap.av.getSelectionGroup();
        this.ap.av.getAlignment().deleteGroup(sg);
        this.ap.av.setSelectionGroup(null);
        this.ap.paintAlignment(true, true);
    }

    void createGroupMenuItem_actionPerformed() {
        this.getGroup();
        this.refresh();
    }

    public void showColourText_itemStateChanged() {
        this.getGroup().setColourText(this.showColourText.getState());
        this.refresh();
    }

    public void showText_itemStateChanged() {
        this.getGroup().setDisplayText(this.showText.getState());
        this.refresh();
    }

    public void makeReferenceSeq_actionPerformed() {
        if (!this.ap.av.getAlignment().hasSeqrep()) {
            this.ap.av.setDisplayReferenceSeq(true);
            this.ap.av.setColourByReferenceSeq(true);
            this.ap.av.getAlignment().setSeqrep(this.seq);
        } else if (this.ap.av.getAlignment().getSeqrep() == this.seq) {
            this.ap.av.getAlignment().setSeqrep(null);
        } else {
            this.ap.av.getAlignment().setSeqrep(this.seq);
        }
        this.refresh();
    }

    public void showNonconserved_itemStateChanged() {
        this.getGroup().setShowNonconserved(this.displayNonconserved.getState());
        this.refresh();
    }

    public void showBoxes_itemStateChanged() {
        this.getGroup().setDisplayBoxes(this.showBoxes.getState());
        this.refresh();
    }

    void hideSequences(boolean representGroup) {
        this.ap.av.hideSequences(this.seq, representGroup);
    }

    protected void buildAnnotationTypesMenus(Menu showMenu, Menu hideMenu, List<SequenceI> forSequences) {
        showMenu.removeAll();
        hideMenu.removeAll();
        List<String> all = Arrays.asList(MessageManager.getString("label.all"));
        this.addAnnotationTypeToShowHide(showMenu, forSequences, "", all, true, true);
        this.addAnnotationTypeToShowHide(hideMenu, forSequences, "", all, true, false);
        showMenu.addSeparator();
        hideMenu.addSeparator();
        AlignmentAnnotation[] annotations = this.ap.getAlignment().getAlignmentAnnotation();
        LinkedHashMap<String, List<List<String>>> shownTypes = new LinkedHashMap<String, List<List<String>>>();
        LinkedHashMap<String, List<List<String>>> hiddenTypes = new LinkedHashMap<String, List<List<String>>>();
        AlignmentAnnotationUtils.getShownHiddenTypes(shownTypes, hiddenTypes, AlignmentAnnotationUtils.asList(annotations), forSequences);
        for (String calcId : hiddenTypes.keySet()) {
            for (List type : (List)hiddenTypes.get(calcId)) {
                this.addAnnotationTypeToShowHide(showMenu, forSequences, calcId, type, false, true);
            }
        }
        showMenu.setEnabled(!hiddenTypes.isEmpty());
        for (String calcId : shownTypes.keySet()) {
            for (List type : (List)shownTypes.get(calcId)) {
                this.addAnnotationTypeToShowHide(hideMenu, forSequences, calcId, type, false, false);
            }
        }
        hideMenu.setEnabled(!shownTypes.isEmpty());
    }

    protected void addAnnotationTypeToShowHide(Menu showOrHideMenu, final List<SequenceI> forSequences, String calcId, final List<String> types, final boolean allTypes, final boolean actionIsShow) {
        String label = types.toString();
        label = label.substring(1, label.length() - 1);
        MenuItem item = new MenuItem(label);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlignmentUtils.showOrHideSequenceAnnotations(APopupMenu.this.ap.getAlignment(), types, forSequences, allTypes, actionIsShow);
                APopupMenu.this.refresh();
            }
        });
        showOrHideMenu.add(item);
    }
}

