/*
 * Decompiled with CFR 0.152.
 */
package jalview.analysis;

import jalview.datamodel.BinaryNode;
import jalview.math.MatrixI;
import java.util.BitSet;
import java.util.Vector;

public abstract class TreeEngine {
    protected Vector<BitSet> clusters;
    protected BitSet done;
    protected int noseqs;
    protected int noClus;
    protected MatrixI distances;
    protected double ri;
    protected double rj;
    protected Vector<BinaryNode> node;
    BinaryNode maxdist;
    double maxDistValue;
    protected int mini;
    protected int minj;
    protected BinaryNode top;
    protected int ycount;
    double maxheight;

    protected double findr(int i, int j) {
        double tmp = 1.0;
        for (int k = 0; k < this.noseqs; ++k) {
            if (k == i || k == j || this.done.get(k)) continue;
            tmp += this.distances.getValue(i, k);
        }
        if (this.noClus > 2) {
            tmp /= (double)(this.noClus - 2);
        }
        return tmp;
    }

    protected void joinClusters(int i, int j) {
        double dist = this.distances.getValue(i, j);
        this.ri = this.findr(i, j);
        this.rj = this.findr(j, i);
        this.findClusterDistance(i, j);
        BinaryNode sn = new BinaryNode();
        sn.setLeft(this.node.elementAt(i));
        sn.setRight(this.node.elementAt(j));
        BinaryNode tmpi = this.node.elementAt(i);
        BinaryNode tmpj = this.node.elementAt(j);
        this.findNewDistances(tmpi, tmpj, dist);
        tmpi.setParent(sn);
        tmpj.setParent(sn);
        this.node.setElementAt(sn, i);
        this.clusters.get(i).or(this.clusters.get(j));
        this.clusters.get(j).clear();
        this.done.set(j);
    }

    protected abstract void findNewDistances(BinaryNode var1, BinaryNode var2, double var3);

    protected abstract void findClusterDistance(int var1, int var2);

    protected void findMaxDist(BinaryNode nd) {
        if (nd == null) {
            return;
        }
        if (nd.left() == null && nd.right() == null) {
            double dist = nd.dist;
            if (dist > this.maxDistValue) {
                this.maxdist = nd;
                this.maxDistValue = dist;
            }
        } else {
            this.findMaxDist(nd.left());
            this.findMaxDist(nd.right());
        }
    }

    protected void cluster() {
        while (this.noClus > 2) {
            this.findMinDistance();
            this.joinClusters(this.mini, this.minj);
            --this.noClus;
        }
        int rightChild = this.done.nextClearBit(0);
        int leftChild = this.done.nextClearBit(rightChild + 1);
        this.joinClusters(leftChild, rightChild);
        this.top = this.node.elementAt(leftChild);
        this.reCount(this.top);
        this.findHeight(this.top);
        this.findMaxDist(this.top);
    }

    protected abstract double findMinDistance();

    protected void _reCount(BinaryNode nd) {
        if (nd == null) {
            return;
        }
        if (nd.left() != null && nd.right() != null) {
            this._reCount(nd.left());
            this._reCount(nd.right());
            BinaryNode l = nd.left();
            BinaryNode r = nd.right();
            nd.count = l.count + r.count;
            nd.ycount = (l.ycount + r.ycount) / 2.0f;
        } else {
            nd.count = 1;
            nd.ycount = this.ycount++;
        }
    }

    double findHeight(BinaryNode nd) {
        if (nd == null) {
            return this.maxheight;
        }
        if (nd.left() == null && nd.right() == null) {
            nd.height = nd.parent().height + nd.dist;
            if (nd.height > this.maxheight) {
                return nd.height;
            }
            return this.maxheight;
        }
        if (nd.parent() != null) {
            nd.height = nd.parent().height + nd.dist;
        } else {
            this.maxheight = 0.0;
            nd.height = 0.0;
        }
        this.maxheight = this.findHeight(nd.left());
        this.maxheight = this.findHeight(nd.right());
        return this.maxheight;
    }

    void reCount(BinaryNode nd) {
        this.ycount = 0;
        this._reCount(nd);
    }

    public BinaryNode getTopNode() {
        return this.top;
    }
}

