/*
 * Decompiled with CFR 0.152.
 */
package compbio.metadata;

import compbio.metadata.Option;
import compbio.metadata.Parameter;
import compbio.util.SysPrefs;
import compbio.util.annotation.NotThreadSafe;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.ValidationException;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement
@NotThreadSafe
public class RunnerConfig<T> {
    private String runnerClassName;
    List<Option<T>> options = new ArrayList<Option<T>>();
    String prmSeparator;
    List<Parameter<T>> parameters = new ArrayList<Parameter<T>>();
    @XmlTransient
    List<Option<T>> arguments;

    public RunnerConfig<T> copyAndValidateRConfig(RunnerConfig<?> runnerConf) {
        if (this.runnerClassName != runnerConf.runnerClassName) {
            throw new InvalidParameterException("Wrong runner configuration! ");
        }
        RunnerConfig<T> newrconfig = new RunnerConfig<T>();
        newrconfig.runnerClassName = runnerConf.runnerClassName;
        newrconfig.options = new ArrayList<Option<T>>(this.options);
        return newrconfig;
    }

    public List<Option<T>> getOptions() {
        return this.options;
    }

    public void addParameter(Parameter<T> param) {
        assert (param != null);
        this.parameters.add(param);
    }

    public void addOption(Option<T> option) {
        assert (option != null);
        this.options.add(option);
    }

    @XmlTransient
    public List<Option<T>> getArguments() {
        this.arguments = new ArrayList<Option<T>>(this.options);
        this.arguments.addAll(this.parameters);
        return this.arguments;
    }

    public String getPrmSeparator() {
        return this.prmSeparator;
    }

    public void setPrmSeparator(String prmSeparator) {
        this.prmSeparator = prmSeparator;
    }

    public void setOptions(List<Option<T>> parameters) {
        this.options = parameters;
    }

    @XmlElement(required=true)
    public String getRunnerClassName() {
        return this.runnerClassName;
    }

    public void setRunnerClassName(String runnerClassName) {
        this.runnerClassName = runnerClassName;
    }

    public void setParameters(List<Parameter<T>> parameters) {
        this.parameters = parameters;
    }

    public List<Parameter<T>> getParameters() {
        return this.parameters;
    }

    public String toString() {
        String value = "Runner: " + this.runnerClassName + SysPrefs.newlinechar;
        for (Option<T> par : this.getArguments()) {
            value = value + par;
        }
        return value;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        RunnerConfig rconf = null;
        if (obj instanceof RunnerConfig) {
            rconf = (RunnerConfig)obj;
        }
        if (!rconf.runnerClassName.equals(this.runnerClassName)) {
            return false;
        }
        if (this.options.size() != rconf.options.size()) {
            return false;
        }
        if (this.parameters.size() != rconf.parameters.size()) {
            return false;
        }
        if (!this.prmSeparator.equals(rconf.prmSeparator)) {
            return false;
        }
        for (Option<T> option : this.options) {
            Option<T> roption = rconf.getArgument(option.getName());
            if (roption == null) {
                return false;
            }
            if (option.equals(roption)) continue;
            return false;
        }
        for (Parameter parameter : this.parameters) {
            Parameter rpar = (Parameter)rconf.getArgument(parameter.getName());
            if (rpar == null) {
                return false;
            }
            if (parameter.equals(rpar)) continue;
            return false;
        }
        return true;
    }

    public Option<T> getArgument(String name) {
        for (Option<T> par : this.getArguments()) {
            if (!par.getName().equalsIgnoreCase(name)) continue;
            return par;
        }
        return null;
    }

    public boolean removeArgument(String name) {
        Option<T> par = this.getArgument(name);
        if (par != null) {
            if (par instanceof Parameter) {
                this.parameters.remove(par);
                return true;
            }
            this.options.remove(par);
            return true;
        }
        return false;
    }

    public Option<T> getArgumentByOptionName(String optionName) {
        for (Option<T> opt : this.getArguments()) {
            for (String val : opt.getOptionNames()) {
                if (!val.equalsIgnoreCase(optionName)) continue;
                return opt;
            }
        }
        return null;
    }

    public boolean removeArgumentByOptionName(String optionName) {
        Option<T> par = this.getArgumentByOptionName(optionName);
        if (par != null) {
            if (par instanceof Parameter) {
                this.parameters.remove(par);
                return true;
            }
            this.options.remove(par);
            return true;
        }
        return false;
    }

    public void validate() throws ValidationException {
        for (Option<T> option : this.getArguments()) {
            option.validate();
        }
    }
}

