/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.tools;

import com.threerings.getdown.data.Application;
import com.threerings.getdown.data.Digest;
import com.threerings.getdown.data.EnvConfig;
import com.threerings.getdown.data.Resource;
import com.threerings.getdown.util.Base64;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Signature;
import java.util.ArrayList;

public class Digester {
    public static void main(String[] args) throws IOException, GeneralSecurityException {
        switch (args.length) {
            case 1: {
                Digester.createDigests(new File(args[0]), null, null, null);
                break;
            }
            case 4: {
                Digester.createDigests(new File(args[0]), new File(args[1]), args[2], args[3]);
                break;
            }
            default: {
                System.err.println("Usage: Digester app_dir [keystore_path password alias]");
                System.exit(255);
            }
        }
    }

    public static void createDigests(File appdir, File keystore, String password, String alias) throws IOException, GeneralSecurityException {
        for (int version = 1; version <= 2; ++version) {
            Digester.createDigest(version, appdir);
            if (keystore == null) continue;
            Digester.signDigest(version, appdir, keystore, password, alias);
        }
    }

    public static void createDigest(int version, File appdir) throws IOException {
        File target = new File(appdir, Digest.digestFile(version));
        System.out.println("Generating digest file '" + target + "'...");
        Application app = new Application(new EnvConfig(appdir));
        app.init(false);
        ArrayList<Resource> rsrcs = new ArrayList<Resource>();
        rsrcs.add(app.getConfigResource());
        rsrcs.addAll(app.getCodeResources());
        rsrcs.addAll(app.getResources());
        for (Application.AuxGroup ag : app.getAuxGroups()) {
            rsrcs.addAll(ag.codes);
            rsrcs.addAll(ag.rsrcs);
        }
        Digest.createDigest(version, rsrcs, target);
    }

    public static void signDigest(int version, File appdir, File storePath, String storePass, String storeAlias) throws IOException, GeneralSecurityException {
        String filename = Digest.digestFile(version);
        File inputFile = new File(appdir, filename);
        File signatureFile = new File(appdir, filename + ".sig");
        try (FileInputStream storeInput = new FileInputStream(storePath);
             FileInputStream dataInput = new FileInputStream(inputFile);
             FileOutputStream signatureOutput = new FileOutputStream(signatureFile);){
            int length;
            KeyStore store = KeyStore.getInstance("JKS");
            store.load(storeInput, storePass.toCharArray());
            PrivateKey key = (PrivateKey)store.getKey(storeAlias, storePass.toCharArray());
            String algo = Digest.sigAlgorithm(version);
            Signature sig = Signature.getInstance(algo);
            byte[] buffer = new byte[8192];
            sig.initSign(key);
            while ((length = dataInput.read(buffer)) != -1) {
                sig.update(buffer, 0, length);
            }
            String signed = Base64.encodeToString(sig.sign(), 0);
            signatureOutput.write(signed.getBytes(StandardCharsets.UTF_8));
        }
    }
}

