/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.templates;

import fr.orsay.lri.varna.models.templates.RNANodeValueTemplate;
import fr.orsay.lri.varna.models.templates.RNANodeValueTemplateBasePair;
import fr.orsay.lri.varna.models.templates.RNANodeValueTemplateBrokenBasePair;
import fr.orsay.lri.varna.models.templates.RNANodeValueTemplateSequence;
import fr.orsay.lri.varna.models.treealign.RNANodeValue;
import fr.orsay.lri.varna.models.treealign.RNANodeValue2;
import fr.orsay.lri.varna.models.treealign.TreeAlignLabelDistanceAsymmetric;

public class RNANodeValue2TemplateDistance
implements TreeAlignLabelDistanceAsymmetric<RNANodeValue2, RNANodeValueTemplate> {
    public double delete(RNANodeValue2 rNANodeValue2) {
        if (rNANodeValue2 == null) {
            return 0.0;
        }
        if (rNANodeValue2.isSingleNode()) {
            if (rNANodeValue2.getNode().getRightBasePosition() < 0) {
                return 1.0;
            }
            return 2.0;
        }
        return rNANodeValue2.getNodes().size();
    }

    public double insert(RNANodeValueTemplate rNANodeValueTemplate) {
        if (rNANodeValueTemplate == null) {
            return 0.0;
        }
        if (rNANodeValueTemplate instanceof RNANodeValueTemplateSequence) {
            return ((RNANodeValueTemplateSequence)rNANodeValueTemplate).getSequence().getLength();
        }
        if (rNANodeValueTemplate instanceof RNANodeValueTemplateBrokenBasePair) {
            return 1.0;
        }
        return 2.0;
    }

    @Override
    public double f(RNANodeValue2 rNANodeValue2, RNANodeValueTemplate rNANodeValueTemplate) {
        if (rNANodeValue2 == null) {
            return this.insert(rNANodeValueTemplate);
        }
        if (rNANodeValueTemplate == null) {
            return this.delete(rNANodeValue2);
        }
        if (!rNANodeValue2.isSingleNode()) {
            if (rNANodeValueTemplate instanceof RNANodeValueTemplateSequence) {
                return Math.abs(rNANodeValue2.getNodes().size() - ((RNANodeValueTemplateSequence)rNANodeValueTemplate).getSequence().getLength());
            }
            return Double.POSITIVE_INFINITY;
        }
        if (rNANodeValue2.getNode().getRightBasePosition() >= 0) {
            if (rNANodeValueTemplate instanceof RNANodeValueTemplateBasePair) {
                return 0.0;
            }
            return Double.POSITIVE_INFINITY;
        }
        if (rNANodeValueTemplate instanceof RNANodeValueTemplateBrokenBasePair) {
            boolean bl;
            RNANodeValueTemplateBrokenBasePair rNANodeValueTemplateBrokenBasePair = (RNANodeValueTemplateBrokenBasePair)rNANodeValueTemplate;
            boolean bl2 = rNANodeValueTemplateBrokenBasePair.getPositionInHelix() < rNANodeValueTemplateBrokenBasePair.getHelix().getLength();
            boolean bl3 = !bl2;
            boolean bl4 = rNANodeValue2.getNode().getOrigin() == RNANodeValue.Origin.BASE_FROM_HELIX_STRAND5;
            boolean bl5 = bl = rNANodeValue2.getNode().getOrigin() == RNANodeValue.Origin.BASE_FROM_HELIX_STRAND3;
            if (bl2 && bl4 || bl3 && bl) {
                return 0.0;
            }
            return Double.POSITIVE_INFINITY;
        }
        return Double.POSITIVE_INFINITY;
    }
}

