/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.rna;

import fr.orsay.lri.varna.models.VARNAConfig;
import fr.orsay.lri.varna.utils.XMLUtils;
import java.awt.Color;
import java.io.Serializable;
import javax.xml.transform.sax.TransformerHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ModeleBPStyle
implements Serializable {
    private static final long serialVersionUID = 3006493290669550139L;
    private boolean _isCustomColored = false;
    private Color _color = VARNAConfig.DEFAULT_BOND_COLOR;
    private double _thickness = -1.0;
    private double _bent = 0.0;
    public static String XML_ELEMENT_NAME = "BPstyle";
    public static String XML_VAR_CUSTOM_STYLED_NAME = "custom";
    public static String XML_VAR_COLOR_NAME = "color";
    public static String XML_VAR_THICKNESS_NAME = "thickness";
    public static String XML_VAR_BENT_NAME = "bent";

    public void toXML(TransformerHandler transformerHandler) throws SAXException {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "", XML_VAR_CUSTOM_STYLED_NAME, "CDATA", "" + this._isCustomColored);
        attributesImpl.addAttribute("", "", XML_VAR_COLOR_NAME, "CDATA", XMLUtils.toHTMLNotation(this._color));
        attributesImpl.addAttribute("", "", XML_VAR_THICKNESS_NAME, "CDATA", "" + this._thickness);
        attributesImpl.addAttribute("", "", XML_VAR_BENT_NAME, "CDATA", "" + this._bent);
        transformerHandler.startElement("", "", XML_ELEMENT_NAME, attributesImpl);
        transformerHandler.endElement("", "", XML_ELEMENT_NAME);
    }

    public double getBent() {
        return this._bent;
    }

    public boolean isBent() {
        return this._bent != 0.0;
    }

    public void setBent(double d) {
        this._bent = d;
    }

    public void setCustomColor(Color color) {
        this._isCustomColored = true;
        this._color = color;
    }

    public void useDefaultColor() {
        this._isCustomColored = false;
    }

    public boolean isCustomColored() {
        return this._isCustomColored;
    }

    public Color getCustomColor() {
        return this._color;
    }

    public Color getColor(Color color) {
        if (this.isCustomColored()) {
            return this._color;
        }
        return color;
    }

    public double getThickness(double d) {
        if (this._thickness > 0.0) {
            return this._thickness;
        }
        return d;
    }

    public void setThickness(double d) {
        this._thickness = d;
    }
}

