/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.applications.fragseq;

import fr.orsay.lri.varna.applications.fragseq.FragSeqAnnotationDataModel;
import fr.orsay.lri.varna.applications.fragseq.FragSeqModel;
import fr.orsay.lri.varna.applications.fragseq.FragSeqRNASecStrModel;
import fr.orsay.lri.varna.exceptions.ExceptionExportFailed;
import fr.orsay.lri.varna.exceptions.ExceptionFileFormatOrSyntax;
import fr.orsay.lri.varna.exceptions.ExceptionLoadingFailed;
import fr.orsay.lri.varna.exceptions.ExceptionPermissionDenied;
import fr.orsay.lri.varna.exceptions.ExceptionUnmatchedClosingParentheses;
import fr.orsay.lri.varna.factories.RNAFactory;
import fr.orsay.lri.varna.models.rna.RNA;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Random;
import java.util.regex.Pattern;

public class FragSeqFileModel
implements Comparable<FragSeqFileModel> {
    private ArrayList<FragSeqModel> _models = new ArrayList();
    protected Date _lastModified;
    protected boolean _outOfSync = false;
    protected String _caption = "";
    protected String _path = "";
    protected String _folder = "";
    protected boolean _cached = false;
    private static Random _rnd = new Random();

    public static Date lastModif(String string) {
        return new Date(new File(string).lastModified());
    }

    public FragSeqFileModel(String string, String string2) {
        this(string, string2, FragSeqFileModel.lastModif(string2));
    }

    public FragSeqFileModel(String string, String string2, Date date) {
        this._lastModified = date;
        this._outOfSync = false;
        this._folder = string;
        this._path = string2;
        String[] stringArray = string2.split(Pattern.quote(File.separator));
        if (stringArray.length > 0) {
            this._caption = stringArray[stringArray.length - 1];
        }
    }

    public void load() {
        ArrayList<RNA> arrayList = null;
        try {
            arrayList = this.createRNAs();
            for (RNA rNA : arrayList) {
                this.addModel(new FragSeqRNASecStrModel(rNA));
                int n = _rnd.nextInt(5);
                for (int i = 0; i < n; ++i) {
                    FragSeqAnnotationDataModel fragSeqAnnotationDataModel = new FragSeqAnnotationDataModel(rNA.getID(), "" + i + "-" + rNA.getID());
                    FragSeqAnnotationDataModel.addRandomAnnotations(rNA, fragSeqAnnotationDataModel);
                    this.addModel(fragSeqAnnotationDataModel);
                }
            }
        }
        catch (ExceptionUnmatchedClosingParentheses exceptionUnmatchedClosingParentheses) {
            exceptionUnmatchedClosingParentheses.printStackTrace();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (ExceptionFileFormatOrSyntax exceptionFileFormatOrSyntax) {
            exceptionFileFormatOrSyntax.printStackTrace();
        }
        catch (ExceptionExportFailed exceptionExportFailed) {
            exceptionExportFailed.printStackTrace();
        }
        catch (ExceptionPermissionDenied exceptionPermissionDenied) {
            exceptionPermissionDenied.printStackTrace();
        }
        catch (ExceptionLoadingFailed exceptionLoadingFailed) {
            exceptionLoadingFailed.printStackTrace();
        }
        this._cached = true;
    }

    public boolean hasChanged() {
        return this._outOfSync;
    }

    public boolean checkForModifications() {
        if (!FragSeqFileModel.lastModif(this._path).equals(this._lastModified) && !this._outOfSync) {
            this._outOfSync = true;
            return true;
        }
        return false;
    }

    public String toString() {
        return this._caption + (this._outOfSync ? "*" : "");
    }

    public String getCaption() {
        return this._caption;
    }

    public String getFolder() {
        return this._folder;
    }

    public String getPath() {
        return this._path;
    }

    @Override
    public int compareTo(FragSeqFileModel fragSeqFileModel) {
        return this._caption.compareTo(fragSeqFileModel._caption);
    }

    public ArrayList<FragSeqModel> getModels() {
        if (!this._cached) {
            this.load();
        }
        return this._models;
    }

    public void addModel(FragSeqModel fragSeqModel) {
        this._models.add(fragSeqModel);
    }

    private ArrayList<RNA> createRNAs() throws ExceptionUnmatchedClosingParentheses, ExceptionFileFormatOrSyntax, FileNotFoundException, ExceptionExportFailed, ExceptionPermissionDenied, ExceptionLoadingFailed {
        ArrayList<RNA> arrayList = RNAFactory.loadSecStr(this._path);
        for (RNA rNA : arrayList) {
            rNA.drawRNARadiate();
        }
        return new ArrayList<RNA>(arrayList);
    }
}

