/*
 * Decompiled with CFR 0.152.
 */
package io.github.warownia1.simplehttpclient.impl;

import io.github.warownia1.simplehttpclient.HttpRequest;
import io.github.warownia1.simplehttpclient.impl.ByteArrayRequestBody;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.ByteBuffer;

public class WWWFormURLEncodedRequestBodyBuilder {
    private ByteBuffer bodyBuffer = ByteBuffer.allocate(256);

    public WWWFormURLEncodedRequestBodyBuilder append(String key, String value) {
        byte[] encodedValue;
        byte[] encodedKey;
        try {
            encodedKey = URLEncoder.encode(key, "UTF-8").replaceAll("\\*", "%2A").getBytes("UTF-8");
            encodedValue = URLEncoder.encode(value, "UTF-8").replaceAll("\\*", "%2A").getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new UncheckedIOException(e);
        }
        if (encodedKey.length + encodedValue.length + 2 >= this.bodyBuffer.remaining()) {
            this.growBuffer(encodedKey.length + encodedValue.length + 2);
        }
        this.bodyBuffer.put((byte)38).put(encodedKey).put((byte)61).put(encodedValue);
        return this;
    }

    private void growBuffer(int requiredRemaining) {
        int capacity;
        int requiredCapacity = this.bodyBuffer.position() + requiredRemaining;
        for (capacity = this.bodyBuffer.capacity(); capacity <= requiredCapacity; capacity += capacity / 2) {
        }
        this.bodyBuffer.flip();
        ByteBuffer newBuffer = ByteBuffer.allocate(capacity);
        newBuffer.put(this.bodyBuffer);
        this.bodyBuffer = newBuffer;
    }

    public HttpRequest.Body build() {
        ByteBuffer buffer = this.bodyBuffer.duplicate();
        buffer.flip();
        if (buffer.limit() > 0) {
            buffer.get();
        }
        return new ByteArrayRequestBody(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
    }
}

