/*
 * Decompiled with CFR 0.152.
 */
package mc_view;

public class MCMatrix {
    float[][] matrix;
    float[][] tmp;
    float mycos;
    float mysin;
    float myconst = (float)Math.PI / 180;

    public MCMatrix(int rows, int cols) {
        this.matrix = new float[rows][cols];
        this.tmp = new float[rows][cols];
    }

    public void addElement(int i, int j, float value) {
        this.matrix[i][j] = value;
    }

    public void rotatex(float degrees) {
        this.mycos = (float)Math.cos(degrees * this.myconst);
        this.mysin = (float)Math.sin(degrees * this.myconst);
        this.tmp[0][0] = 1.0f;
        this.tmp[0][1] = 0.0f;
        this.tmp[0][2] = 0.0f;
        this.tmp[1][0] = 0.0f;
        this.tmp[1][1] = this.mycos;
        this.tmp[1][2] = this.mysin;
        this.tmp[2][0] = 0.0f;
        this.tmp[2][1] = -this.mysin;
        this.tmp[2][2] = this.mycos;
        this.preMultiply(this.tmp);
    }

    public void rotatez(float degrees) {
        this.mycos = (float)Math.cos(degrees * this.myconst);
        this.mysin = (float)Math.sin(degrees * this.myconst);
        this.tmp[0][0] = this.mycos;
        this.tmp[0][1] = -this.mysin;
        this.tmp[0][2] = 0.0f;
        this.tmp[1][0] = this.mysin;
        this.tmp[1][1] = this.mycos;
        this.tmp[1][2] = 0.0f;
        this.tmp[2][0] = 0.0f;
        this.tmp[2][1] = 0.0f;
        this.tmp[2][2] = 1.0f;
        this.preMultiply(this.tmp);
    }

    public void rotatey(float degrees) {
        this.mycos = (float)Math.cos(degrees * this.myconst);
        this.mysin = (float)Math.sin(degrees * this.myconst);
        this.tmp[0][0] = this.mycos;
        this.tmp[0][1] = 0.0f;
        this.tmp[0][2] = -this.mysin;
        this.tmp[1][0] = 0.0f;
        this.tmp[1][1] = 1.0f;
        this.tmp[1][2] = 0.0f;
        this.tmp[2][0] = this.mysin;
        this.tmp[2][1] = 0.0f;
        this.tmp[2][2] = this.mycos;
        this.preMultiply(this.tmp);
    }

    public float[] vectorMultiply(float[] vect) {
        float[] temp = new float[]{vect[0], vect[1], vect[2]};
        for (int i = 0; i < 3; ++i) {
            temp[i] = this.matrix[i][0] * vect[0] + this.matrix[i][1] * vect[1] + this.matrix[i][2] * vect[2];
        }
        vect[0] = temp[0];
        vect[1] = temp[1];
        vect[2] = temp[2];
        return vect;
    }

    public void preMultiply(float[][] mat) {
        int j;
        int i;
        float[][] tmp = new float[3][3];
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                tmp[i][j] = mat[i][0] * this.matrix[0][j] + mat[i][1] * this.matrix[1][j] + mat[i][2] * this.matrix[2][j];
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                this.matrix[i][j] = tmp[i][j];
            }
        }
    }

    public void postMultiply(float[][] mat) {
        int j;
        int i;
        float[][] tmp = new float[3][3];
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                tmp[i][j] = this.matrix[i][0] * mat[0][j] + this.matrix[i][1] * mat[1][j] + this.matrix[i][2] * mat[2][j];
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                this.matrix[i][j] = tmp[i][j];
            }
        }
    }

    public void setIdentity() {
        this.matrix[0][0] = 1.0f;
        this.matrix[1][1] = 1.0f;
        this.matrix[2][2] = 1.0f;
        this.matrix[0][1] = 0.0f;
        this.matrix[0][2] = 0.0f;
        this.matrix[1][0] = 0.0f;
        this.matrix[1][2] = 0.0f;
        this.matrix[2][0] = 0.0f;
        this.matrix[2][1] = 0.0f;
    }
}

