/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws2.client.api;

import jalview.bin.Cache;
import jalview.bin.Console;
import jalview.ws2.actions.api.ActionI;
import jalview.ws2.api.WebService;
import jalview.ws2.client.api.WebServiceDiscovererI;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractWebServiceDiscoverer
implements WebServiceDiscovererI {
    protected List<WebService<?>> services = List.of();
    private static final int END = 1;
    private static final int BEGIN = 2;
    private static final int AGAIN = 4;
    private final AtomicInteger state = new AtomicInteger(1);
    private CompletableFuture<List<WebService<?>>> discoveryTask = new CompletableFuture();
    private List<WebServiceDiscovererI.ServicesChangeListener> listeners = new ArrayList<WebServiceDiscovererI.ServicesChangeListener>();

    @Override
    public List<WebService<?>> getServices() {
        return this.services;
    }

    @Override
    public <A extends ActionI<?>> List<WebService<A>> getServices(Class<A> type) {
        ArrayList<WebService<A>> list = new ArrayList<WebService<A>>();
        for (WebService<?> service : this.services) {
            if (!service.getActionClass().equals(type)) continue;
            WebService<?> _service = service;
            list.add(_service);
        }
        return list;
    }

    @Override
    public List<URL> getUrls() {
        String key = this.getUrlsPropertyKey();
        if (key == null) {
            return List.of(this.getDefaultUrl());
        }
        String surls = Cache.getProperty(key);
        if (surls == null) {
            return List.of(this.getDefaultUrl());
        }
        String[] urls = surls.split(",");
        ArrayList<URL> valid = new ArrayList<URL>(urls.length);
        for (String url : urls) {
            try {
                valid.add(new URL(url));
            }
            catch (MalformedURLException e) {
                Console.warn(String.format("Problem whilst trying to make a URL from '%s'. This was probably due to malformed comma-separated-list in the %s entry of ${HOME}/.jalview-properties", Objects.toString(url, "<null>"), key));
                Console.debug("Exception occurred while reading url list", e);
            }
        }
        return valid;
    }

    @Override
    public void setUrls(List<URL> wsUrls) {
        String key = this.getUrlsPropertyKey();
        if (key == null) {
            throw new UnsupportedOperationException("setting urls not supported");
        }
        if (wsUrls != null && !wsUrls.isEmpty()) {
            CharSequence[] surls = new String[wsUrls.size()];
            Iterator<URL> iter = wsUrls.iterator();
            int i = 0;
            while (iter.hasNext()) {
                surls[i] = iter.next().toString();
                ++i;
            }
            Cache.setProperty(key, String.join((CharSequence)",", surls));
        } else {
            Cache.removeProperty(key);
        }
    }

    protected abstract String getUrlsPropertyKey();

    protected abstract URL getDefaultUrl();

    @Override
    public boolean hasServices() {
        return !this.isRunning() && this.services.size() > 0;
    }

    @Override
    public boolean isRunning() {
        return (this.state.get() & 6) != 0;
    }

    @Override
    public boolean isDone() {
        return this.state.get() == 1 && this.discoveryTask.isDone();
    }

    @Override
    public final synchronized CompletableFuture<List<WebService<?>>> startDiscoverer() {
        Console.debug("Requesting service discovery");
        do {
            if (this.state.get() != 4) continue;
            return this.discoveryTask;
        } while (!this.state.compareAndSet(1, 2) && !this.state.compareAndSet(2, 4));
        Console.debug("State changed to " + this.state.get());
        CompletableFuture<List<WebService<?>>> oldTask = this.discoveryTask;
        CompletionStage task = oldTask.handleAsync((_r, _e) -> {
            Console.info("Reloading services for " + this);
            this.services = Collections.emptyList();
            this.fireServicesChanged(this.services);
            ArrayList allServices = new ArrayList();
            for (URL url : this.getUrls()) {
                Console.info("Fetching list of services from " + url);
                try {
                    allServices.addAll(this.fetchServices(url));
                }
                catch (IOException e) {
                    Console.error("Failed to get services from " + url, e);
                }
            }
            this.services = allServices;
            return this.services;
        });
        ((CompletableFuture)task).handle((services, exception) -> {
            if (this.state.get() == 1) {
                throw new AssertionError();
            }
            if (this.state.compareAndSet(2, 1) || this.state.compareAndSet(4, 2)) {
                Console.debug("Discovery ended, state is " + this.state.get());
            }
            if (services != null) {
                this.fireServicesChanged((List<WebService<?>>)services);
            }
            return null;
        });
        Console.debug("Spawned task " + (CompletableFuture)task);
        Console.debug("Killing task " + oldTask);
        oldTask.cancel(false);
        this.discoveryTask = task;
        return this.discoveryTask;
    }

    protected abstract List<WebService<?>> fetchServices(URL var1) throws IOException;

    private void fireServicesChanged(List<WebService<?>> services) {
        for (WebServiceDiscovererI.ServicesChangeListener listener : this.listeners) {
            try {
                listener.servicesChanged(this, services);
            }
            catch (Exception e) {
                Console.warn(e.toString(), e);
            }
        }
    }

    @Override
    public final void addServicesChangeListener(WebServiceDiscovererI.ServicesChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public final void removeServicesChangeListener(WebServiceDiscovererI.ServicesChangeListener listener) {
        this.listeners.remove(listener);
    }

    public String toString() {
        return this.getClass().getName();
    }
}

