/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.ebi;

import compbio.util.FileUtil;
import jalview.datamodel.AlignmentI;
import jalview.io.AppletFormatAdapter;
import jalview.io.DataSourceType;
import jalview.io.FileFormat;
import jalview.io.FileParse;
import jalview.ws.ebi.HmmerJSONProcessor;
import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class hmmerClient {
    static String baseUrl = "http://www.ebi.ac.uk/Tools/hmmer";
    static String jackH = "/search/jackhmmer";
    static String phmmer = "/search/phmmer";
    static String hmmscan = "/search/hmmscan";
    static String hmmsearch = "/search/hmmsearch";
    static String edseq = ">2abl_A mol:protein length:163  ABL TYROSINE KINASE\nMGPSENDPNLFVALYDFVASGDNTLSITKGEKLRVLGYNHNGEWCEAQTKNGQGWVPSNYITPVNSLEKHS\nWYHGPVSRNAAEYLLSSGINGSFLVRESESSPGQRSISLRYEGRVYHYRINTASDGKLYVSSESRFNTLAE\nLVHHHSTVADGLITTLHYPAP";
    private static String[] _hmmsearchcols = new String[]{"acc", "name", ""};

    public static void main(String[] args) {
        String res;
        String instr = edseq;
        if (args.length > 0) {
            try {
                instr = FileUtil.readFileToString((File)new File(args[0]));
            }
            catch (Exception f) {
                f.printStackTrace();
                return;
            }
        }
        if ((res = new hmmerClient().submitJackhmmerSearch(instr, "jackhmmer", "pdb", 5)) == null) {
            throw new Error("Failed.");
        }
        System.out.println("Result\n" + res);
    }

    String submitJackhmmerSearch(String input, String algo, String db, int niter) {
        JSONObject inparam = new JSONObject();
        HttpPost jackhp = new HttpPost(baseUrl + jackH);
        String lastiter = null;
        try {
            inparam.put("algo", algo);
            inparam.put("seq", input);
            inparam.put("seqdb", db);
            inparam.put("iterations", niter);
            jackhp.setHeader("content-type", "application/json");
            jackhp.setEntity((HttpEntity)new StringEntity(inparam.toString()));
        }
        catch (Exception f) {
            f.printStackTrace();
            return null;
        }
        CloseableHttpResponse r = null;
        try {
            DefaultHttpClient httpCl = new DefaultHttpClient();
            r = httpCl.execute((HttpUriRequest)jackhp);
        }
        catch (Exception x) {
            System.err.println("Submit failed.");
            x.printStackTrace();
        }
        if (r.getStatusLine().getStatusCode() != 201) {
            throw new Error(r.toString());
        }
        String jobid = null;
        String redir = null;
        try {
            JSONObject res = new JSONObject(EntityUtils.toString((HttpEntity)r.getEntity()));
            jobid = res.getString("job_id");
            Header[] loc = r.getHeaders("Location");
            if (loc != null && loc.length > 0) {
                if (loc.length > 1) {
                    System.err.println("Ignoring additional " + (loc.length - 1) + " location(s) provided in response header ( next one is '" + loc[1].getValue() + "' )");
                }
                redir = loc[0].getValue();
            }
        }
        catch (Exception x) {
            System.err.println("job id extraction failed.");
            x.printStackTrace();
        }
        int tries = 0;
        boolean finished = false;
        JSONObject jobstate = null;
        block11: do {
            try {
                DefaultHttpClient httpCl = new DefaultHttpClient();
                HttpGet jackcheck = new HttpGet(redir);
                jackcheck.setHeader("content-type", "application/json");
                r = httpCl.execute((HttpUriRequest)jackcheck);
                switch (r.getStatusLine().getStatusCode()) {
                    case 200: {
                        Pattern p;
                        Matcher m;
                        JSONArray iters;
                        jobstate = new JSONObject(EntityUtils.toString((HttpEntity)r.getEntity()));
                        String st = jobstate.getString("status");
                        if ("DONE".equals(st)) {
                            finished = true;
                        }
                        if ("ERROR".equals(st)) {
                            System.err.println("Error");
                            finished = true;
                        }
                        if (!"PEND".equals(st) && !"RUN".equals("st") || (lastiter = (iters = jobstate.getJSONArray("result")).getJSONObject(iters.length() - 1).getString("uuid")).length() <= 0 || !(m = (p = Pattern.compile(".+(\\d+)")).matcher(lastiter)).matches()) continue block11;
                        System.out.println("On iteration " + m.group(1));
                        break;
                    }
                    default: {
                        ++tries;
                        Thread.sleep(2000L);
                    }
                }
            }
            catch (Exception q) {
                q.printStackTrace();
                return null;
            }
        } while (!finished && tries < 50);
        if (!finished) {
            System.err.println("Giving up with job " + jobid + " at " + redir);
            return null;
        }
        return lastiter;
    }

    AlignmentI retrieveJackhmmerResult(String jobid, AlignmentI dataset) throws OutOfMemoryError, IOException {
        AlignmentI searchResult = null;
        searchResult = new AppletFormatAdapter().readFile(baseUrl + "/download/" + jobid + "/score?format=afa&t=.gz", DataSourceType.URL, FileFormat.Fasta);
        FileParse jsonsource = new FileParse(baseUrl + "/download/" + jobid + "/score?format=json", DataSourceType.URL);
        if (!jsonsource.isValid()) {
            throw new IOException("Couldn't access scores for Jackhammer results");
        }
        this.readJackhmmerScores(searchResult, jsonsource);
        return searchResult;
    }

    private void readJackhmmerScores(AlignmentI searchResult, FileParse jsonsource) throws IOException, OutOfMemoryError {
        HmmerJSONProcessor hjp = new HmmerJSONProcessor(searchResult);
        hjp.parseFrom(jsonsource);
    }
}

