/*
 * Decompiled with CFR 0.152.
 */
package jalview.util;

import jalview.bin.Cache;
import jalview.bin.Console;
import jalview.datamodel.SequenceI;
import java.util.ArrayList;

public class Comparison {
    private static final int EIGHTY_FIVE = 85;
    private static final int NUCLEOTIDE_COUNT_PERCENT;
    private static final int NUCLEOTIDE_COUNT_LONG_SEQUENCE_AMBIGUITY_PERCENT;
    private static final int NUCLEOTIDE_COUNT_SHORT_SEQUENCE;
    private static final int NUCLEOTIDE_COUNT_VERY_SHORT_SEQUENCE;
    private static final boolean NUCLEOTIDE_AMBIGUITY_DETECTION;
    public static final char GAP_SPACE = ' ';
    public static final char GAP_DOT = '.';
    public static final char GAP_DASH = '-';
    public static final String GapChars;
    static final int caseShift = 32;

    public static final float compare(SequenceI ii, SequenceI jj) {
        return Comparison.compare(ii, jj, 0, ii.getLength() - 1);
    }

    public static float compare(SequenceI ii, SequenceI jj, int start, int end) {
        String si = ii.getSequenceAsString();
        String sj = jj.getSequenceAsString();
        int ilen = si.length() - 1;
        int jlen = sj.length() - 1;
        while (Comparison.isGap(si.charAt(start + ilen))) {
            --ilen;
        }
        while (Comparison.isGap(sj.charAt(start + jlen))) {
            --jlen;
        }
        int match = 0;
        float pid = -1.0f;
        if (ilen > jlen) {
            for (int j = 0; j < jlen; ++j) {
                if (!si.substring(start + j, start + j + 1).equals(sj.substring(start + j, start + j + 1))) continue;
                ++match;
            }
            pid = (float)match / (float)ilen * 100.0f;
        } else {
            for (int j = 0; j < jlen; ++j) {
                if (!si.substring(start + j, start + j + 1).equals(sj.substring(start + j, start + j + 1))) continue;
                ++match;
            }
            pid = (float)match / (float)jlen * 100.0f;
        }
        return pid;
    }

    @Deprecated
    public static final float PID(String seq1, String seq2) {
        return Comparison.PID(seq1, seq2, 0, seq1.length());
    }

    @Deprecated
    public static final float PID(String seq1, String seq2, int start, int end) {
        return Comparison.PID(seq1, seq2, start, end, true, false);
    }

    @Deprecated
    public static final float PID(String seq1, String seq2, int start, int end, boolean wcGaps, boolean ungappedOnly) {
        int s2len;
        int s1len = seq1.length();
        int len = Math.min(s1len, s2len = seq2.length());
        if (end < len) {
            len = end;
        }
        if (len < start) {
            start = len - 1;
        }
        int elen = len - start;
        int bad = 0;
        for (int i = start; i < len; ++i) {
            boolean agap;
            char chr1 = seq1.charAt(i);
            char chr2 = seq2.charAt(i);
            boolean bl = agap = Comparison.isGap(chr1) || Comparison.isGap(chr2);
            if ('a' <= chr1 && chr1 <= 'z') {
                chr1 = (char)(chr1 - 32);
            }
            if ('a' <= chr2 && chr2 <= 'z') {
                chr2 = (char)(chr2 - 32);
            }
            if (chr1 == chr2) continue;
            if (agap) {
                if (ungappedOnly) {
                    --elen;
                    continue;
                }
                if (wcGaps) continue;
                ++bad;
                continue;
            }
            ++bad;
        }
        if (elen < 1) {
            return 0.0f;
        }
        return 100.0f * (float)(elen - bad) / (float)elen;
    }

    public static final boolean isGap(char c) {
        return c == '-' || c == '.' || c == ' ';
    }

    public static final boolean isNucleotide(SequenceI seq) {
        if (seq == null || seq.getLength() == 0) {
            return false;
        }
        long ntCount = 0L;
        long aaCount = 0L;
        long nCount = 0L;
        long xCount = 0L;
        long ntaCount = 0L;
        int len = seq.getLength();
        for (int i = 0; i < len; ++i) {
            char c = seq.getCharAt(i);
            if (Comparison.isNucleotide(c)) {
                ++ntCount;
                continue;
            }
            if (Comparison.isGap(c)) continue;
            ++aaCount;
            if (Comparison.isN(c)) {
                ++nCount;
                continue;
            }
            if (Comparison.isX(c)) {
                ++xCount;
            }
            if (!Comparison.isNucleotideAmbiguity(c)) continue;
            ++ntaCount;
        }
        long allCount = ntCount + aaCount;
        if (NUCLEOTIDE_AMBIGUITY_DETECTION) {
            Console.debug("Performing new nucleotide detection routine");
            if (allCount > (long)NUCLEOTIDE_COUNT_SHORT_SEQUENCE) {
                return ntCount * 100L >= (long)NUCLEOTIDE_COUNT_PERCENT * allCount && 100L * (ntCount + nCount + ntaCount) >= (long)NUCLEOTIDE_COUNT_LONG_SEQUENCE_AMBIGUITY_PERCENT * allCount;
            }
            if (allCount > (long)NUCLEOTIDE_COUNT_VERY_SHORT_SEQUENCE) {
                if (ntCount * 100L >= (long)NUCLEOTIDE_COUNT_PERCENT * allCount && (nCount == aaCount || xCount == aaCount)) {
                    return true;
                }
                return Comparison.myShortSequenceNucleotideProportionCount(ntCount, allCount) && nCount + ntaCount == aaCount;
            }
            return ntCount > 0L && ntCount == allCount;
        }
        Console.debug("Performing old nucleotide detection routine");
        if ((ntCount + nCount) * 100L > 85L * allCount) {
            return ntCount > 0L;
        }
        return false;
    }

    protected static boolean myShortSequenceNucleotideProportionCount(long ntCount, long allCount) {
        long LHS = 100L * allCount * (long)(NUCLEOTIDE_COUNT_SHORT_SEQUENCE - NUCLEOTIDE_COUNT_VERY_SHORT_SEQUENCE) * (ntCount - allCount + 1L);
        long RHS = allCount * (allCount - (long)NUCLEOTIDE_COUNT_VERY_SHORT_SEQUENCE) * (allCount * (long)NUCLEOTIDE_COUNT_PERCENT - 100L * allCount + 100L);
        return LHS >= RHS;
    }

    public static final boolean isNucleotide(SequenceI[] seqs) {
        if (seqs == null) {
            return false;
        }
        boolean na = false;
        for (SequenceI seq : seqs) {
            if (seq == null) continue;
            na = true;
            if (!seq.isProtein()) continue;
            return false;
        }
        return na;
    }

    public static boolean isNucleotide(char c) {
        return Comparison.isNucleotide(c, false);
    }

    public static boolean isNucleotide(char c, boolean includeAmbiguity) {
        boolean ambiguity;
        char C = Character.toUpperCase(c);
        switch (C) {
            case 'A': 
            case 'C': 
            case 'G': 
            case 'T': 
            case 'U': {
                return true;
            }
        }
        return includeAmbiguity && (ambiguity = Comparison.isNucleotideAmbiguity(C));
    }

    public static boolean isNucleotideAmbiguity(char c) {
        switch (Character.toUpperCase(c)) {
            case 'B': 
            case 'D': 
            case 'H': 
            case 'I': 
            case 'K': 
            case 'M': 
            case 'R': 
            case 'S': 
            case 'V': 
            case 'W': 
            case 'X': 
            case 'Y': {
                return true;
            }
        }
        return false;
    }

    public static boolean isN(char c) {
        return 'n' == Character.toLowerCase(c);
    }

    public static boolean isX(char c) {
        return 'x' == Character.toLowerCase(c);
    }

    public static boolean isNucleotideSequence(String s, boolean allowGaps) {
        return Comparison.isNucleotideSequence(s, allowGaps, false);
    }

    public static boolean isNucleotideSequence(String s, boolean allowGaps, boolean includeAmbiguous) {
        if (s == null) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Comparison.isNucleotide(c, includeAmbiguous) || allowGaps && Comparison.isGap(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNucleotide(SequenceI[][] seqs) {
        if (seqs == null) {
            return false;
        }
        ArrayList<SequenceI> flattened = new ArrayList<SequenceI>();
        SequenceI[][] sequenceIArray = seqs;
        int n = sequenceIArray.length;
        for (int i = 0; i < n; ++i) {
            SequenceI[] ss;
            for (SequenceI s : ss = sequenceIArray[i]) {
                flattened.add(s);
            }
        }
        SequenceI[] oneDArray = flattened.toArray(new SequenceI[flattened.size()]);
        return Comparison.isNucleotide(oneDArray);
    }

    public static boolean isSameResidue(char c1, char c2, boolean caseSensitive) {
        return caseSensitive ? c1 == c2 : Character.toUpperCase(c1) == Character.toUpperCase(c2);
    }

    static {
        GapChars = new String(new char[]{' ', '.', '-'});
        NUCLEOTIDE_COUNT_PERCENT = Cache.getDefault("NUCLEOTIDE_COUNT_PERCENT", 55);
        NUCLEOTIDE_COUNT_LONG_SEQUENCE_AMBIGUITY_PERCENT = Cache.getDefault("NUCLEOTIDE_COUNT_LONG_SEQUENCE_AMBIGUITY_PERCENT", 95);
        NUCLEOTIDE_COUNT_SHORT_SEQUENCE = Cache.getDefault("NUCLEOTIDE_COUNT_SHORT", 100);
        NUCLEOTIDE_COUNT_VERY_SHORT_SEQUENCE = Cache.getDefault("NUCLEOTIDE_COUNT_VERY_SHORT", 4);
        NUCLEOTIDE_AMBIGUITY_DETECTION = Cache.getDefault("NUCLEOTIDE_AMBIGUITY_DETECTION", true);
    }
}

