/*
 * Decompiled with CFR 0.152.
 */
package jalview.schemes;

import jalview.api.AlignViewportI;
import jalview.bin.ApplicationSingletonProvider;
import jalview.bin.Console;
import jalview.datamodel.AnnotatedCollectionI;
import jalview.datamodel.SequenceCollectionI;
import jalview.datamodel.SequenceI;
import jalview.schemes.ColourSchemeI;
import jalview.schemes.JalviewColourScheme;
import jalview.util.ColorUtils;
import java.awt.Color;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

public class ColourSchemes
implements ApplicationSingletonProvider.ApplicationSingletonI {
    public Color[] rnaHelices = null;
    private Map<String, ColourSchemeI> schemes;

    public static ColourSchemes getInstance() {
        return ApplicationSingletonProvider.getInstance(ColourSchemes.class);
    }

    private ColourSchemes() {
        this.loadColourSchemes();
    }

    public static void resetRnaHelicesShading() {
        ColourSchemes.getInstance().rnaHelices = null;
    }

    public static void initRnaHelicesShading(int n) {
        int i = 0;
        ColourSchemes j = ColourSchemes.getInstance();
        if (j.rnaHelices == null) {
            j.rnaHelices = new Color[n + 1];
        } else if (j.rnaHelices != null && j.rnaHelices.length <= n) {
            Color[] t = new Color[n + 1];
            System.arraycopy(j.rnaHelices, 0, t, 0, j.rnaHelices.length);
            i = j.rnaHelices.length;
            j.rnaHelices = t;
        } else {
            return;
        }
        while (i <= n) {
            j.rnaHelices[i] = ColorUtils.generateRandomColor(Color.white);
            ++i;
        }
    }

    void loadColourSchemes() {
        this.schemes = new LinkedHashMap<String, ColourSchemeI>();
        for (JalviewColourScheme cs : JalviewColourScheme.values()) {
            try {
                this.registerColourScheme(cs.getSchemeClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (IllegalAccessException | InstantiationException e) {
                Console.errPrintln("Error instantiating colour scheme for " + cs.toString() + " " + e.getMessage());
                e.printStackTrace();
            }
            catch (ReflectiveOperationException roe) {
                roe.printStackTrace();
            }
        }
    }

    public void registerColourScheme(ColourSchemeI cs) {
        String name = cs.getSchemeName();
        if (name == null) {
            Console.errPrintln("ColourScheme name may not be null");
            return;
        }
        String lower = this.getColourSchemeShortName(cs);
        if (this.schemes.containsKey(lower)) {
            System.err.println("Warning: overwriting colour scheme named " + name);
        }
        this.schemes.put(lower, cs);
    }

    private String getColourSchemeShortName(ColourSchemeI cs) {
        return this.getColourSchemeShortName(cs.getSchemeName());
    }

    private String getColourSchemeShortName(String name) {
        if (name == null) {
            return null;
        }
        return name.toLowerCase(Locale.ROOT).replaceAll("%", "pc").replaceAll("[^a-z0-9]", "-").replaceAll("--+", "-");
    }

    public void removeColourScheme(String name) {
        if (name != null) {
            this.schemes.remove(this.getColourSchemeShortName(name));
        }
    }

    public ColourSchemeI getColourScheme(String name, AlignViewportI viewport, AnnotatedCollectionI forData, Map<SequenceI, SequenceCollectionI> hiddenRepSequences) {
        if (name == null) {
            return null;
        }
        ColourSchemeI cs = this.schemes.get(this.getColourSchemeShortName(name));
        return cs == null ? null : cs.getInstance(viewport, forData);
    }

    public ColourSchemeI getColourScheme(String name, AnnotatedCollectionI forData) {
        return this.getColourScheme(name, null, forData, null);
    }

    public Iterable<ColourSchemeI> getColourSchemes() {
        return this.schemes.values();
    }

    public boolean nameExists(String name) {
        if (name == null) {
            return false;
        }
        return this.schemes.containsKey(this.getColourSchemeShortName(name));
    }
}

