/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui.structurechooser;

import jalview.datamodel.DBRefEntry;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.SequenceI;
import jalview.fts.api.FTSData;
import jalview.fts.api.FTSDataColumnI;
import jalview.fts.core.FTSDataColumnPreferences;
import jalview.fts.core.FTSRestRequest;
import jalview.fts.core.FTSRestResponse;
import jalview.gui.structurechooser.PDBStructureChooserQuerySource;
import jalview.gui.structurechooser.ThreeDBStructureChooserQuerySource;
import jalview.jbgui.FilterOption;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.TableModel;

public abstract class StructureChooserQuerySource {
    protected FTSDataColumnPreferences docFieldPrefs;
    protected static int MAX_QLENGTH = 7820;

    public static StructureChooserQuerySource getPDBfts() {
        return new PDBStructureChooserQuerySource();
    }

    public static StructureChooserQuerySource getTDBfts() {
        return new ThreeDBStructureChooserQuerySource();
    }

    public FTSDataColumnPreferences getDocFieldPrefs() {
        return this.docFieldPrefs;
    }

    public void setDocFieldPrefs(FTSDataColumnPreferences docFieldPrefs) {
        this.docFieldPrefs = docFieldPrefs;
    }

    public FTSDataColumnPreferences getInitialFieldPreferences() {
        return this.docFieldPrefs;
    }

    public abstract String buildQuery(SequenceI var1);

    public static String sanitizeSeqName(String seqName) {
        Objects.requireNonNull(seqName);
        return seqName.replaceAll("\\[\\d*\\]", "").replaceAll("[^\\dA-Za-z|_]", "").replaceAll("\\s+", "+");
    }

    static boolean isValidSeqName(String seqName) {
        String ignoreList = "pdb,uniprot,swiss-prot";
        if (seqName.length() < 3) {
            return false;
        }
        if (seqName.contains(":")) {
            return false;
        }
        seqName = seqName.toLowerCase(Locale.ROOT);
        for (String ignoredEntry : ignoreList.split(",")) {
            if (!seqName.contains(ignoredEntry)) continue;
            return false;
        }
        return true;
    }

    static String getDBRefId(DBRefEntry dbRef) {
        String ref = dbRef.getAccessionId().replaceAll("GO:", "");
        return ref;
    }

    static PDBEntry getFindEntry(String id, Vector<PDBEntry> pdbEntries) {
        Objects.requireNonNull(id);
        Objects.requireNonNull(pdbEntries);
        PDBEntry foundEntry = null;
        for (PDBEntry entry : pdbEntries) {
            if (!entry.getId().equalsIgnoreCase(id)) continue;
            return entry;
        }
        return foundEntry;
    }

    public abstract FTSRestResponse fetchStructuresMetaData(SequenceI var1, Collection<FTSDataColumnI> var2, FilterOption var3, boolean var4) throws Exception;

    public abstract FTSRestResponse selectFirstRankedQuery(SequenceI var1, Collection<FTSData> var2, Collection<FTSDataColumnI> var3, String var4, boolean var5) throws Exception;

    public TableModel getTableModel(Collection<FTSData> discoveredStructuresSet) {
        return FTSRestResponse.getTableModel(this.getLastFTSRequest(), discoveredStructuresSet);
    }

    protected abstract FTSRestRequest getLastFTSRequest();

    public abstract PDBEntry[] collectSelectedRows(JTable var1, int[] var2, List<SequenceI> var3);

    public abstract List<FilterOption> getAvailableFilterOptions(String var1);

    public static StructureChooserQuerySource getQuerySourceFor(SequenceI[] selectedSeqs) {
        ThreeDBStructureChooserQuerySource tdbSource = new ThreeDBStructureChooserQuerySource();
        boolean hasUniprot = false;
        boolean hasCanonical = false;
        boolean hasNA = false;
        boolean hasProtein = false;
        int protWithoutUni = 0;
        int protWithoutCanon = 0;
        for (SequenceI seq : selectedSeqs) {
            hasNA |= !seq.isProtein();
            hasProtein |= seq.isProtein();
            if (!seq.isProtein()) continue;
            int refsAvailable = ThreeDBStructureChooserQuerySource.checkUniprotRefs(seq.getDBRefs());
            if (refsAvailable > -2) {
                if (refsAvailable > -1) {
                    hasCanonical = true;
                } else {
                    ++protWithoutCanon;
                }
                hasUniprot = true;
                continue;
            }
            ++protWithoutUni;
        }
        if (hasProtein && hasCanonical && !hasNA && protWithoutCanon == 0 && protWithoutUni == 0) {
            return tdbSource;
        }
        return new PDBStructureChooserQuerySource();
    }

    public abstract boolean needsRefetch(FilterOption var1);

    public void updateAvailableFilterOptions(String VIEWS_FILTER, List<FilterOption> xtantOptions, Collection<FTSData> lastFTSData) {
    }
}

