/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel.features;

import intervalstore.api.IntervalStoreI;
import intervalstore.impl.BinarySearcher;
import intervalstore.impl.IntervalStore;
import jalview.bin.Console;
import jalview.datamodel.SequenceFeature;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FeatureStore {
    List<SequenceFeature> nonPositionalFeatures;
    List<SequenceFeature> contactFeatureStarts;
    List<SequenceFeature> contactFeatureEnds;
    IntervalStoreI<SequenceFeature> features = new IntervalStore();
    Set<String> positionalFeatureGroups = new HashSet<String>();
    Set<String> nonPositionalFeatureGroups = new HashSet<String>();
    int totalExtent;
    float positionalMinScore = Float.NaN;
    float positionalMaxScore = Float.NaN;
    float nonPositionalMinScore = Float.NaN;
    float nonPositionalMaxScore = Float.NaN;

    public boolean addFeature(SequenceFeature feature) {
        if (this.contains(feature)) {
            return false;
        }
        if (!feature.isNonPositional()) {
            this.positionalFeatureGroups.add(feature.getFeatureGroup());
        }
        if (feature.isContactFeature()) {
            this.addContactFeature(feature);
        } else if (feature.isNonPositional()) {
            this.addNonPositionalFeature(feature);
        } else {
            this.addNestedFeature(feature);
        }
        this.totalExtent += FeatureStore.getFeatureLength(feature);
        float score = feature.getScore();
        if (!Float.isNaN(score)) {
            if (feature.isNonPositional()) {
                this.nonPositionalMinScore = FeatureStore.min(this.nonPositionalMinScore, score);
                this.nonPositionalMaxScore = FeatureStore.max(this.nonPositionalMaxScore, score);
            } else {
                this.positionalMinScore = FeatureStore.min(this.positionalMinScore, score);
                this.positionalMaxScore = FeatureStore.max(this.positionalMaxScore, score);
            }
        }
        return true;
    }

    public boolean contains(SequenceFeature feature) {
        if (feature.isNonPositional()) {
            return this.nonPositionalFeatures == null ? false : this.nonPositionalFeatures.contains(feature);
        }
        if (feature.isContactFeature()) {
            return this.contactFeatureStarts == null ? false : FeatureStore.listContains(this.contactFeatureStarts, feature);
        }
        return this.features == null ? false : this.features.contains((Object)feature);
    }

    protected static int getFeatureLength(SequenceFeature feature) {
        if (feature.isNonPositional()) {
            return 0;
        }
        if (feature.isContactFeature()) {
            return 1;
        }
        return 1 + feature.getEnd() - feature.getBegin();
    }

    protected boolean addNonPositionalFeature(SequenceFeature feature) {
        if (this.nonPositionalFeatures == null) {
            this.nonPositionalFeatures = new ArrayList<SequenceFeature>();
        }
        this.nonPositionalFeatures.add(feature);
        this.nonPositionalFeatureGroups.add(feature.getFeatureGroup());
        return true;
    }

    protected synchronized void addNestedFeature(SequenceFeature feature) {
        if (this.features == null) {
            this.features = new IntervalStore();
        }
        this.features.add((Object)feature);
    }

    protected synchronized boolean addContactFeature(SequenceFeature feature) {
        if (this.contactFeatureStarts == null) {
            this.contactFeatureStarts = new ArrayList<SequenceFeature>();
        }
        if (this.contactFeatureEnds == null) {
            this.contactFeatureEnds = new ArrayList<SequenceFeature>();
        }
        int insertPosition = BinarySearcher.findFirst(this.contactFeatureStarts, (boolean)true, (BinarySearcher.Compare)BinarySearcher.Compare.GE, (int)feature.getBegin());
        this.contactFeatureStarts.add(insertPosition, feature);
        insertPosition = BinarySearcher.findFirst(this.contactFeatureEnds, (boolean)false, (BinarySearcher.Compare)BinarySearcher.Compare.GE, (int)feature.getEnd());
        this.contactFeatureEnds.add(insertPosition, feature);
        return true;
    }

    protected static boolean listContains(List<SequenceFeature> features, SequenceFeature feature) {
        if (features == null || feature == null) {
            return false;
        }
        int len = features.size();
        for (int pos = BinarySearcher.findFirst(features, (boolean)true, (BinarySearcher.Compare)BinarySearcher.Compare.GE, (int)feature.getBegin()); pos < len; ++pos) {
            SequenceFeature sf = features.get(pos);
            if (sf.getBegin() > feature.getBegin()) {
                return false;
            }
            if (!sf.equals(feature)) continue;
            return true;
        }
        return false;
    }

    public List<SequenceFeature> findOverlappingFeatures(long start, long end) {
        ArrayList<SequenceFeature> result = new ArrayList<SequenceFeature>();
        this.findContactFeatures(start, end, result);
        if (this.features != null) {
            result.addAll(this.features.findOverlaps(start, end));
        }
        return result;
    }

    protected void findContactFeatures(long from, long to, List<SequenceFeature> result) {
        if (this.contactFeatureStarts != null) {
            this.findContactStartOverlaps(from, to, result);
        }
        if (this.contactFeatureEnds != null) {
            this.findContactEndOverlaps(from, to, result);
        }
    }

    protected void findContactEndOverlaps(long from, long to, List<SequenceFeature> result) {
        int index = BinarySearcher.findFirst(this.contactFeatureEnds, (boolean)false, (BinarySearcher.Compare)BinarySearcher.Compare.GE, (int)((int)from));
        while (index < this.contactFeatureEnds.size()) {
            SequenceFeature sf = this.contactFeatureEnds.get(index);
            if (!sf.isContactFeature()) {
                Console.errPrintln("Error! non-contact feature type " + sf.getType() + " in contact features list");
                ++index;
                continue;
            }
            int begin = sf.getBegin();
            if ((long)begin >= from && (long)begin <= to) {
                ++index;
                continue;
            }
            if ((long)sf.getEnd() > to) break;
            result.add(sf);
            ++index;
        }
    }

    protected void findContactStartOverlaps(long from, long to, List<SequenceFeature> result) {
        int index = BinarySearcher.findFirst(this.contactFeatureStarts, (boolean)true, (BinarySearcher.Compare)BinarySearcher.Compare.GE, (int)((int)from));
        while (index < this.contactFeatureStarts.size()) {
            SequenceFeature sf = this.contactFeatureStarts.get(index);
            if (!sf.isContactFeature()) {
                Console.errPrintln("Error! non-contact feature " + sf.toString() + " in contact features list");
                ++index;
                continue;
            }
            if ((long)sf.getBegin() > to) break;
            result.add(sf);
            ++index;
        }
    }

    public List<SequenceFeature> getPositionalFeatures() {
        ArrayList<SequenceFeature> result = new ArrayList<SequenceFeature>();
        if (this.contactFeatureStarts != null) {
            result.addAll(this.contactFeatureStarts);
        }
        if (this.features != null) {
            result.addAll((Collection<SequenceFeature>)this.features);
        }
        return result;
    }

    public List<SequenceFeature> getContactFeatures() {
        if (this.contactFeatureStarts == null) {
            return Collections.emptyList();
        }
        return new ArrayList<SequenceFeature>(this.contactFeatureStarts);
    }

    public List<SequenceFeature> getNonPositionalFeatures() {
        if (this.nonPositionalFeatures == null) {
            return Collections.emptyList();
        }
        return new ArrayList<SequenceFeature>(this.nonPositionalFeatures);
    }

    public synchronized boolean delete(SequenceFeature sf) {
        boolean removed = false;
        if (!removed && this.contactFeatureStarts != null && (removed = this.contactFeatureStarts.remove(sf))) {
            this.contactFeatureEnds.remove(sf);
        }
        boolean removedNonPositional = false;
        if (!removed && this.nonPositionalFeatures != null) {
            removed = removedNonPositional = this.nonPositionalFeatures.remove(sf);
        }
        if (!removed && this.features != null) {
            removed = this.features.remove((Object)sf);
        }
        if (removed) {
            this.rescanAfterDelete();
        }
        return removed;
    }

    protected synchronized void rescanAfterDelete() {
        float score;
        this.positionalFeatureGroups.clear();
        this.nonPositionalFeatureGroups.clear();
        this.totalExtent = 0;
        this.positionalMinScore = Float.NaN;
        this.positionalMaxScore = Float.NaN;
        this.nonPositionalMinScore = Float.NaN;
        this.nonPositionalMaxScore = Float.NaN;
        for (SequenceFeature sf : this.getNonPositionalFeatures()) {
            this.nonPositionalFeatureGroups.add(sf.getFeatureGroup());
            score = sf.getScore();
            this.nonPositionalMinScore = FeatureStore.min(this.nonPositionalMinScore, score);
            this.nonPositionalMaxScore = FeatureStore.max(this.nonPositionalMaxScore, score);
        }
        for (SequenceFeature sf : this.getPositionalFeatures()) {
            this.positionalFeatureGroups.add(sf.getFeatureGroup());
            score = sf.getScore();
            this.positionalMinScore = FeatureStore.min(this.positionalMinScore, score);
            this.positionalMaxScore = FeatureStore.max(this.positionalMaxScore, score);
            this.totalExtent += FeatureStore.getFeatureLength(sf);
        }
    }

    protected static float min(float f1, float f2) {
        if (Float.isNaN(f1)) {
            return Float.isNaN(f2) ? f1 : f2;
        }
        return Float.isNaN(f2) ? f1 : Math.min(f1, f2);
    }

    protected static float max(float f1, float f2) {
        if (Float.isNaN(f1)) {
            return Float.isNaN(f2) ? f1 : f2;
        }
        return Float.isNaN(f2) ? f1 : Math.max(f1, f2);
    }

    public boolean isEmpty() {
        boolean hasFeatures = this.contactFeatureStarts != null && !this.contactFeatureStarts.isEmpty() || this.nonPositionalFeatures != null && !this.nonPositionalFeatures.isEmpty() || this.features != null && this.features.size() > 0;
        return !hasFeatures;
    }

    public Set<String> getFeatureGroups(boolean positionalFeatures) {
        if (positionalFeatures) {
            return Collections.unmodifiableSet(this.positionalFeatureGroups);
        }
        return this.nonPositionalFeatureGroups == null ? Collections.emptySet() : Collections.unmodifiableSet(this.nonPositionalFeatureGroups);
    }

    public int getFeatureCount(boolean positional) {
        if (!positional) {
            return this.nonPositionalFeatures == null ? 0 : this.nonPositionalFeatures.size();
        }
        int size = 0;
        if (this.contactFeatureStarts != null) {
            size += this.contactFeatureStarts.size();
        }
        if (this.features != null) {
            size += this.features.size();
        }
        return size;
    }

    public int getTotalFeatureLength() {
        return this.totalExtent;
    }

    public float getMinimumScore(boolean positional) {
        return positional ? this.positionalMinScore : this.nonPositionalMinScore;
    }

    public float getMaximumScore(boolean positional) {
        return positional ? this.positionalMaxScore : this.nonPositionalMaxScore;
    }

    public List<SequenceFeature> getFeaturesForGroup(boolean positional, String group) {
        ArrayList<SequenceFeature> result = new ArrayList<SequenceFeature>();
        if (positional && !this.positionalFeatureGroups.contains(group) || !positional && !this.nonPositionalFeatureGroups.contains(group)) {
            return result;
        }
        List<SequenceFeature> sfs = positional ? this.getPositionalFeatures() : this.getNonPositionalFeatures();
        for (SequenceFeature sf : sfs) {
            String featureGroup = sf.getFeatureGroup();
            if ((group != null || featureGroup != null) && (group == null || !group.equals(featureGroup))) continue;
            result.add(sf);
        }
        return result;
    }

    public synchronized boolean shiftFeatures(int fromPosition, int shiftBy) {
        boolean modified = false;
        for (SequenceFeature sf : this.getPositionalFeatures()) {
            if (sf.getBegin() < fromPosition) continue;
            modified = true;
            int newBegin = sf.getBegin() + shiftBy;
            int newEnd = sf.getEnd() + shiftBy;
            if (newEnd > 0) {
                newBegin = Math.max(1, newBegin);
                SequenceFeature sf2 = new SequenceFeature(sf, newBegin, newEnd, sf.getFeatureGroup(), sf.getScore());
                this.addFeature(sf2);
            }
            this.delete(sf);
        }
        return modified;
    }
}

